/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.AbstractDetailForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class LoopDetailForm
extends AbstractDetailForm
implements ModifyListener,
SelectionListener {
    protected static final int HELP_PAGE_CONTROL = 1;
    protected static final int HELP_ITERATION_CONTROL = 2;
    protected static final int HELP_SYNCHRONOUS_CONTROL = 3;
    private Button synchronousButton;
    private Text iteractionsText;
    private ILoop loop;

    public void dispose() {
        this.loop = null;
    }

    public Control createControl(Composite parent, FormToolkit widgetFactory, IDetailPageContext context) {
        this.context = context;
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.synchronousButton = widgetFactory.createButton(composite, this.getSynchronousLabel(), 32);
        this.synchronousButton.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite, this.getIteractionsLabel());
        this.iteractionsText = widgetFactory.createText(composite, this.getIteractionsLabel());
        this.iteractionsText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.paintBordersFor(composite);
        this.registerHelp(1, composite);
        this.registerHelp(2, this.iteractionsText);
        this.registerHelp(3, this.synchronousButton);
        return composite;
    }

    protected abstract String getSynchronousLabel();

    protected abstract String getIteractionsLabel();

    protected void registerHelp(int flag, Object object) {
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.loop = null;
        this.synchronousButton.removeSelectionListener((SelectionListener)this);
        this.iteractionsText.removeVerifyListener((VerifyListener)this);
        this.iteractionsText.removeModifyListener((ModifyListener)this);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof ILoop) {
            this.loop = (ILoop)object;
            String value = this.loop.getCondition().getConstraint();
            if (value != null) {
                this.iteractionsText.setText(value);
            } else {
                this.iteractionsText.setText("");
            }
            this.synchronousButton.setSelection(this.loop.isSynchronous());
            this.iteractionsText.setEditable(true);
        } else {
            this.synchronousButton.setEnabled(false);
            this.iteractionsText.setText("");
        }
        this.synchronousButton.addSelectionListener((SelectionListener)this);
        this.iteractionsText.addVerifyListener((VerifyListener)this);
        this.iteractionsText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.loop;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isReadOnly()) {
            e.doit = false;
        } else if (e.widget == this.synchronousButton) {
            this.loop.setSynchronous(this.synchronousButton.getSelection());
            if (this.getEditorForm().getFormEditor() instanceof BaseEditorExtension) {
                ((BaseEditorExtension)this.getEditorForm().getFormEditor()).markDirty();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.iteractionsText) {
            this.loop.getCondition().setConstraint(this.iteractionsText.getText());
            if (this.getEditorForm().getFormEditor() instanceof BaseEditorExtension) {
                ((BaseEditorExtension)this.getEditorForm().getFormEditor()).markDirty();
            }
        }
    }

    public void verifyText(VerifyEvent e) {
        super.verifyKey(e);
        UIUtil.integerStyledTextVerifyKey((VerifyEvent)e);
    }

    public void selectReveal(ISelection selection) {
    }

    public IStructuredSelection getStructuredSelection() {
        return null;
    }
}

