/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class TestInvocationDetailPage
extends AbstractDetailPage
implements SelectionListener,
IHyperlinkListener {
    protected static final int HELP_PAGE_CONTROL = 1;
    protected static final int HELP_SYNCHRONOUS_CONTROL = 2;
    protected static final int HELP_FILE_CONTROL = 3;
    protected static final int HELP_EDIT_CONTROL = 4;
    protected static final int HELP_TYPE_CONTROL = 5;
    private Button synchronousButton;
    private SelectableFormLabel testLink;
    private Label imageLabel;
    private StyledText typeText;
    private StyledText fileText;
    private Button editButton;
    private ITestInvocation testInvocation;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.testInvocation = null;
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context) {
        this.context = context;
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.synchronousButton = widgetFactory.createButton(composite, this.getSynchronousLabel(), 32);
        this.synchronousButton.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.createTestLink(composite);
        this.registerHelp(1, composite);
        this.registerHelp(1, this.synchronousButton);
        this.registerHelp(1, this.fileText);
        this.registerHelp(1, this.editButton);
        this.registerHelp(1, this.typeText);
        return composite;
    }

    protected abstract String getSynchronousLabel();

    protected void registerHelp(int flag, Object object) {
    }

    protected void createTestLink(Composite parent) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite linkComposite = widgetFactory.createComposite(composite);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        linkComposite.setLayout((Layout)gridLayout);
        linkComposite.setLayoutData((Object)new GridData(768));
        this.imageLabel = widgetFactory.createLabel(linkComposite, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        Composite testLinkComposite = widgetFactory.createComposite(linkComposite);
        testLinkComposite.setLayoutData((Object)new GridData(768));
        this.testLink = widgetFactory.createSelectableLabel(testLinkComposite, null);
        this.testLink.setText(this.getDefaultLinkText());
        this.testLink.setToolTipText(this.getDefaultLinkToolTip());
        this.testLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        widgetFactory.turnIntoHyperlink((Control)this.testLink, (IHyperlinkListener)this);
        this.editButton = widgetFactory.createButton(linkComposite, UiPluginResourceBundle.label_Update, 8);
        this.editButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Composite detailComposite = widgetFactory.createComposite(composite);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        detailComposite.setLayout((Layout)gridLayout);
        detailComposite.setLayoutData((Object)GridDataUtil.createFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.LBL_TYPE);
        this.typeText = widgetFactory.createStyledText(detailComposite, 65540);
        this.typeText.setEditable(false);
        this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.LBL_FILE);
        this.fileText = widgetFactory.createStyledText(detailComposite, 65540);
        this.fileText.setEditable(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.paintBordersFor(detailComposite);
    }

    protected String getDefaultLinkText() {
        return "x";
    }

    protected String getDefaultLinkToolTip() {
        return "";
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.testInvocation = null;
        this.synchronousButton.removeSelectionListener((SelectionListener)this);
        this.editButton.removeSelectionListener((SelectionListener)this);
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean doPack = false;
        boolean testIsSet = false;
        if (object instanceof ITestInvocation) {
            this.testInvocation = (ITestInvocation)object;
            ITest test = this.testInvocation.getInvokedTest();
            doPack = true;
            this.editButton.setEnabled(true);
            this.synchronousButton.setSelection(this.testInvocation.isSynchronous());
            this.synchronousButton.setEnabled(true);
            if (test != null) {
                IWorkbenchAdapter workbenchAdapter;
                testIsSet = true;
                ImageDescriptor imageDescriptor = null;
                if (test instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)test).getAdapter(IWorkbenchAdapter.class)) != null) {
                    imageDescriptor = workbenchAdapter.getImageDescriptor((Object)test);
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (test.getName() != null) {
                    this.testLink.setText(test.getName());
                } else {
                    this.testLink.setText(ToolsUiPluginResourceBundle.W_TEST);
                }
                this.testLink.setData((Object)test);
                String value = test.getType();
                if (value != null) {
                    IAssociationDescriptor descriptor = null;
                    if (test instanceof ITestSuite) {
                        descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    } else if (test instanceof ITestCase) {
                        descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    }
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)((EObject)test)));
            }
        } else {
            this.editButton.setEnabled(false);
        }
        if (!testIsSet) {
            doPack = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(this.getDefaultLinkText());
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
            this.synchronousButton.setEnabled(false);
        }
        if (doPack) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
        this.editButton.addSelectionListener((SelectionListener)this);
        this.synchronousButton.addSelectionListener((SelectionListener)this);
    }

    public Object getInput() {
        return this.testInvocation;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isReadOnly()) {
            e.doit = false;
        } else if (e.widget == this.editButton) {
            ITestSuite testSuite = (ITestSuite)EcoreUtil.getRootContainer((EObject)((EObject)this.testInvocation));
            InvokedTestSelectionDialog selectionDialog = this.createInvokedTestSelectionDialog(testSuite);
            selectionDialog.setTest((ITest)this.testLink.getData());
            if (selectionDialog.open() == 0) {
                ITest test = (ITest)selectionDialog.getTests().iterator().next();
                ResourceSet resourceSet = ((EObject)testSuite).eResource().getResourceSet();
                test = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)test), (boolean)true);
                if (this.testInvocation.getInvokedTest() != test) {
                    this.testInvocation.setInvokedTest(test);
                    this.setInput(this.testInvocation);
                }
            }
        } else if (e.widget == this.synchronousButton) {
            this.testInvocation.setSynchronous(this.synchronousButton.getSelection());
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    public void linkActivated(Control linkLabel) {
        IActionBars actionBars;
        IStatusLineManager manager;
        Object data = linkLabel.getData();
        TestSuiteEditorExtension ext = (TestSuiteEditorExtension)this.getEditorForm().getBaseEditorExtension();
        if (data != null) {
            EObject eObject = (EObject)data;
            if (eObject instanceof TPFTestSuite) {
                IEditorPart editorPart = TestUIUtil.openEditor((Resource)eObject.eResource(), null, (boolean)false);
                if (editorPart instanceof ISelectionProvider) {
                    ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
                }
                return;
            }
            if (eObject instanceof TPFTestCase) {
                TPFTestCase tc = (TPFTestCase)eObject;
                Object editorObject = ext.getHyadesEditorPart().getEditorObject();
                if (editorObject != tc.getTestSuite()) {
                    IEditorPart editorPart = TestUIUtil.openEditor((Resource)eObject.eResource(), null, (boolean)false);
                    if (editorPart instanceof IHyadesEditorPart) {
                        IHyadesEditorPart hep = (IHyadesEditorPart)editorPart;
                        hep.setActivePage(1);
                    }
                } else {
                    IHyadesEditorPart editorPart = ext.getHyadesEditorPart();
                    editorPart.setActivePage(1);
                }
                ext.getTestCasesForm().selectReveal((ISelection)new StructuredSelection((Object)eObject));
                return;
            }
        }
        if ((manager = (actionBars = ext.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars()).getStatusLineManager()) != null) {
            manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);
        }
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }
}

