/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddBlockChildAction;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;

public abstract class AddTestInvocation
extends AddBlockChildAction {
    public AddTestInvocation(IITestSuiteProvider testSuiteProvider, String baseName) {
        super(testSuiteProvider, ToolsUiPluginResourceBundle.LBL_INV, baseName);
        this.setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("invocation.gif"));
    }

    public void run() {
        this.setActionPerformed(false);
        InvokedTestSelectionDialog selectionDialog = this.createInvokedTestSelectionDialog(this.getTestSuite());
        if (selectionDialog.open() == 0) {
            for (ITest test : selectionDialog.getTests()) {
                ResourceSet resourceSet = ((EObject)this.getTestSuite()).eResource().getResourceSet();
                test = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)test), (boolean)true);
                ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation(test);
                testInvocation.setName(this.calculateName(test));
                this.getBlock().getActions().add(testInvocation);
            }
            this.setActionPerformed(true);
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    protected String calculateName(ITest test) {
        String testName = test.getName();
        if (testName == null) {
            return TestCommonUtil.getUniqueName((String)this.getBaseName(), (List)this.getBlock().getActions());
        }
        if (test instanceof ITestCase) {
            String testSuiteName;
            ITestSuite invokedTestSuite = ((ITestCase)test).getOwner();
            if (this.getTestSuite() != invokedTestSuite && (testSuiteName = invokedTestSuite.getName()) != null) {
                testName = String.valueOf(testSuiteName) + "." + testName;
            }
        }
        return testName.concat(" - ").concat(this.getBaseName());
    }
}

