/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionListenerAction;

public class BehaviorActionGroup
extends ActionGroup {
    private IITestSuiteProvider testSuiteProvider;
    protected List actions;
    String menuLabel;

    public BehaviorActionGroup(IITestSuiteProvider testSuiteProvider, String menuLabel) {
        this.testSuiteProvider = testSuiteProvider;
        this.actions = new ArrayList();
        this.menuLabel = menuLabel;
    }

    public void dispose() {
        CoreUtil.dispose((Collection)this.actions);
        this.testSuiteProvider = null;
        super.dispose();
    }

    public void addAction(SelectionListenerAction selectionListenerAction) {
        this.actions.add(selectionListenerAction);
    }

    public void removeAction(SelectionListenerAction selectionListenerAction) {
        this.actions.remove(selectionListenerAction);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public void fillContextMenu(IMenuManager menuManager) {
        this.fillContextMenu(menuManager, true);
    }

    public void fillContextMenu(IMenuManager menuManager, boolean createSubMenu) {
        if (this.actions.isEmpty()) {
            return;
        }
        this.adjustContext();
        IMenuManager addMenu = null;
        if (createSubMenu) {
            addMenu = new MenuManager(this.menuLabel);
            menuManager.add((IContributionItem)addMenu);
        } else {
            addMenu = menuManager;
        }
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            addMenu.add((IAction)i.next());
        }
    }

    public void fillContextMenu(Menu menu, boolean clearMenu) {
        if (clearMenu) {
            MenuItem[] menuItems = menu.getItems();
            int i = 0;
            int maxi = menuItems.length;
            while (i < maxi) {
                menuItems[i].dispose();
                ++i;
            }
        }
        if (this.actions.isEmpty()) {
            return;
        }
        this.adjustContext();
        int count = 0;
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            new ActionContributionItem((IAction)i.next()).fill(menu, count++);
        }
    }

    protected void adjustContext() {
        IStructuredSelection structuredSelection = null;
        if (this.getContext() != null) {
            structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        }
        if (structuredSelection == null || structuredSelection.isEmpty() || !(structuredSelection instanceof TreeSelection)) {
            structuredSelection = new StructuredSelection((Object)this.testSuiteProvider.getTestSuite());
        }
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            ((SelectionListenerAction)i.next()).selectionChanged(structuredSelection);
        }
    }

    public void disableActions() {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            ((IAction)i.next()).setEnabled(false);
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context != null) {
            this.adjustContext();
        }
    }

    public boolean isEnabled() {
        for (SelectionListenerAction action : this.actions) {
            if (action.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

