/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.http.runner.HttpExecutor;
import org.eclipse.hyades.test.http.runner.HttpResponse;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CheckTestCaseAction
extends BaseSelectionListenerAction
implements IDisposable {
    private RequestHelper requestHelper = null;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    public CheckTestCaseAction() {
        super(ToolsUiPluginResourceBundle.HTTP_TEST_ACTION_TEXT);
        this.setToolTipText(ToolsUiPluginResourceBundle.HTTP_TEST_ACTION_TOOL_TIP);
    }

    public void run() {
        if (this.requestHelper != null) {
            if (this.requestHelper.getAttribute(1) == null) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)ToolsUiPluginResourceBundle.HTTP_TEST_MISSING_HOST_ERROR);
            } else {
                String attribute = this.requestHelper.getAttribute(3);
                if (attribute == null || !attribute.startsWith("/")) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)ToolsUiPluginResourceBundle.HTTP_TEST_INVALID_PATH_ERROR);
                } else {
                    try {
                        String testResultsString;
                        String body;
                        String details;
                        long pageResponseTime;
                        long elapsedTime;
                        int contentLength;
                        String contentType;
                        HttpResponse response = new HttpExecutor().execute(this.requestHelper.createHttpRequest());
                        StringBuffer testResults = new StringBuffer();
                        int code = response.getCode();
                        if (code != -1) {
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_RESPONSE_CODE, (Object)code));
                        }
                        if ((contentType = response.getContentType()) != null && contentType.trim().length() > 0) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_CONTENT_TYPE, (Object)contentType));
                        }
                        if ((contentLength = response.getContentLength()) != -1) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_CONTENT_LENGTH, (Object)contentLength));
                        }
                        if ((elapsedTime = response.getElapsedTime()) != -1L) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_ELAPSED_TIME, (Object)elapsedTime));
                        }
                        if ((pageResponseTime = response.getPageResponseTime()) != -1L) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_PAGE_RESPONSE_TIME, (Object)pageResponseTime));
                        }
                        if ((details = response.getDetail()) != null && details.trim().length() > 0) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_DETAILS, (Object)details));
                        }
                        if ((body = response.getBody()) != null && body.trim().length() > 0) {
                            testResults.append(LINE_SEPARATOR);
                            testResults.append(NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_RESULTS_BODY, (Object)body));
                        }
                        if ((testResultsString = testResults.toString().trim()).length() == 0) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)ToolsUiPluginResourceBundle.HTTP_TEST_INVALID_RESPONSE_ERROR);
                        } else {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)ToolsUiPluginResourceBundle.HTTP_TEST_DIALOG_TITLE, (String)testResultsString);
                        }
                    }
                    catch (Throwable t) {
                        ToolsUiPlugin.logError(t);
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)NLS.bind((String)ToolsUiPluginResourceBundle.HTTP_TEST_ERROR, (Object)t.getLocalizedMessage()));
                    }
                }
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection structuredSelection) {
        Object firstElement;
        if (this.requestHelper != null) {
            this.requestHelper.dispose();
            this.requestHelper = null;
        }
        if (structuredSelection != null && !structuredSelection.isEmpty() && (firstElement = structuredSelection.getFirstElement()) instanceof ITestCase) {
            this.requestHelper = new RequestHelper();
            this.requestHelper.setTestCase((ITestCase)firstElement);
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.requestHelper != null) {
            this.requestHelper.dispose();
            this.requestHelper = null;
        }
    }
}

