/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.CheckTestCaseAction;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpEditorExtension;
import org.eclipse.hyades.test.tools.ui.http.internal.junit.editor.HttpTestCaseDetailPage;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.actions.OpenTestMethodAction;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class HttpTestCasesForm
extends TestCasesForm {
    private StaticDetailPageProvider detailPageProvider;

    public HttpTestCasesForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory) {
        super(httpEditorExtension, widgetFactory);
        this.setHeadingText(ToolsUiPluginResourceBundle.URL_EDT_GENERAL_INFO);
    }

    protected void createLeftColumn(Composite parent) {
        this.createTestCaseSection(parent);
        this.createNamedElementSection(parent);
    }

    protected void createRightColumn(Composite parent) {
        this.createDetailSection(parent);
    }

    protected IAction getAddTestCaseAction() {
        return new AddTestCase(this, "org.eclipse.hyades.test.http.junit.testCase", ToolsUiPluginResourceBundle.W_HTTP_REQUEST.toLowerCase()){

            protected void adjusTestCase(ITestCase testCase) {
                RequestHelper requestHelper = new RequestHelper();
                requestHelper.setTestCase(testCase);
                requestHelper.setAttribute(1, HttpPreferenceUtil.getInstance().getDefaultHostName());
                requestHelper.setAttribute(2, HttpPreferenceUtil.getInstance().getDefaultHostPort());
                requestHelper.setAttribute(3, HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
                requestHelper.setAttribute(5, HttpConstants.SUPPORTED_REQUEST_METHODS[0]);
                requestHelper.setAttribute(6, "1.1");
                requestHelper.setAttribute(7, HttpPreferenceUtil.getInstance().getDefaultThinkTime());
            }
        };
    }

    protected String getTestCasesSectionHeaderText() {
        return ToolsUiPluginResourceBundle.W_REQUESTS;
    }

    protected void registerHelp(int flag, Object object) {
        switch (flag) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void addDetails(StaticDetailPageProvider detailPageProvider) {
        this.detailPageProvider = detailPageProvider;
        detailPageProvider.addDetailPage(ITestCase.class, (IDetailPage)new HttpTestCaseDetailPage());
    }

    protected void createDetailSection(Composite parent) {
        super.createDetailSection(parent);
        DetailSection detailSection = this.getDetailSection();
        if (detailSection != null && this.detailPageProvider != null) {
            IDetailPage detailPage = this.detailPageProvider.getDetailPage(ITestCase.class);
            Composite client = detailSection.getClient();
            Control pageControl = detailPage.createControl(client, (FormWidgetFactory)this.getWidgetFactory(), (IDetailPageContext)detailSection);
            pageControl.setLayoutData((Object)GridDataUtil.createFill());
            this.getDetailSection().addControlWithDetailPage(detailPage, pageControl);
        }
    }

    protected TreeSection createTestCasesSection() {
        IAction[] actions = new IAction[]{this.getAddTestCaseAction(), new RemoveChildrenAction(false), new MoveChildrenUpAction(), new MoveChildrenDownAction(), new OpenTestMethodAction(), new CheckTestCaseAction()};
        EReference feature = Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases();
        ((MoveChildrenUpAction)actions[2]).setEStructuralFeature((EStructuralFeature)feature);
        ((MoveChildrenDownAction)actions[3]).setEStructuralFeature((EStructuralFeature)feature);
        ExtensibleEObjectTreeSection section = new ExtensibleEObjectTreeSection((EditorForm)this, (EStructuralFeature)feature, actions);
        section.setEditable(true);
        int counter = 0;
        while (counter < actions.length) {
            if (actions[counter] instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)actions[counter]).setStructuredViewer((StructuredViewer)section.getTreeViewer());
            }
            ++counter;
        }
        return section;
    }
}

