/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RunInstancesPage
extends WizardPage
implements Listener {
    private Text nusersText;
    private int nusers = 1;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public RunInstancesPage() {
        super("instances");
        this.setTitle(ToolsUiPluginResourceBundle.RUN_WTITLE);
        this.setDescription(ToolsUiPluginResourceBundle.RUN_IDESC);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite nameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setFont(font);
        Label label = new Label(nameGroup, 0);
        label.setText(ToolsUiPluginResourceBundle.NUMBER_OF_USERS);
        label.setFont(font);
        this.nusersText = new Text(nameGroup, 2048);
        this.nusersText.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.nusersText.setLayoutData((Object)data);
        this.nusersText.setFont(font);
        this.nusersText.setText(String.valueOf(this.nusers));
        this.setControl((Control)nameGroup);
        this.setPageComplete(this.validatePage());
    }

    protected void addControl(Composite parent) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nusersText.setFocus();
            this.nusersText.selectAll();
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        Integer n;
        block3: {
            String number = this.nusersText.getText();
            try {
                n = Integer.valueOf(number);
                if (n >= 0) break block3;
                this.setErrorMessage(ToolsUiPluginResourceBundle.ENTER_POSITIVE_NUMBER);
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(ToolsUiPluginResourceBundle.ENTER_POSITIVE_NUMBER);
                return false;
            }
        }
        this.nusers = n;
        this.setErrorMessage(null);
        return true;
    }

    public int getNusers() {
        return this.nusers;
    }

    public void setNusers(int i) {
        this.nusers = i < 1 ? 1 : i;
    }
}

