/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.http.internal.preferences;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class HttpPreferenceUtil {
    private static HttpPreferenceUtil instance;
    private static String DEFAULTHOSTNAME;
    private static String DEFAULTHOSTPORT;
    private static String DEFAULTABSOLUTEPATH;
    private static String DEFAULTTHINKTIME;
    private static String DEFAULTVARIANCE;
    private IPreferenceStore preferenceStore = ToolsUiPlugin.getDefault().getPreferenceStore();

    static {
        DEFAULTHOSTNAME = "DefaultHostName";
        DEFAULTHOSTPORT = "DefaultHostPort";
        DEFAULTABSOLUTEPATH = "DefaultAbsolutePath";
        DEFAULTTHINKTIME = "DefaultThinkTime";
        DEFAULTVARIANCE = "DefaultVariance";
    }

    private HttpPreferenceUtil() {
        this.setDefaultValues();
    }

    public static HttpPreferenceUtil getInstance() {
        if (instance == null) {
            instance = new HttpPreferenceUtil();
        }
        return instance;
    }

    private void setDefaultValues() {
        this.preferenceStore.setDefault(DEFAULTHOSTNAME, "");
        this.preferenceStore.setDefault(DEFAULTHOSTPORT, "80");
        this.preferenceStore.setDefault(DEFAULTABSOLUTEPATH, "/");
        this.preferenceStore.setDefault(DEFAULTTHINKTIME, 200L);
        this.preferenceStore.setDefault(DEFAULTVARIANCE, "10");
    }

    public String getDefaultHostName() {
        return this.getDefaultHostName(false);
    }

    public String getDefaultHostName(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTNAME);
        }
        return this.preferenceStore.getString(DEFAULTHOSTNAME);
    }

    public void setDefaultHostName(String value) {
        this.preferenceStore.setValue(DEFAULTHOSTNAME, value);
    }

    public String getDefaultHostPort() {
        return this.getDefaultHostPort(false);
    }

    public String getDefaultHostPort(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTHOSTPORT);
        }
        return this.preferenceStore.getString(DEFAULTHOSTPORT);
    }

    public void setDefaultHostPort(String value) {
        this.preferenceStore.setValue(DEFAULTHOSTPORT, value);
    }

    public String getDefaultAbsolutePath() {
        return this.getDefaultAbsolutePath(false);
    }

    public String getDefaultAbsolutePath(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTABSOLUTEPATH);
        }
        return this.preferenceStore.getString(DEFAULTABSOLUTEPATH);
    }

    public void setDefaultAbsolutePath(String value) {
        this.preferenceStore.setValue(DEFAULTABSOLUTEPATH, value);
    }

    public String getDefaultThinkTime() {
        return this.getDefaultThinkTime(false);
    }

    public String getDefaultThinkTime(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTTHINKTIME);
        }
        return this.preferenceStore.getString(DEFAULTTHINKTIME);
    }

    public void setDefaultThinkTime(String value) {
        this.preferenceStore.setValue(DEFAULTTHINKTIME, value);
    }

    public String getDefaultVariance() {
        return this.getDefaultVariance(false);
    }

    public String getDefaultVariance(boolean defaultValue) {
        if (defaultValue) {
            return this.preferenceStore.getDefaultString(DEFAULTVARIANCE);
        }
        return this.preferenceStore.getString(DEFAULTVARIANCE);
    }

    public void setDefaultVariance(String value) {
        this.preferenceStore.setValue(DEFAULTVARIANCE, value);
    }
}

