/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.controls;

import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CodeUpdatePreviewOptionsGroup
extends Composite {
    private Button alwaysPreviewButton = null;
    private Button destructiveChangesPreviewButton = null;
    private Button neverPreviewButton = null;
    private Button promptPreviewButton = null;

    public CodeUpdatePreviewOptionsGroup(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void initialize(IPreferenceStore prefs) {
        this.resetPreview();
        switch (prefs.getInt("code.update.preview.mode")) {
            case 0: {
                this.alwaysPreviewButton.setSelection(true);
                break;
            }
            case 1: {
                this.destructiveChangesPreviewButton.setSelection(true);
                break;
            }
            case 2: {
                this.neverPreviewButton.setSelection(true);
                break;
            }
            case 3: {
                this.promptPreviewButton.setSelection(true);
            }
        }
    }

    public void resetToDefaults(IPreferenceStore prefs) {
        this.resetPreview();
        switch (prefs.getDefaultInt("code.update.preview.mode")) {
            case 0: {
                this.alwaysPreviewButton.setSelection(true);
                break;
            }
            case 1: {
                this.destructiveChangesPreviewButton.setSelection(true);
                break;
            }
            case 2: {
                this.neverPreviewButton.setSelection(true);
                break;
            }
            case 3: {
                this.promptPreviewButton.setSelection(true);
            }
        }
    }

    public void save(IPreferenceStore prefs) {
        int value = -1;
        if (this.alwaysPreviewButton.getSelection()) {
            value = 0;
        } else if (this.destructiveChangesPreviewButton.getSelection()) {
            value = 1;
        } else if (this.neverPreviewButton.getSelection()) {
            value = 2;
        } else if (this.promptPreviewButton.getSelection()) {
            value = 3;
        }
        prefs.setValue("code.update.preview.mode", value);
    }

    private void createControl() {
        GridLayout compositeGridLayout = new GridLayout(1, true);
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.verticalSpacing = 0;
        compositeGridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)compositeGridLayout);
        this.setLayoutData(new GridData(4, 4, true, false));
        Group previewCodeGroup = new Group((Composite)this, 0);
        previewCodeGroup.setText(ToolsUiPluginResourceBundle.CODE_UPDATE_PREVIEW_GROUP);
        previewCodeGroup.setLayout((Layout)new GridLayout(1, true));
        previewCodeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.alwaysPreviewButton = new Button((Composite)previewCodeGroup, 16);
        this.alwaysPreviewButton.setText(ToolsUiPluginResourceBundle.ALWAYS_CODE_UPDATE_PREVIEW_LABEL);
        this.destructiveChangesPreviewButton = new Button((Composite)previewCodeGroup, 16);
        this.destructiveChangesPreviewButton.setText(ToolsUiPluginResourceBundle.DESTRUCTIVE_CHANGES_CODE_UPDATE_PREVIEW_LABEL);
        this.neverPreviewButton = new Button((Composite)previewCodeGroup, 16);
        this.neverPreviewButton.setText(ToolsUiPluginResourceBundle.NEVER_CODE_UPDATE_PREVIEW_LABEL);
        this.promptPreviewButton = new Button((Composite)previewCodeGroup, 16);
        this.promptPreviewButton.setText(ToolsUiPluginResourceBundle.PROMPT_CODE_UPDATE_PREVIEW_LABEL);
    }

    private void resetPreview() {
        this.alwaysPreviewButton.setSelection(false);
        this.destructiveChangesPreviewButton.setSelection(false);
        this.neverPreviewButton.setSelection(false);
        this.promptPreviewButton.setSelection(false);
    }
}

