/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.controls;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry;
import org.eclipse.hyades.test.tools.core.java.IJUnitTestSuiteFactory;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class JUnitTestSuiteFactoriesProvider
extends LabelProvider
implements IStructuredContentProvider {
    private JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] factories;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.factories = newInput != null && newInput instanceof IJavaProject ? this.computeFactories((IJavaProject)newInput) : (newInput != null && newInput instanceof IJavaModel ? this.computeFactories() : (newInput != null && newInput instanceof Collection ? this.computeFactories((Collection)newInput) : new JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[0]));
    }

    private JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] computeFactories() {
        return JUnitExtensionsRegistry.getInstance().getAvailableFactories(false);
    }

    private JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] computeFactories(IJavaProject projectRestriction) {
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] ret = this.computeFactories();
        ArrayList<JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor> list = new ArrayList<JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor>(ret.length);
        int i = 0;
        while (i < ret.length) {
            JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr = ret[i];
            IJUnitTestSuiteFactory factory = descr.getFactory();
            if (factory.isSupported(projectRestriction)) {
                list.add(descr);
            }
            ++i;
        }
        return list.toArray(new JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[list.size()]);
    }

    private JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] computeFactories(Collection proxiesRestriction) {
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[] ret = this.computeFactories();
        ArrayList<JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor> list = new ArrayList<JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor>(ret.length);
        int i = 0;
        while (i < ret.length) {
            JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descr = ret[i];
            IJUnitTestSuiteFactory factory = descr.getFactory();
            if (this.factorySupports(factory, proxiesRestriction)) {
                list.add(descr);
            }
            ++i;
        }
        return list.toArray(new JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor[list.size()]);
    }

    private boolean factorySupports(IJUnitTestSuiteFactory factory, Collection proxiesRestriction) {
        for (RegularJUnitTestSuiteProxyNode node : proxiesRestriction) {
            if (factory.isSupported(node.getCompilationUnit())) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        return this.factories;
    }

    public String getText(Object element) {
        String type = ((JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)element).getType();
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        return descriptor.getName();
    }

    public Image getImage(Object element) {
        String type = ((JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)element).getType();
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        return descriptor.getImage();
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        String type = ((JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)element).getType();
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        return descriptor.getImageDescriptor();
    }

    public JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor getElement(String type) {
        int i = 0;
        while (i < this.factories.length) {
            if (type.equals(this.factories[i].getType())) {
                return this.factories[i];
            }
            ++i;
        }
        return null;
    }
}

