/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.controls;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitExtensionsRegistry;
import org.eclipse.hyades.test.tools.ui.java.internal.JavaMessages;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.controls.JUnitTestSuiteFactoriesProvider;
import org.eclipse.hyades.test.ui.internal.util.SpecialFieldsBidiListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class JUnitTestSuiteImportOptionsControl
extends Composite {
    private ComboViewer defaultTestSuiteTypeCombo;
    private StyledText defaultTestSuitePathText;
    private JUnitTestSuiteFactoriesProvider factoriesProvider;
    private SelectionListener patternMenuListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            JUnitTestSuiteImportOptionsControl.this.defaultTestSuitePathText.setText((String)e.widget.getData());
        }
    };

    public JUnitTestSuiteImportOptionsControl(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Label label = new Label((Composite)this, 0);
        label.setText(JavaMessages.JUNIT_IMPORT_DEFAULT_TYPE);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.defaultTestSuiteTypeCombo = new ComboViewer((Composite)this);
        this.defaultTestSuiteTypeCombo.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label((Composite)this, 0);
        label.setText(JavaMessages.JUNIT_IMPORT_DEFAULT_PATH);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.defaultTestSuitePathText = new StyledText((Composite)this, 33622020);
        this.defaultTestSuitePathText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.defaultTestSuitePathText.addBidiSegmentListener((BidiSegmentListener)SpecialFieldsBidiListener.createPathFieldBidiListener());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Control pathTools = this.createPathTools(this);
        pathTools.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected Control createPathTools(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Link link = new Link(composite, 0);
        link.setText("<a>" + JavaMessages.JUNIT_IMPORT_PATTERNS + "</a>");
        link.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        final Menu menu = new Menu((Control)link);
        this.createPatternMenuItem(menu, JavaMessages.JUNIT_IMPORT_PATTERN_SAME_FOLDER, "${tptp_junit_container_path}/${tptp_junit_type_name}.testsuite");
        this.createPatternMenuItem(menu, JavaMessages.JUNIT_IMPORT_PATTERN_COMMON_JUNIT_FOLDER, "/${tptp_junit_project}/junit/${tptp_junit_type_name}.testsuite");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                menu.setVisible(true);
            }
        });
        Control buttons = this.createButtons(composite);
        buttons.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        return composite;
    }

    protected Control createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.pack = false;
        composite.setLayout((Layout)layout);
        Button button = new Button(composite, 8);
        button.setText(JavaMessages.JUNIT_IMPORT_CHOOSE_IN_WORKSPACE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUnitTestSuiteImportOptionsControl.this.handleBrowseWorkspace();
            }
        });
        button = new Button(composite, 8);
        button.setText(JavaMessages.JUNIT_IMPORT_CHOOSE_VARIABLE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUnitTestSuiteImportOptionsControl.this.handleBrowseVariables();
            }
        });
        return composite;
    }

    protected MenuItem createPatternMenuItem(Menu menu, String text, String pattern) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(text);
        item.setData((Object)pattern);
        item.addSelectionListener(this.patternMenuListener);
        return item;
    }

    protected void handleBrowseWorkspace() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), this.getContainer(), true, JavaMessages.JUNIT_IMPORT_CHOOSE_FOLDER_PROMPT);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                return;
            }
            IPath path = (IPath)result[0];
            this.defaultTestSuitePathText.setText(path.toPortableString());
        }
    }

    protected void handleBrowseVariables() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.setFilter("tptp_junit");
        if (dialog.open() == 0) {
            this.defaultTestSuitePathText.insert(dialog.getVariableExpression());
        }
    }

    protected IContainer getContainer() {
        String path = this.defaultTestSuitePathText.getText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                path = manager.performStringSubstitution(path, false);
                res = root.findMember((IPath)new Path(path));
                if (res != null && res.getType() == 1) {
                    res = res.getParent();
                }
            }
            catch (CoreException coreException) {}
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void initialize(IPreferenceStore prefs, IProject project) {
        Object jelem = project != null ? JavaCore.create((IProject)project) : JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.factoriesProvider = new JUnitTestSuiteFactoriesProvider();
        this.defaultTestSuiteTypeCombo.setLabelProvider((IBaseLabelProvider)this.factoriesProvider);
        this.defaultTestSuiteTypeCombo.setContentProvider((IContentProvider)this.factoriesProvider);
        this.defaultTestSuiteTypeCombo.setInput(jelem);
        String defType = prefs.getString("defaultJUnitTestSuiteFactory");
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descriptor = this.factoriesProvider.getElement(defType);
        if (descriptor != null) {
            this.defaultTestSuiteTypeCombo.setSelection((ISelection)new StructuredSelection((Object)descriptor));
        }
        String defPath = prefs.getString("defaultJUnitTestSuitePath");
        this.defaultTestSuitePathText.setText(defPath);
    }

    public void save(IPreferenceStore prefs) {
        Object sel;
        String defType = null;
        ISelection selection = this.defaultTestSuiteTypeCombo.getSelection();
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) != null && sel instanceof JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor) {
            defType = ((JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor)sel).getType();
        }
        if (defType != null) {
            prefs.setValue("defaultJUnitTestSuiteFactory", defType);
        }
        prefs.setValue("defaultJUnitTestSuitePath", this.defaultTestSuitePathText.getText());
    }

    public void resetToDefaults(IPreferenceStore prefs) {
        String defType = prefs.getDefaultString("defaultJUnitTestSuiteFactory");
        JUnitExtensionsRegistry.JUnitTestSuiteFactoryDescriptor descriptor = this.factoriesProvider.getElement(defType);
        if (descriptor != null) {
            this.defaultTestSuiteTypeCombo.setSelection((ISelection)new StructuredSelection((Object)descriptor));
        }
        String defPath = prefs.getDefaultString("defaultJUnitTestSuitePath");
        this.defaultTestSuitePathText.setText(defPath);
    }
}

