/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitBehaviorForm;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitForm;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitTestCasesForm;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.UpdateCodeWizard;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.MessageBox;

public class JUnitEditorExtension
extends TestSuiteEditorExtension {
    protected boolean behaviorFormDisplayed = false;

    public void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.setTestSuiteForm(new JUnitForm(this, widgetFactory));
        this.getTestSuiteForm().setTestCasePageIndex(1);
        hyadesEditorPart.addPage(this.getTestSuiteForm().createControl());
        hyadesEditorPart.setPageText(0, ToolsUiPluginResourceBundle.W_OVERVIEW);
        this.setTestCasesForm(new JUnitTestCasesForm(this, widgetFactory));
        hyadesEditorPart.addPage(this.getTestCasesForm().createControl());
        hyadesEditorPart.setPageText(1, ToolsUiPluginResourceBundle.W_TST_METHS);
        boolean bl = this.behaviorFormDisplayed = !this.getTestSuite().getImplementor().isExternalImplementor();
        if (this.behaviorFormDisplayed) {
            this.setBehaviorForm(new JUnitBehaviorForm(this, widgetFactory));
            hyadesEditorPart.addPage(this.getBehaviorForm().createControl());
            hyadesEditorPart.setPageText(2, UiPluginResourceBundle.W_BEHAVIOR);
        } else {
            this.setBehaviorForm(null);
        }
        this.getTestSuiteForm().updateTitle();
    }

    public void setBehaviorFormState(boolean state) {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        if (state && !this.behaviorFormDisplayed) {
            WidgetFactory widgetFactory = new WidgetFactory();
            this.setBehaviorForm(new JUnitBehaviorForm(this, widgetFactory));
            hyadesEditorPart.addPage(this.getBehaviorForm().createControl());
            hyadesEditorPart.setPageText(2, UiPluginResourceBundle.W_BEHAVIOR);
            this.getBehaviorForm().load();
        } else if (!state && this.behaviorFormDisplayed) {
            hyadesEditorPart.removePage(2);
            this.setBehaviorForm(null);
        }
        this.behaviorFormDisplayed = state;
    }

    protected void displayCodeGenerationProblem(String message) {
        MessageBox box = new MessageBox(this.getHyadesEditorPart().getEditorPart().getSite().getShell());
        box.setText(ToolsUiPluginResourceBundle.CODE_UPDATE);
        box.setMessage(message);
        box.open();
    }

    public void save(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 2);
        try {
            JUnitGenerator generator = new JUnitGenerator(this.getTestSuite(), (IProjectDependencyUpdater)new AutomaticDependencyUpdater());
            if (!this.performChange((Refactoring)generator)) {
                throw new OperationCanceledException();
            }
            ((JUnitForm)this.getTestSuiteForm()).reloadSourceInfo();
            this.getTestCasesForm().updateTestCasesSection();
            super.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private boolean performBatchChange(Change change) {
        try {
            change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            if (change.isValid((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                change.perform((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (CoreException e) {
            ToolsUiPlugin.logError(e);
            return false;
        }
    }

    protected boolean performChange(Refactoring refactoring) {
        int previewPref = ToolsUiPlugin.getDefault().getPluginPreferences().getInt("code.update.preview.mode");
        boolean showWizard = previewPref != 2;
        Change change = null;
        try {
            RefactoringStatus status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            if (status.hasEntries()) {
                showWizard = true;
            } else {
                change = refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
                if (previewPref == 1 && !Helper.isDestructiveChange((Change)change)) {
                    showWizard = false;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (CoreException e1) {
            ToolsUiPlugin.logError(e1);
            return false;
        }
        if (showWizard || change != null && !this.performBatchChange(change)) {
            UpdateCodeWizard wizard = new UpdateCodeWizard(refactoring, showWizard);
            wizard.setDefaultPageTitle(ToolsUiPluginResourceBundle.CODE_UPDATE_PREVIEW);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                return op.run(this.getHyadesEditorPart().getEditorPart().getEditorSite().getShell(), ToolsUiPluginResourceBundle.CODE_UPDATE) == 0;
            }
            catch (InterruptedException e) {
                ToolsUiPlugin.logError(e);
                return false;
            }
        }
        return true;
    }
}

