/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.fragments.impl.Common_Behavior_FragmentsFactoryImpl;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitEditorExtension;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.SpecialFieldsBidiListener;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SourceInfoViewer
implements ModifyListener,
SelectionListener {
    private static final String ADVANCED_MODE_SYSTEM_PROPERTY = "TPTP_TESTTOOLS_JUNIT_ADVANCED_EDITOR";
    private StyledText sourceFolderText;
    private StyledText packageText;
    private StyledText classNameText;
    private Button sourceFolderButton;
    private Button packageButton;
    private Button updateFromCodeButton;
    private Button openClassButton;
    private IImplementor implementor;
    private VerifyKeyListener verifyKeyListener;
    private Button externalBehavior;
    private EditorForm editorForm;
    private IBlock preservedBlock;
    private boolean showExternalBehavior;
    private boolean advanced = System.getProperty("TPTP_TESTTOOLS_JUNIT_ADVANCED_EDITOR") != null;

    public SourceInfoViewer(EditorForm editorForm) {
        this.editorForm = editorForm;
        this.showExternalBehavior = editorForm.getBaseEditorExtension() instanceof JUnitEditorExtension;
    }

    public SourceInfoViewer() {
    }

    public void dispose() {
        this.implementor = null;
        this.preservedBlock = null;
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected IImplementor getImplementor() {
        return this.implementor;
    }

    public Composite createClient(Composite parent, VerifyKeyListener verifyKeyListener, WidgetFactory widgetFactory) {
        Label label;
        this.verifyKeyListener = verifyKeyListener;
        Composite composite = null;
        composite = widgetFactory != null ? widgetFactory.createComposite(parent) : new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)GridDataUtil.createFill());
        if (this.showExternalBehavior) {
            if (widgetFactory != null) {
                this.externalBehavior = widgetFactory.createButton(composite, ToolsUiPluginResourceBundle.STR_TBC_CHECK, 32);
            } else {
                this.externalBehavior = new Button(composite, 32);
                this.externalBehavior.setText(ToolsUiPluginResourceBundle.STR_TBC_CHECK);
            }
            this.externalBehavior.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        }
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.STR_WB_SRCFOLD);
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPluginResourceBundle.STR_WB_SRCFOLD);
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.sourceFolderText = widgetFactory != null ? widgetFactory.createStyledText(composite, 33619972, ToolsUiPluginResourceBundle.STR_WB_SRCFOLD) : new StyledText(composite, 33622020);
        this.sourceFolderText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.sourceFolderText.setEditable(false);
        this.sourceFolderText.addBidiSegmentListener((BidiSegmentListener)SpecialFieldsBidiListener.createPathFieldBidiListener());
        if (widgetFactory != null) {
            this.sourceFolderButton = widgetFactory.createButton(composite, ToolsUiPluginResourceBundle.STR_WB_SRCFOLD_BTN, 8);
        } else {
            this.sourceFolderButton = new Button(composite, 8);
            this.sourceFolderButton.setText(ToolsUiPluginResourceBundle.STR_WB_SRCFOLD_BTN);
        }
        this.sourceFolderButton.setLayoutData((Object)new GridData(256));
        this.sourceFolderButton.addSelectionListener((SelectionListener)this);
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.STR_WB_PACK);
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPluginResourceBundle.STR_WB_PACK);
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.packageText = widgetFactory != null ? widgetFactory.createStyledText(composite, 33619972, ToolsUiPluginResourceBundle.STR_WB_PACK) : new StyledText(composite, 33622020);
        this.packageText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.packageText.setEditable(false);
        this.packageText.addBidiSegmentListener((BidiSegmentListener)SpecialFieldsBidiListener.createPackageFieldBidiListener());
        if (widgetFactory != null) {
            this.packageButton = widgetFactory.createButton(composite, ToolsUiPluginResourceBundle.STR_WB_PACK_BTN, 8);
        } else {
            this.packageButton = new Button(composite, 8);
            this.packageButton.setText(ToolsUiPluginResourceBundle.STR_WB_PACK_BTN);
        }
        this.packageButton.setLayoutData((Object)new GridData(256));
        this.packageButton.addSelectionListener((SelectionListener)this);
        if (widgetFactory != null) {
            label = widgetFactory.createLabel(composite, ToolsUiPluginResourceBundle.STR_WB_CLASS);
        } else {
            label = new Label(composite, 0);
            label.setText(ToolsUiPluginResourceBundle.STR_WB_CLASS);
        }
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.classNameText = widgetFactory != null ? widgetFactory.createStyledText(composite, 65540, ToolsUiPluginResourceBundle.STR_WB_CLASS) : new StyledText(composite, 67588);
        this.classNameText.setEditable(false);
        if (widgetFactory != null) {
            this.classNameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            this.openClassButton = widgetFactory.createButton(composite, UiPluginResourceBundle.ACT_OPEN, 8);
            this.openClassButton.setLayoutData((Object)new GridData(256));
            this.openClassButton.addSelectionListener((SelectionListener)this);
        } else {
            this.classNameText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        }
        if (this.advanced && this.showExternalBehavior) {
            this.updateFromCodeButton = widgetFactory.createButton(composite, "Refresh test methods from code", 8);
            this.updateFromCodeButton.setLayoutData((Object)new GridData(0x1000008, 1, false, false, 2, 1));
            this.updateFromCodeButton.addSelectionListener((SelectionListener)this);
        }
        if (widgetFactory != null) {
            widgetFactory.paintBordersFor(composite);
        }
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.implementor = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        if (object instanceof ITest) {
            object = ((ITest)object).getImplementor();
        }
        if (object != null && object instanceof IImplementor) {
            this.implementor = (IImplementor)object;
            this.adjustTexts();
            this.sourceFolderText.setEditable(true);
            this.packageText.setEditable(true);
            this.classNameText.setEditable(true);
        } else {
            this.setSourceFolder("");
            this.setPackage("");
            this.setClassName("");
            this.sourceFolderText.setEditable(false);
            this.packageText.setEditable(false);
            this.classNameText.setEditable(false);
        }
        this.updateButtonsState();
    }

    protected void adjustTexts() {
        String sourceFolderName;
        if (this.verifyKeyListener != null) {
            this.sourceFolderText.removeVerifyKeyListener(this.verifyKeyListener);
            this.packageText.removeVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.removeVerifyKeyListener(this.verifyKeyListener);
        }
        this.sourceFolderText.removeModifyListener((ModifyListener)this);
        this.packageText.removeModifyListener((ModifyListener)this);
        this.classNameText.removeModifyListener((ModifyListener)this);
        if (this.externalBehavior != null) {
            this.externalBehavior.removeSelectionListener((SelectionListener)this);
        }
        if ((sourceFolderName = this.getImplementor().getLocation()) == null) {
            sourceFolderName = "";
        }
        String className = "";
        String packageName = "";
        String value = this.getImplementor().getResource();
        if (value != null) {
            int index = value.lastIndexOf(46);
            if (index >= 0) {
                packageName = value.substring(0, index);
            } else {
                index = -1;
            }
            if (index != value.length() - 1) {
                className = value.substring(index + 1);
            }
        }
        boolean isExternal = this.getImplementor().isExternalImplementor();
        this.setSourceFolder(sourceFolderName);
        this.setPackage(packageName);
        this.setClassName(className);
        if (this.externalBehavior != null) {
            this.externalBehavior.setSelection(isExternal);
        }
        if (this.verifyKeyListener != null) {
            this.sourceFolderText.addVerifyKeyListener(this.verifyKeyListener);
            this.packageText.addVerifyKeyListener(this.verifyKeyListener);
            this.classNameText.addVerifyKeyListener(this.verifyKeyListener);
        }
        this.sourceFolderText.addModifyListener((ModifyListener)this);
        this.packageText.addModifyListener((ModifyListener)this);
        this.classNameText.addModifyListener((ModifyListener)this);
        if (this.externalBehavior != null) {
            this.externalBehavior.addSelectionListener((SelectionListener)this);
        }
    }

    public Object getInput() {
        return this.implementor;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getImplementor() == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.getImplementor());
    }

    public void selectReveal(ISelection selection) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.sourceFolderText) {
            this.getImplementor().setLocation(this.getSourceFolder());
        } else if (e.widget == this.classNameText || e.widget == this.packageText) {
            this.getImplementor().setResource(this.getQualifiedTypeName());
        }
        this.updateButtonsState();
        this.markDirty();
    }

    private String getQualifiedTypeName() {
        String packageName = this.getPackage();
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + '.' + this.getClassName();
        }
        return this.getClassName();
    }

    private void updateButtonsState() {
        this.packageButton.setEnabled(this.findSourceFolder() != null);
        if (this.openClassButton != null) {
            this.openClassButton.setEnabled(this.findCompilationUnit() != null);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        block33: {
            ICompilationUnit cu;
            if (this.isReadOnly()) {
                e.doit = false;
                if (e.widget == this.externalBehavior) {
                    this.externalBehavior.setSelection(!this.externalBehavior.getSelection());
                }
            } else if (e.widget == this.sourceFolderButton) {
                ElementTreeSelectionDialog dialog = TestJavaUtil.createSourceFolderDialog(this.sourceFolderButton.getShell(), null);
                dialog.setTitle(ToolsUiPluginResourceBundle.TITLE_SRC_SELECT);
                dialog.setMessage(ToolsUiPluginResourceBundle.STR_SRC_SELECT);
                dialog.setEmptyListMessage(ToolsUiPluginResourceBundle.NO_SRC);
                dialog.setInitialSelection((Object)this.findSourceFolder());
                if (dialog.open() == 0) {
                    Object result = dialog.getFirstResult();
                    String text = "";
                    if (result != null && (result instanceof IJavaProject || result instanceof IPackageFragmentRoot)) {
                        try {
                            text = ((IJavaElement)result).getCorrespondingResource().getFullPath().toString();
                        }
                        catch (JavaModelException e1) {
                            ToolsUiPlugin.logError(e1);
                        }
                    }
                    this.setSourceFolder(text);
                    this.markDirty();
                }
            } else if (e.widget == this.packageButton) {
                try {
                    IPackageFragmentRoot srcFolder = this.findSourceFolder();
                    if (srcFolder == null) break block33;
                    String initialPackageName = this.getPackage();
                    SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this.packageButton.getShell(), (IPackageFragmentRoot)srcFolder);
                    IPackageFragment initialPackage = null;
                    if (initialPackageName != null) {
                        initialPackage = srcFolder.getPackageFragment(initialPackageName);
                    }
                    if (initialPackage != null && initialPackage.exists()) {
                        dialog.setInitialSelections(new Object[]{initialPackage});
                    }
                    dialog.setTitle(ToolsUiPluginResourceBundle.TITLE_PACK_SELECT);
                    dialog.setMessage(ToolsUiPluginResourceBundle.STR_PACK_SELECT);
                    if (dialog.open() == 0) {
                        IPackageFragment packageFragment = (IPackageFragment)dialog.getResult()[0];
                        this.setPackage(packageFragment.getElementName());
                        this.markDirty();
                    }
                }
                catch (JavaModelException javaModelException) {
                    e.doit = false;
                }
            } else if (e.widget == this.externalBehavior) {
                if (this.externalBehavior.getSelection()) {
                    if (this.editorForm != null) {
                        ((JUnitEditorExtension)this.editorForm.getBaseEditorExtension()).setBehaviorFormState(false);
                    }
                    this.preservedBlock = this.getImplementor().getBlock();
                    JUnitModelUpdater.setImplementorBlock((IImplementor)this.implementor, null);
                } else {
                    if (this.preservedBlock != null) {
                        JUnitModelUpdater.setImplementorBlock((IImplementor)this.getImplementor(), (IBlock)this.preservedBlock);
                    } else {
                        SourceInfoViewer.createBlock(this.getImplementor());
                    }
                    if (this.editorForm != null) {
                        ((JUnitEditorExtension)this.editorForm.getBaseEditorExtension()).setBehaviorFormState(true);
                    }
                }
                this.markDirty();
            } else if (e.widget == this.updateFromCodeButton) {
                try {
                    ITestSuite testSuite = (ITestSuite)this.getImplementor().getOwner();
                    if (JUnitModelUpdater.updateTestSuiteFromCode((ITestSuite)testSuite, (IFile)JUnitTestSuiteFacade.getJUnitSourceFile((ITestSuite)testSuite))) {
                        this.markDirty();
                    }
                }
                catch (CoreException e1) {
                    CorePlugin.logError((Throwable)e1);
                }
            } else if (e.widget == this.openClassButton && (cu = this.findCompilationUnit()) != null) {
                try {
                    JavaUI.openInEditor((IJavaElement)cu);
                }
                catch (PartInitException e1) {
                    ToolsUiPlugin.logError(e1);
                    e.doit = false;
                }
                catch (JavaModelException e1) {
                    ToolsUiPlugin.logError(e1);
                    e.doit = false;
                }
            }
        }
    }

    protected IPackageFragmentRoot findSourceFolder() {
        IJavaElement javaElement;
        IPackageFragmentRoot sourceFolder = null;
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getSourceFolder());
        if (resource != null && (javaElement = JavaCore.create((IResource)resource)) != null) {
            try {
                if (javaElement instanceof IJavaProject) {
                    sourceFolder = ((IJavaProject)javaElement).findPackageFragmentRoot(resource.getFullPath());
                } else if (javaElement instanceof IPackageFragmentRoot) {
                    sourceFolder = (IPackageFragmentRoot)javaElement;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return sourceFolder;
    }

    protected IPackageFragment findPackage() {
        IPackageFragment pack;
        IPackageFragmentRoot srcFolder = this.findSourceFolder();
        if (srcFolder != null && (pack = srcFolder.getPackageFragment(this.getPackage())).exists()) {
            return pack;
        }
        return null;
    }

    protected ICompilationUnit findCompilationUnit() {
        ICompilationUnit cu;
        IPackageFragment pack = this.findPackage();
        if (pack != null && (cu = pack.getCompilationUnit(String.valueOf(this.getClassName()) + ".java")).exists()) {
            return cu;
        }
        return null;
    }

    static IBlock createBlock(IImplementor implementor) {
        if (!(implementor instanceof TPFBehavior)) {
            return null;
        }
        TPFBehavior testBehavior = (TPFBehavior)implementor;
        TPFTest test = testBehavior.getTest();
        if (!(test instanceof CFGClass)) {
            return null;
        }
        CFGClass theClass = (CFGClass)test;
        String implementedTestName = test.getName();
        if (implementedTestName == null) {
            implementedTestName = "";
        }
        CFGInstanceImpl instance = null;
        for (CFGInstanceImpl tempInstance : theClass.getInstances()) {
            if (!theClass.equals(tempInstance.getClassType())) continue;
            instance = tempInstance;
            break;
        }
        if (instance == null) {
            instance = (CFGInstanceImpl)Common_ConfigurationFactoryImpl.eINSTANCE.createCFGInstance();
            instance.setClassType(theClass);
            theClass.getInstances().add((Object)instance);
        }
        BVRLifelineImpl selfLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
        selfLifeline.setName(String.valueOf(implementedTestName) + "_selfLifeline");
        BVRInteractionImpl testInteraction = (BVRInteractionImpl)Common_Behavior_FragmentsFactoryImpl.eINSTANCE.createBVRInteraction();
        testInteraction.setName(String.valueOf(implementedTestName) + "_interaction");
        testBehavior.setInteraction((BVRInteraction)testInteraction);
        testInteraction.getLifelines().add((Object)selfLifeline);
        instance.setLifeline((BVRLifeline)selfLifeline);
        return testInteraction;
    }

    public String getSourceFolder() {
        Path path = new Path(this.sourceFolderText.getText().trim());
        return path.toString();
    }

    public String getPackage() {
        return this.packageText.getText().trim();
    }

    public String getClassName() {
        return this.classNameText.getText().trim();
    }

    public void setSourceFolder(String srcFolder) {
        this.sourceFolderText.setText(srcFolder);
    }

    public void setPackage(String pack) {
        this.packageText.setText(pack);
    }

    public void setClassName(String className) {
        this.classNameText.setText(className);
    }

    public void setInitialFocus() {
        if (this.sourceFolderText != null && this.getSourceFolder().length() == 0) {
            this.sourceFolderText.setFocus();
        } else if (this.packageText != null && this.getPackage().length() == 0) {
            this.packageText.setFocus();
        } else if (this.classNameText != null && this.getClassName().length() == 0) {
            this.classNameText.setFocus();
        } else {
            this.classNameText.setFocus();
            this.classNameText.setSelection(this.getClassName().length());
        }
    }

    protected void markDirty() {
        if (this.editorForm != null) {
            this.editorForm.getBaseEditorExtension().markDirty();
        }
    }
}

