/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.core.testservices.resources.Messages;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.IJavaSourceTestCaseProxyNode;
import org.eclipse.hyades.test.tools.ui.java.IJavaSourceTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenSourceCommandHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(true);
    }

    private void displayErrorMessage(final String head, final String name) {
        Display disp = Display.getCurrent();
        if (disp != null) {
            Shell shell = disp.getActiveShell();
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)head, (String)name);
            }
        } else {
            final Display disp2 = Display.getDefault();
            disp2.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)disp2.getActiveShell(), (String)head, (String)name);
                }
            });
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            Object structuredSelection = null;
            structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection((Object)selection);
            IProxyNode proxyNode = (IProxyNode)structuredSelection.getFirstElement();
            if (proxyNode instanceof IJavaSourceTestSuiteProxyNode) {
                IJavaSourceTestSuiteProxyNode testSuite = (IJavaSourceTestSuiteProxyNode)proxyNode;
                IFile sourceFile = testSuite.getSourceFile();
                if (sourceFile != null) {
                    UIUtil.openEditor((IFile)sourceFile, null, (boolean)false);
                } else {
                    this.displayErrorMessage(ToolsUiPluginResourceBundle.word_Error, NLS.bind((String)Messages.WorkspaceResourceProviderService_SOURCE_FILE_DNE, (Object)testSuite.getSourceFileName()));
                }
                testSuite.unload();
            } else if (proxyNode instanceof IJavaSourceTestCaseProxyNode) {
                IMethod method = ((IJavaSourceTestCaseProxyNode)proxyNode).getSourceMethod();
                if (method != null) {
                    try {
                        IEditorPart part = JavaUI.openInEditor((IJavaElement)method);
                        JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)method);
                    }
                    catch (Exception e) {
                        ToolsUiPlugin.logError(e);
                    }
                } else {
                    this.displayErrorMessage(ToolsUiPluginResourceBundle.word_Error, NLS.bind((String)Messages.WorkspaceResourceProviderService_SOURCE_FILE_DNE, (Object)((IJavaSourceTestCaseProxyNode)proxyNode).getTestCaseName()));
                }
            }
        }
        return null;
    }
}

