/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JUnitTypeProviderProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.JavaCore;

public class JUnitTypeProvider
implements ITypeProvider,
IResourceChangeListener,
IDisposable {
    protected IFileProxyManager fileProxyManager;
    protected IProxyNodeListener refresher;
    private Map projectToProxyMap = Collections.synchronizedMap(new HashMap());

    public JUnitTypeProvider() {
        FileProxyNodeCache.getInstance().addResourceListener((IResourceChangeListener)this);
    }

    public ITypeProviderProxyNode get(IProject project, String type) {
        if (!JavaCore.create((IProject)project).exists()) {
            return null;
        }
        if (this.projectToProxyMap.containsKey(project)) {
            return (ITypeProviderProxyNode)this.projectToProxyMap.get(project);
        }
        ITypeProviderProxyNode node = this.createTypeProviderProxyNode(project, type);
        if (node != null) {
            this.projectToProxyMap.put(project, node);
        }
        return node;
    }

    protected ITypeProviderProxyNode createTypeProviderProxyNode(IProject project, String type) {
        return JUnitTypeProviderProxyNode.create(project, type, this.fileProxyManager, project);
    }

    public void init(ITypeProviderContext context) {
        this.fileProxyManager = context.getFileProxyManager();
        this.refresher = context.getProxyNodeListener();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] affectedChildren = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            IProject project = (IProject)affectedChildren[i].getResource();
            IResourceChangeListenerProxyNode node = (IResourceChangeListenerProxyNode)this.projectToProxyMap.get(project);
            if (node != null) {
                IProxyNode lowestChange = node.resourceChanged(affectedChildren[i]);
                if (node.getChildren().length == 0) {
                    lowestChange = project;
                    this.projectToProxyMap.remove(project);
                }
                if (lowestChange != null) {
                    this.refresher.nodeChanged((Object)lowestChange);
                }
            } else if (affectedChildren[i].getKind() == 1) {
                this.refresher.nodeChanged((Object)project);
            }
            ++i;
        }
    }

    public void dispose() {
        FileProxyNodeCache.getInstance().removeResourceListener((IResourceChangeListener)this);
    }
}

