/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JUnitFolderProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.SourceFolderProxyNode;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;

public class JUnitTypeProviderProxyNode
implements ITypeProviderProxyNode,
IResourceChangeListenerProxyNode,
IExtendedProxyNode {
    private IProxyNode proxy;
    private String name;
    private String imageKey;
    private final JUnitTypeValidator validator;

    public static JUnitTypeProviderProxyNode create(IProject project, String type, IFileProxyManager fileProxyManager, Object parent) {
        JUnitTypeProviderProxyNode proxy = new JUnitTypeProviderProxyNode(project, type, fileProxyManager, parent);
        if (proxy.getDelegate() != null && proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }

    private IPackageFragmentRoot getProjectAsSourceFolder(IProject project) {
        IPackageFragmentRoot root;
        IJavaProject jProject = JavaCore.create((IProject)project);
        try {
            root = jProject.findPackageFragmentRoot(project.getFullPath());
        }
        catch (JavaModelException e) {
            root = null;
            ToolsUiPlugin.logError(e);
        }
        return root;
    }

    protected JUnitTypeProviderProxyNode(IProject project, String type, IFileProxyManager fileProxyManager, Object parent) {
        this.validator = new JUnitTypeValidator(type);
        IPackageFragmentRoot root = this.getProjectAsSourceFolder(project);
        this.proxy = root == null ? this.createNonSourceFolderProxyNode(project, type, fileProxyManager, parent) : this.createSourceFolderProxyNode(fileProxyManager, parent, root);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        this.name = TestNavigator.getTypeProviderManager().getNameFor(type);
        this.imageKey = TestNavigator.getTypeProviderManager().getImageKeyFor(type);
        if (this.name == null || this.name.trim().length() == 0) {
            this.name = descriptor != null ? descriptor.getName() : "[Invalid Descriptor]";
        }
    }

    protected IProxyNode createSourceFolderProxyNode(IFileProxyManager fileProxyManager, Object parent, IPackageFragmentRoot root) {
        SourceFolderProxyNode _proxy = new SourceFolderProxyNode(root, this.validator, fileProxyManager, parent, this);
        if (_proxy.getChildren().length > 0) {
            return _proxy;
        }
        return null;
    }

    protected IProxyNode createNonSourceFolderProxyNode(IProject project, String type, IFileProxyManager fileProxyManager, Object parent) {
        JUnitFolderProxyNode _proxy = new JUnitFolderProxyNode((IContainer)project, this.validator, type, fileProxyManager, parent, this);
        if (_proxy.getChildren().length > 0) {
            return _proxy;
        }
        return null;
    }

    protected IProxyNode getDelegate() {
        return this.proxy;
    }

    public String getText() {
        return this.name;
    }

    public Image getImage() {
        if (this.imageKey == null || this.imageKey.length() == 0) {
            return this.proxy.getImage();
        }
        return UiPlugin.getInstance().getImageRegistry().get(this.imageKey);
    }

    public Object getParent() {
        if (this.proxy == null) {
            return null;
        }
        return this.proxy.getParent();
    }

    public IProxyNode[] getChildren() {
        return this.proxy.getChildren();
    }

    public Object getAdapter(Class adapter) {
        return this.proxy.getAdapter(adapter);
    }

    public IResource getUnderlyingResource() {
        return this.proxy.getUnderlyingResource();
    }

    public String getIdentifier() {
        return this.proxy.getIdentifier();
    }

    public IProxyNode resourceChanged(IResourceDelta rootDelta) {
        JUnitTypeProviderProxyNode lowestChanged = this;
        IProject project = (IProject)rootDelta.getResource();
        JavaCore.create((IProject)project);
        IPackageFragmentRoot root = this.getProjectAsSourceFolder(project);
        lowestChanged = root == null ? ((JUnitFolderProxyNode)this.proxy).resourceChanged(rootDelta) : ((SourceFolderProxyNode)this.proxy).resourceChanged(rootDelta);
        return lowestChanged == this.proxy ? this : lowestChanged;
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    static class JUnitTypeValidator
    implements ITestFolderContentValidator {
        private String type;
        private List extensions = new LinkedList();

        public JUnitTypeValidator(String type) {
            this.type = type;
            this.extensions.add("testsuite");
            this.extensions.add("execution");
            this.extensions.add("testcomponent");
        }

        public boolean isFileOk(IFile file) {
            return this.extensions.contains(file.getFileExtension());
        }

        public boolean isProxyOk(IProxyNode node) {
            if (node instanceof ITypedElementProxyNode) {
                return ((ITypedElementProxyNode)node).getType().equals(this.type);
            }
            return false;
        }
    }
}

