/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JUnitFolderProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.SourceFolderProxyNode;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;

public class PackageProxyNode
implements IResourceChangeListenerProxyNode,
IExtendedProxyNode {
    private IPackageFragment fragment;
    private IFileProxyManager fileProxyManager;
    private Object parent;
    private IProxyNode[] children;
    private static final IProxyNode[] NO_CHILDREN = new IProxyNode[0];
    private ITestFolderContentValidator validator;

    public static PackageProxyNode create(IFolder folder, IResourceDelta delta, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, SourceFolderProxyNode node) {
        PackageProxyNode pack = new PackageProxyNode(folder, validator, fileProxyManager, (Object)node);
        pack.resourceChanged(delta);
        return pack.getChildren().length > 0 ? pack : null;
    }

    public static PackageProxyNode create(IPackageFragment fragment, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent) {
        PackageProxyNode proxy = new PackageProxyNode(fragment, validator, fileProxyManager, parent);
        if (proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }

    private PackageProxyNode(IFolder folder, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent) {
        this.fileProxyManager = fileProxyManager;
        this.parent = parent;
        this.validator = validator;
        this.fragment = (IPackageFragment)JavaCore.create((IFolder)folder);
        this.children = NO_CHILDREN;
    }

    private PackageProxyNode(IPackageFragment fragment, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent) {
        this.fragment = fragment;
        this.fileProxyManager = fileProxyManager;
        this.parent = parent;
        this.validator = validator;
        LinkedList<IProxyNode> _children = new LinkedList<IProxyNode>();
        try {
            Object[] resources = this.fragment.getNonJavaResources();
            int i = 0;
            while (i < resources.length) {
                IProxyNode proxy;
                IResource res = (IResource)resources[i];
                if (res.getType() == 1 && validator.isFileOk((IFile)res)) {
                    proxy = fileProxyManager.getProxy((IFile)res, (Object)this);
                    if (proxy != null && validator.isProxyOk(proxy)) {
                        _children.add(proxy);
                        fileProxyManager.cacheProxy((IFile)res, proxy);
                    }
                } else if (res instanceof IContainer && (proxy = JUnitFolderProxyNode.create((IContainer)((IContainer)res), (ITestFolderContentValidator)validator, (IFileProxyManager)fileProxyManager, (boolean)false, (Object)this)) != null && validator.isProxyOk(proxy)) {
                    _children.add(proxy);
                }
                ++i;
            }
            this.children = _children.toArray(new IProxyNode[_children.size()]);
        }
        catch (JavaModelException e) {
            ToolsUiPlugin.logError(e);
            this.children = NO_CHILDREN;
        }
    }

    public String getText() {
        return this.fragment.getElementName();
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    }

    public Object getParent() {
        return this.parent;
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContainer.class) {
            try {
                return this.fragment.getUnderlyingResource();
            }
            catch (JavaModelException e) {
                ToolsUiPlugin.logError(e);
                return null;
            }
        }
        return null;
    }

    public IResource getUnderlyingResource() {
        try {
            return this.fragment.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            ToolsUiPlugin.logError(e);
            return null;
        }
    }

    public String getIdentifier() {
        return this.fragment.getElementName();
    }

    private boolean addChild(IProxyNode proxy) {
        if (proxy == null) {
            return false;
        }
        IProxyNode[] newChildren = new IProxyNode[this.children.length + 1];
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].equals(proxy)) {
                return false;
            }
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[this.children.length] = proxy;
        this.children = newChildren;
        return true;
    }

    private void replaceChild(IProxyNode oldProxy, IProxyNode newProxy) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == oldProxy) {
                this.children[i] = newProxy;
                break;
            }
            ++i;
        }
    }

    private void removeChild(IProxyNode proxy) {
        IProxyNode[] newChildren = new IProxyNode[this.children.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != proxy) {
                newChildren[j++] = this.children[i];
            }
            ++i;
        }
        this.children = newChildren;
    }

    private IProxyNode getProxy(IResource resource) {
        int i = 0;
        while (i < this.children.length) {
            if (resource.equals((Object)this.children[i].getUnderlyingResource())) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    public IProxyNode resourceChanged(IResourceDelta rootDelta) {
        Object lowestChanged = null;
        IResourceDelta[] res = rootDelta.getAffectedChildren();
        int i = 0;
        while (i < res.length) {
            int kind = res[i].getKind();
            IProxyNode lowestChild = null;
            if (kind == 1) {
                lowestChild = this.resourceChangedADDED(res[i]);
            } else if (kind == 2) {
                lowestChild = this.resourceChangedREMOVED(res[i]);
            } else if (kind == 4) {
                lowestChild = this.resourceChangedCHANGED(res[i]);
            }
            if (lowestChild != null) {
                lowestChanged = lowestChanged == null ? lowestChild : this;
            }
            ++i;
        }
        return lowestChanged;
    }

    private IProxyNode resourceChangedCHANGED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        IProxyNode proxy = this.getProxy(resource);
        if ((delta.getFlags() & 0x100) != 0) {
            if (proxy != null) {
                if (this.validator.isFileOk((IFile)resource)) {
                    this.fileProxyManager.uncacheProxy((IFile)resource);
                    IProxyNode newProxy = this.fileProxyManager.getProxy((IFile)resource, (Object)this);
                    if (this.validator.isProxyOk(newProxy)) {
                        this.replaceChild(proxy, newProxy);
                        this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                    } else {
                        this.removeChild(proxy);
                    }
                    return this;
                }
            } else {
                boolean wasAdded;
                IProxyNode newProxy;
                if (this.validator.isFileOk((IFile)resource) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy((IFile)resource, (Object)this)) && (wasAdded = this.addChild(newProxy))) {
                    this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                    return this;
                }
                return null;
            }
        }
        return null;
    }

    private IProxyNode resourceChangedADDED(IResourceDelta delta) {
        PackageProxyNode proxy;
        IFolder folder;
        IPackageFragment frag;
        IResource resource = delta.getResource();
        int resType = resource.getType();
        if (resType == 1) {
            boolean wasAdded;
            IProxyNode newProxy;
            if (this.validator.isFileOk((IFile)resource) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy((IFile)resource, (Object)this)) && (wasAdded = this.addChild(newProxy))) {
                this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                return this;
            }
        } else if (resType == 2 && (frag = (IPackageFragment)JavaCore.create((IFolder)(folder = (IFolder)resource))) != null && (proxy = PackageProxyNode.create(frag, this.validator, this.fileProxyManager, this)) != null) {
            this.addChild((IProxyNode)proxy);
            return this;
        }
        return null;
    }

    private IProxyNode resourceChangedREMOVED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        int resType = resource.getType();
        IProxyNode proxy2Remove = this.getProxy(resource);
        if (resType == 1) {
            if (proxy2Remove != null) {
                this.fileProxyManager.uncacheProxy((IFile)resource);
                this.removeChild(proxy2Remove);
                return this;
            }
            return null;
        }
        if (resType == 2 && proxy2Remove != null) {
            if (proxy2Remove instanceof IResourceChangeListenerProxyNode) {
                ((IResourceChangeListenerProxyNode)proxy2Remove).resourceChanged(delta);
                this.removeChild(proxy2Remove);
                return this;
            }
            UiPlugin.logError((String)"The proxy node derived from a folder should be a IResourceChangeListenerProxyNode");
        }
        return null;
    }

    public IResource getCorrespondingResource() {
        return this.getUnderlyingResource();
    }
}

