/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.event.IJUnitTestSuiteFactoryEvent;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.event.IJUnitTestSuiteFactoryListener;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.event.JUnitTestSuiteCreatedEvent;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.event.JUnitTestSuiteDetachedEvent;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.event.JUnitTestSuiteFactoryEventManager;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaElementProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JavaParentElementProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.RegularJUnitProviderProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class RegularJUnitProvider
implements ITypeProvider,
IElementChangedListener,
IDisposable,
IJUnitTestSuiteFactoryListener {
    protected IFileProxyManager fileProxyManager;
    protected IProxyNodeListener refresher;
    private Map projectToProxyMap = new HashMap();

    public ITypeProviderProxyNode get(IProject project, String type) {
        IJavaProject jproject = JavaCore.create((IProject)project);
        if (!jproject.exists()) {
            return null;
        }
        RegularJUnitProviderProxyNode proxy = (RegularJUnitProviderProxyNode)this.projectToProxyMap.get(jproject);
        if (proxy == null) {
            proxy = new RegularJUnitProviderProxyNode(this, jproject, type, project);
            this.projectToProxyMap.put(jproject, proxy);
        }
        if (proxy != null && proxy.getChildren().length == 0) {
            return null;
        }
        return proxy;
    }

    public void init(ITypeProviderContext context) {
        this.fileProxyManager = context.getFileProxyManager();
        this.refresher = !context.isStaticView() ? context.getProxyNodeListener() : null;
        if (this.refresher != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
            JUnitTestSuiteFactoryEventManager.getInstance().addListener((IJUnitTestSuiteFactoryListener)this);
        }
    }

    public synchronized void dispose() {
        if (this.refresher != null) {
            JUnitTestSuiteFactoryEventManager.getInstance().removeListener((IJUnitTestSuiteFactoryListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        for (RegularJUnitProviderProxyNode node : this.projectToProxyMap.values()) {
            node.dispose();
        }
        this.projectToProxyMap.clear();
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta[] children = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            IJavaProject jproject = (IJavaProject)children[i].getElement();
            RegularJUnitProviderProxyNode node = (RegularJUnitProviderProxyNode)this.projectToProxyMap.get(jproject);
            if (children[i].getKind() == 2 && node != null) {
                this.projectToProxyMap.remove(jproject);
            }
            if (node != null) {
                int previousChildrenCount = node.getChildren().length;
                IProxyNode lowestChange = node.elementChanged(children[i]);
                if (lowestChange == node) {
                    int newChildrenCount = node.getChildren().length;
                    if ((previousChildrenCount == 0 || newChildrenCount == 0) && previousChildrenCount != newChildrenCount) {
                        lowestChange = jproject.getProject();
                    }
                }
                if (lowestChange != null) {
                    this.refresher.nodeChanged((Object)lowestChange);
                }
            }
            ++i;
        }
    }

    protected JavaElementProxyNode getProxyNode(IJavaElement element) {
        JavaElementProxyNode parentNode;
        if (element instanceof IJavaProject) {
            return (RegularJUnitProviderProxyNode)this.projectToProxyMap.get(element);
        }
        IJavaElement parent = element.getParent();
        if (parent != null && (parentNode = this.getProxyNode(parent)) instanceof JavaParentElementProxyNode) {
            return ((JavaParentElementProxyNode)parentNode).getChildProxy(element);
        }
        return null;
    }

    private IJavaElementDelta makeDeltaTree(IJUnitTestSuiteFactoryEvent event) {
        BasicJavaElementChangeDelta delta = null;
        ICompilationUnit cu = null;
        if (event instanceof JUnitTestSuiteCreatedEvent) {
            JUnitTestSuiteCreatedEvent e = (JUnitTestSuiteCreatedEvent)event;
            cu = e.getCompilationUnit();
            delta = new BasicJavaElementChangeDelta((IJavaElement)cu, null, Integer.MIN_VALUE);
        } else if (event instanceof JUnitTestSuiteDetachedEvent) {
            JUnitTestSuiteDetachedEvent e = (JUnitTestSuiteDetachedEvent)event;
            cu = e.getCompilationUnit();
            delta = new BasicJavaElementChangeDelta((IJavaElement)cu, null, 0x40000000);
        }
        if (delta != null && cu != null) {
            return this.makeDeltaTree(cu.getParent(), delta);
        }
        return null;
    }

    private IJavaElementDelta makeDeltaTree(IJavaElement element, IJavaElementDelta child) {
        BasicJavaElementChangeDelta delta = new BasicJavaElementChangeDelta(element, new IJavaElementDelta[]{child}, 8);
        if (element instanceof IJavaModel) {
            return delta;
        }
        return this.makeDeltaTree(element.getParent(), delta);
    }

    public void onEvent(IJUnitTestSuiteFactoryEvent event) {
        IJavaElementDelta delta = this.makeDeltaTree(event);
        if (delta != null) {
            this.elementChanged(new ElementChangedEvent(delta, 4));
        }
    }

    static class BasicJavaElementChangeDelta
    implements IJavaElementDelta {
        public static final int F_TEST_SUITE_ATTACHED = Integer.MIN_VALUE;
        public static final int F_TEST_SUITE_DETACHED = 0x40000000;
        private static IJavaElementDelta[] NO_CHIDLREN = new IJavaElementDelta[0];
        private IJavaElement element;
        private IJavaElementDelta[] children;
        private int flags;

        public BasicJavaElementChangeDelta(IJavaElement element, IJavaElementDelta[] children, int flags) {
            this.element = element;
            this.children = children == null ? NO_CHIDLREN : children;
            this.flags = flags;
        }

        public IJavaElementDelta[] getAddedChildren() {
            return NO_CHIDLREN;
        }

        public IJavaElementDelta[] getAffectedChildren() {
            return this.children;
        }

        public IJavaElementDelta[] getChangedChildren() {
            return this.children;
        }

        public CompilationUnit getCompilationUnitAST() {
            return null;
        }

        public IJavaElement getElement() {
            return this.element;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getKind() {
            return 4;
        }

        public IJavaElement getMovedFromElement() {
            return null;
        }

        public IJavaElement getMovedToElement() {
            return null;
        }

        public IJavaElementDelta[] getRemovedChildren() {
            return NO_CHIDLREN;
        }

        public IResourceDelta[] getResourceDeltas() {
            return null;
        }

        public IJavaElementDelta[] getAnnotationDeltas() {
            return null;
        }
    }
}

