/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator;

import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.JUnitFolderProxyNode;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.navigator.PackageProxyNode;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IResourceChangeListenerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;

public class SourceFolderProxyNode
implements IResourceChangeListenerProxyNode,
IExtendedProxyNode {
    private IPackageFragmentRoot root;
    private IProxyNode[] children;
    private Object parent;
    private static final IProxyNode[] NO_CHILDREN = new IProxyNode[0];
    private ITestFolderContentValidator validator;
    private IFileProxyManager fileProxyManager;

    public static SourceFolderProxyNode create(IPackageFragmentRoot root, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent) {
        SourceFolderProxyNode proxy = new SourceFolderProxyNode(root, validator, fileProxyManager, parent);
        if (proxy.getChildren().length > 0) {
            return proxy;
        }
        return null;
    }

    protected SourceFolderProxyNode(IPackageFragmentRoot root, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent) {
        this.init(root, validator, fileProxyManager, parent, this);
    }

    protected SourceFolderProxyNode(IPackageFragmentRoot root, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent, Object claimedParent) {
        this.init(root, validator, fileProxyManager, parent, claimedParent);
    }

    private void init(IPackageFragmentRoot root, ITestFolderContentValidator validator, IFileProxyManager fileProxyManager, Object parent, Object claimedParent) {
        this.parent = parent;
        this.root = root;
        this.validator = validator;
        this.fileProxyManager = fileProxyManager;
        LinkedList<Object> _children = new LinkedList<Object>();
        try {
            Object[] nonJava = root.getNonJavaResources();
            int i = 0;
            while (i < nonJava.length) {
                IProxyNode proxy;
                Object res = nonJava[i];
                if (res instanceof IFile && validator.isFileOk((IFile)res)) {
                    proxy = fileProxyManager.getProxy((IFile)res, claimedParent);
                    if (proxy != null && validator.isProxyOk(proxy)) {
                        _children.add(proxy);
                        fileProxyManager.cacheProxy((IFile)res, proxy);
                    }
                } else if (res instanceof IContainer && (proxy = JUnitFolderProxyNode.create((IContainer)((IContainer)res), (ITestFolderContentValidator)validator, (IFileProxyManager)fileProxyManager, (boolean)false, (Object)claimedParent)) != null && validator.isProxyOk(proxy)) {
                    _children.add(proxy);
                }
                ++i;
            }
            IJavaElement[] fragments = root.getChildren();
            int i2 = 0;
            while (i2 < fragments.length) {
                IPackageFragment frag = (IPackageFragment)fragments[i2];
                PackageProxyNode proxy = PackageProxyNode.create(frag, validator, fileProxyManager, claimedParent);
                if (proxy != null) {
                    _children.add(proxy);
                }
                ++i2;
            }
            this.children = _children.toArray(new IProxyNode[_children.size()]);
        }
        catch (JavaModelException e) {
            ToolsUiPlugin.logError(e);
            this.children = NO_CHILDREN;
        }
    }

    public String getText() {
        return this.root.getElementName();
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
    }

    public Object getParent() {
        return this.parent;
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContainer.class) {
            try {
                return this.root.getUnderlyingResource();
            }
            catch (JavaModelException e) {
                ToolsUiPlugin.logError(e);
                return null;
            }
        }
        return null;
    }

    public IResource getUnderlyingResource() {
        try {
            return this.root.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            ToolsUiPlugin.logError(e);
            return null;
        }
    }

    public String getIdentifier() {
        return this.root.getElementName();
    }

    private IProxyNode getChildProxy(IResource res) {
        int i = 0;
        while (i < this.children.length) {
            if (res.equals((Object)this.children[i].getUnderlyingResource())) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    private void replaceChildProxy(IProxyNode oldProxy, IProxyNode newProxy) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == oldProxy) {
                this.children[i] = newProxy;
                break;
            }
            ++i;
        }
    }

    private boolean addChildProxy(IProxyNode proxy) {
        if (proxy == null) {
            return false;
        }
        IProxyNode[] newChildren = new IProxyNode[this.children.length + 1];
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].equals(proxy)) {
                return false;
            }
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[this.children.length] = proxy;
        this.children = newChildren;
        return true;
    }

    private void removeChildProxy(IProxyNode proxy) {
        IProxyNode[] newChildren = new IProxyNode[this.children.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != proxy) {
                newChildren[j++] = this.children[i];
            }
            ++i;
        }
        this.children = newChildren;
    }

    public IProxyNode resourceChanged(IResourceDelta rootDelta) {
        Object lowestChanged = null;
        IResourceDelta[] res = rootDelta.getAffectedChildren();
        int i = 0;
        while (i < res.length) {
            int kind = res[i].getKind();
            IProxyNode lowestChild = null;
            if (kind == 1) {
                lowestChild = this.resourceChangedADDED(res[i]);
            } else if (kind == 2) {
                lowestChild = this.resourceChangedREMOVED(res[i]);
            } else if (kind == 4) {
                lowestChild = this.resourceChangedCHANGED(res[i]);
            }
            if (lowestChild != null) {
                lowestChanged = lowestChanged == null ? lowestChild : this;
            }
            ++i;
        }
        return lowestChanged;
    }

    private IProxyNode resourceChangedCHANGED(IResourceDelta delta) {
        IProxyNode lowestChanged = null;
        IResource resource = delta.getResource();
        int resType = resource.getType();
        if (resType == 2) {
            lowestChanged = this.resourceChangedCHANGEDFolder(delta);
        } else if (resType == 1) {
            lowestChanged = this.resourceChangedCHANGEDFile(delta);
        }
        return lowestChanged;
    }

    private IProxyNode resourceChangedCHANGEDFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        SourceFolderProxyNode lowestChanged = null;
        if ((delta.getFlags() & 0x100) != 0) {
            boolean wasAdded;
            IProxyNode newProxy;
            IProxyNode proxy = this.getChildProxy((IResource)file);
            if (proxy != null) {
                if (this.validator.isFileOk(file)) {
                    this.fileProxyManager.uncacheProxy(file);
                    IProxyNode newProxy2 = this.fileProxyManager.updateProxy(file, (Object)this);
                    if (this.validator.isProxyOk(newProxy2)) {
                        this.replaceChildProxy(proxy, newProxy2);
                        this.fileProxyManager.cacheProxy(file, newProxy2);
                    } else {
                        this.removeChildProxy(proxy);
                    }
                    lowestChanged = this;
                }
            } else if (this.validator.isFileOk(file) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy(file, (Object)this)) && (wasAdded = this.addChildProxy(newProxy))) {
                this.fileProxyManager.cacheProxy(file, newProxy);
                lowestChanged = this;
            }
        }
        return lowestChanged;
    }

    private IProxyNode resourceChangedCHANGEDFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        Object lowestChanged = null;
        IProxyNode lowestChild = null;
        IProxyNode proxy = this.getChildProxy((IResource)folder);
        if (proxy != null) {
            if (proxy instanceof IResourceChangeListenerProxyNode) {
                lowestChanged = ((IResourceChangeListenerProxyNode)proxy).resourceChanged(delta);
                if (proxy.getChildren().length == 0) {
                    this.removeChildProxy(proxy);
                    lowestChanged = this;
                }
            }
        } else {
            lowestChanged = PackageProxyNode.create(folder, delta, this.validator, this.fileProxyManager, this);
            if (lowestChanged != null) {
                this.addChildProxy((IProxyNode)lowestChanged);
                lowestChanged = this;
            }
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            if (affectedChildren[i].getResource().getType() == 2) {
                lowestChild = this.resourceChangedCHANGED(affectedChildren[i]);
                lowestChanged = lowestChanged != null ? this : lowestChild;
            }
            ++i;
        }
        return lowestChanged;
    }

    private IProxyNode resourceChangedADDED(IResourceDelta delta) {
        PackageProxyNode proxy;
        IFolder folder;
        IPackageFragment frag;
        IResource resource = delta.getResource();
        int resType = resource.getType();
        if (resType == 1) {
            boolean wasAdded;
            IProxyNode newProxy;
            if (this.validator.isFileOk((IFile)resource) && this.validator.isProxyOk(newProxy = this.fileProxyManager.getProxy((IFile)resource, (Object)this)) && (wasAdded = this.addChildProxy(newProxy))) {
                this.fileProxyManager.cacheProxy((IFile)resource, newProxy);
                return this;
            }
        } else if (resType == 2 && (frag = (IPackageFragment)JavaCore.create((IFolder)(folder = (IFolder)resource))) != null && (proxy = PackageProxyNode.create(frag, this.validator, this.fileProxyManager, this)) != null) {
            this.addChildProxy((IProxyNode)proxy);
            return this;
        }
        return null;
    }

    private IProxyNode resourceChangedREMOVED(IResourceDelta delta) {
        IResource resource = delta.getResource();
        int resType = resource.getType();
        IProxyNode proxy2Remove = this.getChildProxy(resource);
        if (resType == 1) {
            if (proxy2Remove != null) {
                this.fileProxyManager.uncacheProxy((IFile)resource);
                this.removeChildProxy(proxy2Remove);
                return this;
            }
            return null;
        }
        if (resType == 2 && proxy2Remove != null) {
            if (proxy2Remove instanceof IResourceChangeListenerProxyNode) {
                ((IResourceChangeListenerProxyNode)proxy2Remove).resourceChanged(delta);
                this.removeChildProxy(proxy2Remove);
                return this;
            }
            UiPlugin.logError((String)"The proxy node derived from a folder should be a IResourceChangeListenerProxyNode");
        }
        return null;
    }

    public IResource getCorrespondingResource() {
        return this.getUnderlyingResource();
    }
}

