/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Generator;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.AdjustSourceInfoPage;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class GenerateWizard
extends HyadesWizard
implements IRunnableWithProgress {
    public static final String PLUGIN_ID_JUNIT = "org.junit";
    public static final String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core";
    public static final String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote";
    private ITestSuite testSuite;
    private AdjustSourceInfoPage adjustSourceInfoPage;

    public GenerateWizard() {
        this.setWindowTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE);
        this.setDefaultPageImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("generate_wiz.gif"));
        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("junit.GenerateWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("junit.GenerateWizard");
        }
        this.setDialogSettings(settings);
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.getSelection();
        if (structuredSelection.size() == 1) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof ITestSuite) {
                this.testSuite = (ITestSuite)selection;
            } else if (selection instanceof ITestSuiteProxyNode) {
                ITestSuiteProxyNode tsProxy = (ITestSuiteProxyNode)selection;
                this.testSuite = tsProxy.getTestSuite();
            }
        }
        this.adjustSourceInfoPage = new AdjustSourceInfoPage(this.getTestSuite().getImplementor());
    }

    public void addPages() {
        if (this.adjustSourceInfoPage != null) {
            this.addPage((IWizardPage)this.adjustSourceInfoPage);
        }
    }

    public void run(IProgressMonitor mon) throws InterruptedException, InvocationTargetException {
        if (this.getTestSuite() != null) {
            MessageDialog dialog;
            Resource resource = ((EObject)this.getTestSuite()).eResource();
            boolean isTrackingModification = resource.isTrackingModification();
            resource.setTrackingModification(true);
            resource.setModified(this.adjustSourceInfoPage != null);
            Generator generator = this.createGenerator();
            if (generator.getFileHandle(this.getTestSuite()).exists() && (dialog = new MessageDialog(this.getShell(), UiPluginResourceBundle.W_QUESTION, null, ToolsUiPluginResourceBundle.Q_OVR_FILE, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                mon.setCanceled(true);
                throw new InterruptedException();
            }
            try {
                Change change = generator.createChange((IProgressMonitor)new NullProgressMonitor());
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                ToolsUiPlugin.logError(e);
                throw new InvocationTargetException(e);
            }
            if (resource.isModified()) {
                try {
                    EMFUtil.save((Resource)resource);
                }
                catch (Exception e) {
                    ToolsUiPlugin.logError(e);
                }
            }
            resource.setTrackingModification(isTrackingModification);
        }
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected Generator createGenerator() {
        return new JUnitGenerator(this.getTestSuite(), (IProjectDependencyUpdater)new AutomaticDependencyUpdater());
    }
}

