/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.test.tools.core.internal.java.modelsync.JUnitModelUpdater;
import org.eclipse.hyades.test.tools.core.java.IJUnitTestSuiteFactory;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

public class JUnitWorkspaceContentProvider
extends StandardJavaElementContentProvider {
    private Map children = new HashMap();
    private IRunnableContext context;
    private IJUnitTestSuiteFactory factory;

    public void setJUnitTestSuiteFactory(IJUnitTestSuiteFactory factory) {
        if (factory != this.factory) {
            this.factory = factory;
            this.children.clear();
        }
    }

    private Object[] initChildren(Object element) {
        if (element instanceof IJavaProject) {
            IJavaProject jProject = (IJavaProject)element;
            class ComputeProjectChildrenOperation
            implements IRunnableWithProgress {
                private IJavaProject project;
                private List projectChildren = new ArrayList();

                public ComputeProjectChildrenOperation(IJavaProject project) {
                    this.project = project;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IPackageFragment[] packages = this.project.getPackageFragments();
                        monitor.beginTask(NLS.bind((String)ToolsUiPluginResourceBundle.JUnitWorkspaceContentProvider_SEARCH_TASK, (Object)this.project.getElementName()), packages.length);
                        try {
                            int p = 0;
                            while (p < packages.length) {
                                Object[] directChildren = JUnitWorkspaceContentProvider.this.initChildren(packages[p]);
                                if (directChildren.length > 0) {
                                    this.projectChildren.add(packages[p]);
                                    JUnitWorkspaceContentProvider.this.children.put(packages[p], directChildren);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                ++p;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    catch (JavaModelException e) {
                        ToolsUiPlugin.logError(e);
                    }
                }

                public Object[] getProjectChildren() {
                    return this.projectChildren.toArray();
                }
            }
            ComputeProjectChildrenOperation operation = new ComputeProjectChildrenOperation(jProject);
            try {
                if (this.context != null) {
                    this.context.run(false, true, (IRunnableWithProgress)operation);
                } else {
                    operation.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                ToolsUiPlugin.logError(e);
            }
            catch (InterruptedException e) {
                ToolsUiPlugin.logError(e);
            }
            return operation.getProjectChildren();
        }
        if (element instanceof IPackageFragment) {
            ArrayList<IJavaElement> ret = new ArrayList<IJavaElement>();
            IPackageFragment pack = (IPackageFragment)element;
            try {
                IJavaElement[] compilationUnits = pack.getChildren();
                int c = 0;
                while (c < compilationUnits.length) {
                    if (this.isDisplayed(compilationUnits[c])) {
                        ret.add(compilationUnits[c]);
                    }
                    ++c;
                }
                return ret.toArray();
            }
            catch (JavaModelException e) {
                ToolsUiPlugin.logError(e);
                return new Object[0];
            }
        }
        return new Object[0];
    }

    private boolean isDisplayed(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof ICompilationUnit && this.factory.isSupported(cu = (ICompilationUnit)element)) {
            try {
                return JUnitModelUpdater.findTestSuiteFile((IFile)((IFile)cu.getUnderlyingResource())) == null;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IJavaModel) {
            Object[] projects = super.getChildren(element);
            return this.filterProjects(projects);
        }
        if (!this.children.containsKey(element)) {
            Object[] ch = this.initChildren(element);
            this.children.put(element, ch);
            return ch;
        }
        return (Object[])this.children.get(element);
    }

    private Object[] filterProjects(Object[] projects) {
        if (this.factory == null) {
            return NO_CHILDREN;
        }
        ArrayList<Object> result = new ArrayList<Object>(projects.length);
        int i = 0;
        while (i < projects.length) {
            if (this.factory.isSupported((IJavaProject)projects[i])) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IJavaProject) {
            return true;
        }
        if (element instanceof IPackageFragment) {
            return this.getChildren(element).length != 0;
        }
        if (element instanceof ICompilationUnit) {
            return false;
        }
        return super.hasChildren(element);
    }

    public void setRunnableContext(IRunnableContext context) {
        this.context = context;
    }
}

