/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ProjectAndSourcePage
extends WizardPage
implements ModifyListener,
SelectionListener {
    protected static final String SET_PROJECT = "PROJECT_NAME";
    protected static final String SET_SOURCE = "SOURCE_FOLDER_NAME";
    private IImplementor implementor;
    private IJavaProject[] javaProjects;
    private Text javaProjectText;
    private Button selectJavaProjectButton;
    private Text sourceFolderText;
    private Button selectSourceFolderButton;

    public ProjectAndSourcePage(IImplementor implementor, IJavaProject[] javaProjects) {
        super("ProjectAndSourcePage");
        this.setTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE);
        this.setDescription(ToolsUiPluginResourceBundle.JAVA_GEN_LDESC);
        this.implementor = implementor;
        this.javaProjects = javaProjects;
    }

    public void dispose() {
        this.implementor = null;
        super.dispose();
    }

    public IJavaProject[] getJavaProjects() {
        return this.javaProjects;
    }

    public void createControl(Composite parent) {
        ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(ToolsUiPlugin.getID()) + ".itdg0001");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        Label label = new Label(composite, 0);
        label.setText(ToolsUiPluginResourceBundle.STR_WB_PROJECT);
        this.javaProjectText = new Text(composite, 2052);
        this.javaProjectText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.selectJavaProjectButton = new Button(composite, 8);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        this.selectJavaProjectButton.setLayoutData((Object)gridData);
        this.selectJavaProjectButton.setText(ToolsUiPluginResourceBundle.STR_WB_BROWSE_BTN);
        this.selectJavaProjectButton.addSelectionListener((SelectionListener)this);
        this.selectJavaProjectButton.setEnabled(this.javaProjects.length > 0);
        label = new Label(composite, 0);
        label.setText(ToolsUiPluginResourceBundle.STR_WB_SRC_FOLDER);
        this.sourceFolderText = new Text(composite, 2052);
        this.sourceFolderText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.sourceFolderText.setEditable(false);
        this.selectSourceFolderButton = new Button(composite, 8);
        gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        this.selectSourceFolderButton.setLayoutData((Object)gridData);
        this.selectSourceFolderButton.setText(ToolsUiPluginResourceBundle.STR_WB_SOURCE_BTN);
        this.selectSourceFolderButton.addSelectionListener((SelectionListener)this);
        if (this.selectJavaProjectButton.isEnabled()) {
            IResource resource;
            if (this.implementor.getLocation() != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.implementor.getLocation())) != null && resource.exists()) {
                if (resource.getType() == 4) {
                    this.javaProjectText.setText(resource.getName());
                } else if (resource.getType() == 2) {
                    this.javaProjectText.setText(resource.getProject().getName());
                    this.sourceFolderText.setText(resource.getFullPath().removeFirstSegments(1).toString());
                }
            }
            if (this.javaProjectText.getText().length() == 0) {
                String value = this.getDialogSettings().get(SET_PROJECT);
                if (value != null && this.getJavaProject(value) != null) {
                    this.javaProjectText.setText(value);
                }
                if ((value = this.getDialogSettings().get(SET_SOURCE)) != null) {
                    this.sourceFolderText.setText(value);
                }
            }
            this.setPageComplete(this.validatePage());
            this.setErrorMessage(null);
            this.javaProjectText.addModifyListener((ModifyListener)this);
            this.sourceFolderText.addModifyListener((ModifyListener)this);
            this.javaProjectText.setFocus();
        } else {
            this.setPageComplete(false);
            this.selectSourceFolderButton.setEnabled(false);
            this.javaProjectText.setEditable(false);
            this.setErrorMessage(ToolsUiPluginResourceBundle.NO_JAVA_PRJ);
            composite.setFocus();
        }
        this.setControl((Control)composite);
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.validatePage());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.selectJavaProjectButton) {
            IJavaProject javaProject = this.chooseJavaProject();
            if (javaProject != null) {
                this.javaProjectText.setText(javaProject.getElementName());
            }
        } else if (e.widget == this.selectSourceFolderButton) {
            Object object = this.chooseSourceFolder();
            if (object instanceof IJavaProject) {
                this.javaProjectText.setText(((IJavaProject)object).getElementName());
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)object;
                this.javaProjectText.removeModifyListener((ModifyListener)this);
                this.javaProjectText.setText(packageFragmentRoot.getJavaProject().getElementName());
                this.javaProjectText.addModifyListener((ModifyListener)this);
                this.sourceFolderText.setText(packageFragmentRoot.getPath().removeFirstSegments(1).toString());
            }
        }
    }

    protected boolean validatePage() {
        String value = this.javaProjectText.getText();
        if (value.trim().length() == 0) {
            this.setErrorMessage(ToolsUiPluginResourceBundle._ERROR_WIZ_EMPTY_PROJECT);
            return false;
        }
        IJavaProject javaProject = this.getJavaProject(value);
        if (javaProject == null) {
            this.setErrorMessage(ToolsUiPluginResourceBundle._ERROR_WIZ_NOT_EXIST_PROJECT);
            return false;
        }
        List sourceFolders = TestJavaUtil.getSourceFolders(javaProject);
        if (sourceFolders.isEmpty()) {
            this.sourceFolderText.removeModifyListener((ModifyListener)this);
            this.sourceFolderText.setEditable(false);
            this.sourceFolderText.addModifyListener((ModifyListener)this);
        } else {
            this.sourceFolderText.setEditable(true);
            value = this.sourceFolderText.getText();
            if (value.trim().length() == 0) {
                this.setErrorMessage(ToolsUiPluginResourceBundle._ERROR_WIZ_EMPTY_FOLDER);
                return false;
            }
            if (!this.isValidFolderName()) {
                this.setErrorMessage(ToolsUiPluginResourceBundle._ERROR_INV_FLD_NME);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isValidFolderName() {
        String folder = this.getSourceFolder();
        if (folder.startsWith("/")) {
            return false;
        }
        return !folder.endsWith("/");
    }

    public String getSourceFolder() {
        if (this.sourceFolderText.getEditable()) {
            return this.sourceFolderText.getText().trim().replace('\\', '/');
        }
        return "";
    }

    protected IJavaProject getJavaProject() {
        return this.getJavaProject(this.javaProjectText.getText());
    }

    protected IJavaProject getJavaProject(String projectName) {
        IJavaProject javaProject;
        if (projectName != null && projectName.trim().length() > 0 && (javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(projectName)).exists()) {
            return javaProject;
        }
        return null;
    }

    protected IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(ToolsUiPluginResourceBundle.TITLE_PROJECT_SELECT);
        dialog.setMessage(ToolsUiPluginResourceBundle.STR_PROJECT_SELECT);
        dialog.setElements((Object[])this.javaProjects);
        IJavaProject javaProject = this.getJavaProject(this.javaProjectText.getText());
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected Object chooseSourceFolder() {
        ElementTreeSelectionDialog dialog = TestJavaUtil.createSourceFolderDialog(this.getShell(), null);
        dialog.setTitle(ToolsUiPluginResourceBundle.TITLE_SRC_SELECT);
        dialog.setMessage(ToolsUiPluginResourceBundle.STR_SRC_SELECT);
        IJavaProject javaProject = this.getJavaProject(this.javaProjectText.getText());
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return dialog.getFirstResult();
        }
        return null;
    }
}

