/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.java.codegen.JUnitGenerator;
import org.eclipse.hyades.test.tools.core.internal.util.PluginProjectUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;

public class SourcePage
extends NewTypeWizardPage
implements SelectionListener {
    private Button modelBehaviorRadio = null;
    private Button codeBehaviorRadio = null;
    private boolean isModelBehavior = false;
    private boolean dontAskMissingLibsAgain = false;
    private LocationPage nextPage = null;
    private static final String BEHAVIOR = "behavior";

    public SourcePage() {
        super(true, "ProjectAndSourcePage");
        this.setTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE);
        this.setDescription(ToolsUiPluginResourceBundle.JAVA_GEN_LDESC);
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IStructuredSelection selection, LocationPage locationPage) {
        this.nextPage = locationPage;
        IJavaElement element = this.getInitialJavaElement(selection);
        this.setModelBehavior(true);
        this.initContainerPage(element);
        this.initTypePage(element);
        this.setDefautSuperClass();
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 4;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(nColumns, false));
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createBehaviorControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(ToolsUiPlugin.getID()) + ".itdg0001");
    }

    protected void createBehaviorControls(Composite composite, int numColumns) {
        Label label = new Label(composite, 0);
        label.setText(ToolsUiPluginResourceBundle.SourcePage_behaviorModePrompt);
        GridData gridData = new GridData(1, 1, false, false, numColumns, 1);
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        Composite radioGroup = new Composite(composite, 1);
        GridLayout radioLayout = new GridLayout();
        radioGroup.setLayout((Layout)radioLayout);
        gridData = new GridData(4, 1, true, false, numColumns - 2, 1);
        radioGroup.setLayoutData((Object)gridData);
        this.modelBehaviorRadio = new Button(radioGroup, 16);
        this.modelBehaviorRadio.setText(ToolsUiPluginResourceBundle.SourcePage_modelBehaviorChoice);
        this.modelBehaviorRadio.addSelectionListener((SelectionListener)this);
        this.codeBehaviorRadio = new Button(radioGroup, 16);
        this.codeBehaviorRadio.setText(ToolsUiPluginResourceBundle.SourcePage_codeBehaviorChoice);
        if (this.isModelBehavior()) {
            this.modelBehaviorRadio.setSelection(true);
        } else {
            this.codeBehaviorRadio.setSelection(true);
        }
        label = new Label(composite, 0);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.modelBehaviorRadio) {
            this.setModelBehavior(this.modelBehaviorRadio.getSelection());
            this.handleFieldChanged(BEHAVIOR);
        }
    }

    public void setModelBehavior(boolean state) {
        this.isModelBehavior = state;
    }

    public boolean isModelBehavior() {
        return this.isModelBehavior;
    }

    protected void setDefautSuperClass() {
        if (this.isModelBehavior()) {
            this.setSuperClass("org.eclipse.hyades.test.common.junit.HyadesTestCase", false);
        } else {
            this.setSuperClass("junit.framework.TestCase", true);
        }
    }

    protected void behaviorChanged() {
        this.setDefautSuperClass();
        this.fContainerStatus = this.containerChanged();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (BEHAVIOR.equals(fieldName)) {
            this.behaviorChanged();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        if (this.nextPage != null) {
            this.nextPage.setFileName(this.getTypeName());
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus});
    }

    public String getQualifiedTypeName() {
        String packageName = this.getPackageText();
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + '.' + this.getTypeName();
        }
        return this.getTypeName();
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] superInterfaces = typeHier.getAllInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            if (superInterfaces[i].getFullyQualifiedName().equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IStatus superClassChanged() {
        IStatus status;
        block6: {
            status = super.superClassChanged();
            if (status.getSeverity() != 0) {
                return status;
            }
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            if (root != null && root.exists()) {
                try {
                    IType type = root.getJavaProject().findType(this.getSuperClass());
                    if (type != null) {
                        if (!SourcePage.isTestImplementor(type)) {
                            return new Status(4, ToolsUiPlugin.getID(), 1, ToolsUiPluginResourceBundle.SourcePage_invalidSuperClassError, null);
                        }
                        break block6;
                    }
                    return new Status(2, ToolsUiPlugin.getID(), 1, ToolsUiPluginResourceBundle.SourcePage_superClassNotFound, null);
                }
                catch (JavaModelException e) {
                    ToolsUiPlugin.logError(e);
                }
            }
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus projectStatus;
        IStatus containerStatus = super.containerChanged();
        this.dontAskMissingLibsAgain = false;
        if (!containerStatus.matches(4) && !(projectStatus = this.validateProjectClasspath()).isOK()) {
            return projectStatus;
        }
        return containerStatus;
    }

    protected IStatus validateProjectClasspath() {
        Status status = new Status(0, ToolsUiPlugin.getID(), 1, "", null);
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        IJavaProject jp = root.getJavaProject();
        JUnitGenerator.JUnitProjectDependencyUpdater updater = new JUnitGenerator.JUnitProjectDependencyUpdater((IProjectDependencyUpdater)new AutomaticDependencyUpdater(), this.isModelBehavior());
        Collection missingLibraries = updater.previewAdjustProject(jp.getProject());
        if (missingLibraries.isEmpty()) {
            return status;
        }
        if (!this.dontAskMissingLibsAgain) {
            String message = this.computeMessage(jp.getProject(), missingLibraries);
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ToolsUiPluginResourceBundle.SourcePage_not_on_buildpath_title, (String)message)) {
                try {
                    updater.adjustProject(jp.getProject(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ToolsUiPlugin.logError(e);
                }
                return status;
            }
            this.dontAskMissingLibsAgain = true;
        }
        if (missingLibraries.size() == 1) {
            return new Status(2, ToolsUiPlugin.getID(), 1, NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_error_jarNotOnbuildpath, (Object)missingLibraries.toString()), null);
        }
        return new Status(2, ToolsUiPlugin.getID(), 1, NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_error_jarsNotOnbuildpath, (Object)missingLibraries.toString()), null);
    }

    private String computeMessage(IProject project, Collection missingLibraries) {
        String librariesAsText = "";
        Iterator it = missingLibraries.iterator();
        boolean moreThanOneElement = missingLibraries.size() > 1;
        while (it.hasNext()) {
            if (moreThanOneElement) {
                librariesAsText = String.valueOf(librariesAsText) + "\n\t- ";
            }
            librariesAsText = String.valueOf(librariesAsText) + (String)it.next();
        }
        String message = PluginProjectUtil.isStrictPluginProject((IProject)project) ? (missingLibraries.size() == 1 ? NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_lib_not_on_buildpath_message, (Object[])new String[]{librariesAsText, project.getName()}) : NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_libs_not_on_buildpath_message, (Object[])new String[]{project.getName(), librariesAsText})) : (missingLibraries.size() == 1 ? NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_jar_not_on_buildpath_message, (Object[])new String[]{librariesAsText, project.getName()}) : NLS.bind((String)ToolsUiPluginResourceBundle.SourcePage_jars_not_on_buildpath_message, (Object[])new String[]{project.getName(), librariesAsText}));
        return message;
    }
}

