/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.trace.views.internal.context.java.BasicContextProvider;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.context.AverageAgeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.GenerationsLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.LineNumberLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextAttributes;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadBlockCountLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadBlockedTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadClassNameLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadDeadlockCountLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadDeadlockedTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadNameLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadRunningTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadSleepingTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadStartTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadStateLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadStopTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.context.ThreadWaitingTimeLP;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.CustomColumn;

public class TIContextProvider
extends BasicContextProvider
implements TIContextAttributes {
    private Map _contextLabelFormatProviders;
    private ArrayList _supportAttributes;
    private static TIContextProvider _instance;
    private Map<String, AttrLPAdapter> _customAttributes;

    public static TIContextProvider instance() {
        if (_instance == null) {
            _instance = new TIContextProvider();
        }
        return _instance;
    }

    public TIContextProvider() {
        _instance = this;
        this._contextLabelFormatProviders = new HashMap();
        this._supportAttributes = new ArrayList();
        this._supportAttributes.add("method.line.number");
        this._supportAttributes.add("package.avg.age");
        this._supportAttributes.add("package.generations");
        this._supportAttributes.add("class.avg.age");
        this._supportAttributes.add("class.generations");
        this._supportAttributes.add("callsite.avg.age");
        this._supportAttributes.add("callsite.generations");
        this._supportAttributes.add("thread.name");
        this._supportAttributes.add("thread.name.and.class");
        this._supportAttributes.add("thread.start.time");
        this._supportAttributes.add("thread.stop.time");
        this._supportAttributes.add("thread.state");
        this._supportAttributes.add("thread.running.time");
        this._supportAttributes.add("thread.sleeping.time");
        this._supportAttributes.add("thread.waiting.time");
        this._supportAttributes.add("thread.blocked.time");
        this._supportAttributes.add("thread.deadlocked.time");
        this._supportAttributes.add("thread.block.count");
        this._supportAttributes.add("thread.deadlock.count");
        this._customAttributes = new HashMap<String, AttrLPAdapter>();
        CustomColumn[] customColumnArray = CustomColumn.getContributors();
        int n = customColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomColumn customColumn = customColumnArray[n2];
            this._customAttributes.put(customColumn.getId(), customColumn.getAttrAdapter());
            ++n2;
        }
    }

    public String getBaseProvider() {
        return null;
    }

    public IContextLabelFormatProvider getContextLabelFormatProvider(String key) {
        Object result = (IContextLabelFormatProvider)this._contextLabelFormatProviders.get(key);
        if (result != null) {
            return result;
        }
        if (this._supportAttributes.contains(key)) {
            if (key.equals("method.line.number")) {
                result = new LineNumberLP();
            } else if (key.equals("package.avg.age") || key.equals("class.avg.age") || key.equals("callsite.avg.age")) {
                result = new AverageAgeLP();
            } else if (key.equals("package.generations") || key.equals("class.generations") || key.equals("callsite.generations")) {
                result = new GenerationsLP();
            } else if (key.equals("thread.name")) {
                result = new ThreadNameLP();
            } else if (key.equals("thread.name.and.class")) {
                result = new ThreadClassNameLP();
            } else if (key.equals("thread.start.time")) {
                result = new ThreadStartTimeLP();
            } else if (key.equals("thread.stop.time")) {
                result = new ThreadStopTimeLP();
            } else if (key.equals("thread.state")) {
                result = new ThreadStateLP();
            } else if (key.equals("thread.running.time")) {
                result = new ThreadRunningTimeLP();
            } else if (key.equals("thread.sleeping.time")) {
                result = new ThreadSleepingTimeLP();
            } else if (key.equals("thread.waiting.time")) {
                result = new ThreadWaitingTimeLP();
            } else if (key.equals("thread.blocked.time")) {
                result = new ThreadBlockedTimeLP();
            } else if (key.equals("thread.deadlocked.time")) {
                result = new ThreadDeadlockedTimeLP();
            } else if (key.equals("thread.block.count")) {
                result = new ThreadBlockCountLP();
            } else if (key.equals("thread.deadlock.count")) {
                result = new ThreadDeadlockCountLP();
            }
        } else {
            result = this._customAttributes.containsKey(key) ? (IContextLabelFormatProvider)this._customAttributes.get(key) : super.getContextLabelFormatProvider(key);
        }
        if (result != null) {
            this._contextLabelFormatProviders.put(key, result);
        }
        return result;
    }

    public String getDescription() {
        return null;
    }

    public String getName() {
        return UIMessages.TI_CONTEXT_PROVIDER;
    }

    public String[] getSupportAttributes() {
        String[] supportAttributes0 = super.getSupportAttributes();
        String[] supportAttributes = new String[supportAttributes0.length + this._supportAttributes.size()];
        System.arraycopy(supportAttributes0, 0, supportAttributes, 0, supportAttributes0.length);
        int i = supportAttributes0.length;
        while (i < supportAttributes.length) {
            supportAttributes[i] = (String)this._supportAttributes.get(i - supportAttributes0.length);
            ++i;
        }
        return supportAttributes;
    }
}

