/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.trace.jvmti.internal.client.AllocationSite;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.StatisticViewColumnInfo;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class AllocationDetailsView
extends BaseStatisticView {
    public static final int AD_COL_METHOD_NAME = 0;
    public static final int AD_COL_LINE_NO = 1;
    public static final int AD_COL_CLASS_NAME = 2;
    public static final int AD_COL_PACKAGE_NAME = 3;
    public static final int AD_COL_LIVE_INST = 4;
    public static final int AD_COL_LIVE_SIZE = 5;
    public static final int AD_COL_TOTAL_INST = 6;
    public static final int AD_COL_TOTAL_SIZE = 7;
    public static final int AD_COL_AVG_AGE = 8;
    private Map _allocSites = new HashMap();
    private TRCClass _class;
    private int _nextIndex;
    private Label _label;
    AllocationSite _allocAll = new AllocationSite();
    static final Object[] _emptyArr = new Object[0];
    private NumberFormat _commaNumFormat = NumberFormat.getInstance();

    protected AllocationDetailsView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    protected String getColumnsPreferencesKey() {
        return "org.eclipse.hyades.trace.views.statistic.allocdetails04";
    }

    protected String getViewTypeStr() {
        return "viewoption.allocdetails";
    }

    protected void createLabel(Composite viewContainer) {
        this._label = this._toolkit.createLabel(viewContainer, null);
        Font font = this._label.getFont();
        FontData fd = font.getFontData()[0];
        font = new Font(null, new FontData(fd.getName(), fd.getHeight() * 3 / 2, fd.getStyle() | 1));
        this._label.setFont(font);
        this._label.setBackground(viewContainer.getBackground());
        this._label.setForeground(this._toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this._label.setLayoutData((Object)GridUtil.createHorizontalFill());
    }

    protected String getDefaultColumnsTemplate() {
        return "method.name:0:" + String.valueOf(7) + ":left:150," + "method.line.number" + ":" + 1 + ":" + String.valueOf(1) + ":right:80," + "class.name" + ":" + 2 + ":" + String.valueOf(1) + ":left:150," + "package.name" + ":" + 3 + ":" + String.valueOf(1) + ":left:120," + "class.live.inst" + ":" + 4 + ":" + String.valueOf(1) + ":right:80," + "class.active.size" + ":" + 5 + ":" + String.valueOf(1) + ":right:80," + "class.total.inst" + ":" + 6 + ":" + String.valueOf(1) + ":right:80," + "class.total.size" + ":" + 7 + ":" + String.valueOf(1) + ":right:80," + "class.avg.age" + ":" + 8 + ":" + String.valueOf(1) + ":right:80";
    }

    private String formatNumberWCommas(long number) {
        return this._commaNumFormat.format(number);
    }

    public String getColumnText(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        String label = "";
        if (!(element instanceof AllocationSite)) {
            return label;
        }
        boolean noperc = !this.isShowPercent();
        AllocationSite allocSite = (AllocationSite)element;
        switch (pos) {
            case 0: {
                label = allocSite.getMethodName();
                if (label != null) break;
                label = "?";
                break;
            }
            case 2: {
                label = allocSite.getClassName();
                break;
            }
            case 3: {
                label = allocSite.getPackageName();
                if (label == null || label.length() != 0) break;
                label = TraceUIMessages._87;
                break;
            }
            case 1: {
                label = String.valueOf(allocSite._lineNo);
                break;
            }
            case 6: {
                if (noperc) {
                    label = this.formatNumberWCommas(allocSite._total);
                    break;
                }
                label = Utils.formatPercent(allocSite._total, this._allocAll._total);
                break;
            }
            case 7: {
                if (noperc) {
                    label = this.formatNumberWCommas(allocSite._totalSize);
                    break;
                }
                label = Utils.formatPercent(allocSite._totalSize, this._allocAll._totalSize);
                break;
            }
            case 4: {
                if (noperc) {
                    label = this.formatNumberWCommas(allocSite._total - allocSite._collected);
                    break;
                }
                label = Utils.formatPercent(allocSite._total - allocSite._collected, this._allocAll._total - this._allocAll._collected);
                break;
            }
            case 5: {
                if (noperc) {
                    label = this.formatNumberWCommas(allocSite._totalSize - allocSite._collectedSize);
                    break;
                }
                label = Utils.formatPercent(allocSite._totalSize - allocSite._collectedSize, this._allocAll._totalSize - this._allocAll._collectedSize);
                break;
            }
            case 8: {
                if (noperc) {
                    double age = 0.0;
                    if (allocSite._total > 0) {
                        age = (double)allocSite._sumAges / (double)allocSite._total;
                        label = String.valueOf(age);
                    }
                    IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider("callsite.avg.age");
                    label = formatter.getDisplayStringFromElement((Object)new Double(age), null, 1);
                    break;
                }
                label = Utils.formatPercent(allocSite._sumAges, this._allocAll._sumAges);
            }
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        Image image = null;
        if (!(element instanceof AllocationSite)) {
            return image;
        }
        AllocationSite allocSite = (AllocationSite)element;
        String name = null;
        switch (pos) {
            case 0: {
                name = allocSite.getMethodName();
                if (name == null) break;
                IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider("method.name");
                image = formatter.getDisplayImageByElement((Object)name, null, 1);
                break;
            }
            case 2: {
                name = allocSite.getClassName();
                if (name == null) break;
                IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider("class.name");
                image = formatter.getDisplayImageByElement((Object)name, null, 1);
                break;
            }
            case 3: {
                name = allocSite.getPackageName();
                if (name == null) break;
                IContextLabelFormatProvider formatter = TIContextProvider.instance().getContextLabelFormatProvider("package.name");
                image = formatter.getDisplayImageByElement((Object)name, null, 1);
            }
        }
        return image;
    }

    public int compareElements(Object e1, Object e2, int pos, boolean isDelta) {
        int ret = 0;
        if (!(e1 instanceof AllocationSite) || !(e2 instanceof AllocationSite)) {
            return ret;
        }
        AllocationSite a1 = (AllocationSite)e1;
        AllocationSite a2 = (AllocationSite)e2;
        switch (pos) {
            case 3: {
                if (ret == 0) {
                    ret = Utils.compare(a1.getPackageName(), a2.getPackageName());
                }
            }
            case 2: {
                if (ret == 0) {
                    ret = Utils.compare(a1.getClassName(), a2.getClassName());
                }
            }
            case 0: {
                if (ret == 0) {
                    ret = Utils.compare(a1.getMethodName(), a2.getMethodName());
                }
            }
            case 1: {
                if (ret != 0) break;
                ret = a1._lineNo - a2._lineNo;
                break;
            }
            case 6: {
                ret = a1._total - a2._total;
                break;
            }
            case 7: {
                ret = a1._totalSize - a2._totalSize;
                break;
            }
            case 4: {
                ret = a1._total - a1._collected - (a2._total - a2._collected);
                break;
            }
            case 5: {
                ret = a1._totalSize - a1._collectedSize - (a2._totalSize - a2._collectedSize);
                break;
            }
            case 8: {
                ret = a1._sumAges - a2._sumAges;
            }
        }
        return ret;
    }

    public Object[] getElements(Object inputElement) {
        this.updateData();
        return this._allocSites.values().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    protected BaseStatisticView.StatisticSorter getViewerSorterInstance() {
        return new BaseStatisticView.StatisticSorter(this){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this._sortSequence * AllocationDetailsView.this.compareElements(e1, e2, this._pos, this._info.isDeltaColumn());
            }
        };
    }

    protected void showAllocDetails(Object obj) {
        if (obj == null || obj instanceof TRCClass) {
            this._class = (TRCClass)obj;
            this._nextIndex = 0;
            this._allocSites.clear();
            this._allocAll.clear();
            String text = Utils.getPackageClassName(this._class);
            if (text.length() > 0) {
                text = String.valueOf(UIMessages.MEM_ALLOCATION_DETAILS_FOR) + " '" + text + "'";
            }
            this._label.setText(text);
        }
        this.update();
    }

    void updateData() {
        this._nextIndex = 0;
        this._allocSites.clear();
        this._allocAll.clear();
        if (this._class == null) {
            return;
        }
        TRCObjectAllocationAnnotation aa = Utils.getAllocationAnnotation(this._class);
        if (aa == null) {
            return;
        }
        EList listGC = this._class.getPackage().getProcess().getGcEvents();
        EList lineNumbers = aa.getLineNumbers();
        EList methods = aa.getMethods();
        EList objects = this._class.getObjects();
        int lineNoLen = lineNumbers.size();
        int methodsLen = methods.size();
        int objectsLen = objects.size();
        int i = this._nextIndex;
        while (i < lineNoLen) {
            int j;
            Long siteId;
            AllocationSite allocSite;
            Integer lineNo = (Integer)lineNumbers.get(i);
            TRCMethod method = null;
            long id = lineNo.intValue();
            if (i < methodsLen) {
                method = (TRCMethod)methods.get(i);
                id += (long)(method.getId() << 20);
            }
            if ((allocSite = (AllocationSite)this._allocSites.get(siteId = new Long(id))) == null) {
                int line = lineNo;
                allocSite = new AllocationSite(line, method);
                this._allocSites.put(siteId, allocSite);
            }
            if ((j = i + i + 1) < objectsLen && objects.get(j) instanceof TRCFullTraceObject) {
                TRCFullTraceObject trObj = (TRCFullTraceObject)objects.get(j);
                int objSize = trObj.getSize();
                if (trObj.getCollectTime() > 0.0) {
                    ++allocSite._collected;
                    allocSite._collectedSize += objSize;
                    ++this._allocAll._collected;
                    this._allocAll._collectedSize += objSize;
                }
                int age = Utils.getObjAge(trObj, listGC);
                allocSite._totalSize += objSize;
                allocSite._sumAges += age;
                ++allocSite._total;
                this._allocAll._totalSize += objSize;
                this._allocAll._sumAges += age;
                ++this._allocAll._total;
            }
            ++i;
        }
        this._nextIndex = lineNoLen;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (event.item.getData() instanceof AllocationSite) {
            AllocationSite allocSite = (AllocationSite)event.item.getData();
            String pattern = Utils.composeMethodName(allocSite);
            Utils.openSource(pattern);
        }
    }
}

