/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.DynamicFilter;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersEditorAction;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.context.TIContextUpdaterHelper;
import org.eclipse.tptp.trace.jvmti.internal.client.views.AllocationDetailsView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MemoryAnalysisPage;
import org.eclipse.tptp.trace.jvmti.internal.client.views.StatisticViewColumnInfo;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.AvgAgeLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ClassPackageNameLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.LiveInstancesLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.LiveSizeLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.PackageNameLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.TotalInstancesLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.TotalSizeLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.CustomAnalysisView;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.CustomColumn;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.ICustomAnalysisView;

public class BaseMemoryStatisticView
extends BaseStatisticView {
    public static final int CLASS_MODE = 0;
    public static final int PACKAGE_MODE = 1;
    public static final int CM_COL_NAME = 0;
    public static final int CM_COL_PACKAGE_NAME = 1;
    public static final int CM_COL_LIVE_INST = 2;
    public static final int CM_COL_LIVE_SIZE = 3;
    public static final int CM_COL_TOTAL_INST = 4;
    public static final int CM_COL_TOTAL_SIZE = 5;
    public static final int CM_COL_AVG_AGE = 6;
    public static final int CM_COL_NUM = 7;
    public static final int PM_COL_NAME = 0;
    public static final int PM_COL_LIVE_INST = 1;
    public static final int PM_COL_LIVE_SIZE = 2;
    public static final int PM_COL_TOTAL_INST = 3;
    public static final int PM_COL_TOTAL_SIZE = 4;
    public static final int PM_COL_AVG_AGE = 5;
    public static final int PM_COL_NUM = 6;
    protected int _totalAge;
    protected int _totalGenerations;
    protected AllocationDetailsView _viewDetails;
    private static int V = 1;
    private static int D = 16;
    private int _viewMode = 0;
    private TRCPackageImpl.TRCPackageSnapshot packageSnapshot = new TRCPackageImpl.TRCPackageSnapshot();
    private TRCClassImpl.TRCClassSnapshot classSnapshot = new TRCClassImpl.TRCClassSnapshot();
    private ColumnLabelAdapter[] _packageModeCols;
    private ColumnLabelAdapter[] _classModeCols;
    private String _customClassColumnTemplate = "";
    private String _customPackageColumnTemplate = "";
    private Map _ageMap = new Hashtable();
    private Link setFilter;

    public BaseMemoryStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
        ICustomAnalysisView[] customViewProviders;
        this.createColumnsLabelProviders();
        ICustomAnalysisView[] iCustomAnalysisViewArray = customViewProviders = CustomAnalysisView.getContributors();
        int n = customViewProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomAnalysisView customView = iCustomAnalysisViewArray[n2];
            customView.attachView(this, page);
            ++n2;
        }
    }

    public void dispose() {
        ICustomAnalysisView[] iCustomAnalysisViewArray = CustomAnalysisView.getContributors();
        int n = iCustomAnalysisViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomAnalysisView customView = iCustomAnalysisViewArray[n2];
            customView.detachView(this);
            ++n2;
        }
        super.dispose();
    }

    public int getViewMode() {
        return this._viewMode;
    }

    public void setViewMode(int viewMode) {
        if ((viewMode = 1 == viewMode ? 1 : 0) == this._viewMode) {
            return;
        }
        this._viewMode = viewMode;
        this.redrawTable();
        this.update();
    }

    ColumnLabelAdapter getColumnsLabelProvider(int col) {
        if (1 == this._viewMode) {
            return this._packageModeCols[col];
        }
        return this._classModeCols[col];
    }

    private void createColumnsLabelProviders() {
        CustomColumn[] customColumns = CustomColumn.getContributors();
        LinkedList<ColumnLabelAdapter> customClassLabels = new LinkedList<ColumnLabelAdapter>();
        LinkedList<ColumnLabelAdapter> customPackageLabels = new LinkedList<ColumnLabelAdapter>();
        int customClassCount = 0;
        int customPackageCount = 0;
        int i = 0;
        while (i < customColumns.length) {
            if (customColumns[i].isEnabled(this._page)) {
                ColumnLabelAdapter labelAdapter = customColumns[i].getLabelAdapter();
                if (customColumns[i].getViewMode() == 0) {
                    customClassLabels.add(labelAdapter);
                    this._customClassColumnTemplate = String.valueOf(this._customClassColumnTemplate) + "," + customColumns[i].getId() + ":" + (7 + customClassCount) + ":" + customColumns[i].getStyle() + ":" + customColumns[i].getAlign() + ":" + customColumns[i].getWidth();
                    ++customClassCount;
                } else if (1 == customColumns[i].getViewMode()) {
                    customPackageLabels.add(labelAdapter);
                    this._customPackageColumnTemplate = String.valueOf(this._customPackageColumnTemplate) + "," + customColumns[i].getId() + ":" + (6 + customPackageCount) + ":" + customColumns[i].getStyle() + ":" + customColumns[i].getAlign() + ":" + customColumns[i].getWidth();
                    ++customPackageCount;
                }
            }
            ++i;
        }
        this._classModeCols = new ColumnLabelAdapter[7 + customClassLabels.size()];
        this._classModeCols[0] = new ClassPackageNameLabelAdapter();
        this._classModeCols[1] = new PackageNameLabelAdapter();
        this._classModeCols[2] = new LiveInstancesLabelAdapter();
        this._classModeCols[3] = new LiveSizeLabelAdapter();
        this._classModeCols[4] = new TotalInstancesLabelAdapter();
        this._classModeCols[5] = new TotalSizeLabelAdapter();
        this._classModeCols[6] = new AvgAgeLabelAdapter(this._ageMap);
        i = 7;
        while (i < this._classModeCols.length) {
            this._classModeCols[i] = (ColumnLabelAdapter)customClassLabels.get(i - 7);
            ++i;
        }
        this._packageModeCols = new ColumnLabelAdapter[6 + customPackageLabels.size()];
        this._packageModeCols[0] = this._classModeCols[0];
        this._packageModeCols[1] = this._classModeCols[2];
        this._packageModeCols[2] = this._classModeCols[3];
        this._packageModeCols[3] = this._classModeCols[4];
        this._packageModeCols[4] = this._classModeCols[5];
        this._packageModeCols[5] = this._classModeCols[6];
        i = 6;
        while (i < this._packageModeCols.length) {
            this._packageModeCols[i] = (ColumnLabelAdapter)customPackageLabels.get(i - 6);
            ++i;
        }
        i = 0;
        while (i < 7) {
            if (i != 0 && i != 1 && this._classModeCols[i] != null) {
                this._classModeCols[i].initialize(this.packageSnapshot, this.classSnapshot, null);
            }
            ++i;
        }
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._classModeCols[1]) {
            return TIContextUpdaterHelper.updatePackageName((ColumnLabelAdapter)col, (EObject)this._page.getMOFObject());
        }
        if (col == this._classModeCols[4]) {
            return TIContextUpdaterHelper.updateTotalInstances((ColumnLabelAdapter)col, (boolean)isDeltaColumn, (boolean)this.isShowPercent(), (double)this._totalInst);
        }
        if (col == this._classModeCols[2]) {
            return TIContextUpdaterHelper.updateLiveInstances((ColumnLabelAdapter)col, (boolean)isDeltaColumn, (boolean)this.isShowPercent(), (double)this._activeInst);
        }
        if (col == this._classModeCols[5]) {
            return TIContextUpdaterHelper.updateTotalSize((ColumnLabelAdapter)col, (boolean)isDeltaColumn, (boolean)this.isShowPercent(), (double)this._totalSize);
        }
        if (col == this._classModeCols[3]) {
            return TIContextUpdaterHelper.updateActiveSize((ColumnLabelAdapter)col, (boolean)isDeltaColumn, (boolean)this.isShowPercent(), (double)this._activeSize);
        }
        if (col == this._classModeCols[6]) {
            return TIContextUpdaterHelper.updateAverageAge(col, isDeltaColumn, this.isShowPercent(), this._totalAge);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalInst = PerftraceUtil.getTotalInstances((EObject)this._page.getMOFObject());
            if (this._totalInst < 1) {
                this._totalInst = 1;
            }
            this._activeInst = PerftraceUtil.getActiveInstances((EObject)this._page.getMOFObject());
            if (this._activeInst < 1) {
                this._activeInst = 1;
            }
            this._totalSize = PerftraceUtil.getTotalSize((EObject)this._page.getMOFObject());
            if (this._totalSize < 1L) {
                this._totalSize = 1L;
            }
            this._activeSize = PerftraceUtil.getActiveSize((EObject)this._page.getMOFObject());
            if (this._activeSize < 1L) {
                this._activeSize = 1L;
            }
            this._collectedInst = PerftraceUtil.getTotalCollectedInstances((EObject)this._page.getMOFObject());
            if (this._collectedInst < 1) {
                this._collectedInst = 1;
            }
            if (this._totalAge < 1) {
                this._totalAge = 1;
            }
        }
    }

    protected String getColumnsPreferencesKey() {
        if (1 == this._viewMode) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "MemStatsPack12";
        }
        return String.valueOf(PREFERENCE_KEY_PREFIX) + "MemStatsClass12";
    }

    protected String getViewTypeStr() {
        return "viewoption.memory";
    }

    protected String getDefaultColumnsTemplate() {
        if (1 == this._viewMode) {
            return this.getPackageModeColumnsTemplate();
        }
        return this.getClassModeColumnsTemplate();
    }

    public String getColumnText(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        String label = "placeholder(view)";
        ColumnLabelAdapter columnAdapter = this.getColumnsLabelProvider(pos);
        if (columnAdapter != null) {
            label = this.getElementColumnText(element, columnAdapter, info.isDeltaColumn());
        }
        return label;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        Image image = null;
        ColumnLabelAdapter columnAdapter = this.getColumnsLabelProvider(pos);
        if (columnAdapter != null) {
            image = this.getElementColumnImage(element, columnAdapter, info.isDeltaColumn());
        }
        return image;
    }

    protected BaseStatisticView.StatisticSorter getViewerSorterInstance() {
        return new BaseStatisticView.StatisticSorter(this){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ColumnLabelAdapter columnAdapter = BaseMemoryStatisticView.this.getColumnsLabelProvider(this._pos);
                int ret = 0;
                if (columnAdapter != null) {
                    ret = this._sortSequence * BaseMemoryStatisticView.this.compareElements(e1, e2, columnAdapter, this._info.isDeltaColumn());
                }
                return ret;
            }
        };
    }

    protected String getClassModeColumnsTemplate() {
        return "thread.name.and.class:0:" + String.valueOf(2 | V | 4) + ":left:150," + "package.name" + ":" + 1 + ":" + String.valueOf(2 | V | 4) + ":left:120," + "class.live.inst" + ":" + 2 + ":" + String.valueOf(V | D) + ":right:80," + "class.active.size" + ":" + 3 + ":" + String.valueOf(V | D) + ":right:80," + "class.total.inst" + ":" + 4 + ":" + String.valueOf(V | D) + ":right:80," + "class.total.size" + ":" + 5 + ":" + String.valueOf(V | D) + ":right:80," + "class.avg.age" + ":" + 6 + ":" + String.valueOf(V) + ":right:80" + (this._customClassColumnTemplate == null ? "" : this._customClassColumnTemplate);
    }

    protected String getPackageModeColumnsTemplate() {
        return "package.name:0:" + String.valueOf(2 | V | 4) + ":left:120," + "package.live.inst" + ":" + 1 + ":" + String.valueOf(V | D) + ":right:80," + "package.active.size" + ":" + 2 + ":" + String.valueOf(V | D) + ":right:80," + "package.total.inst" + ":" + 3 + ":" + String.valueOf(V | D) + ":right:80," + "package.total.size" + ":" + 4 + ":" + String.valueOf(V | D) + ":right:80," + "package.avg.age" + ":" + 5 + ":" + String.valueOf(V) + ":right:80" + (this._customPackageColumnTemplate == null ? "" : this._customPackageColumnTemplate);
    }

    public Object[] getElements(Object inputElement) {
        Object[] ret = _empty;
        SimpleSearchQuery currentFilter = this.getCurrentFilter();
        if (DynamicFilter.containsDynamicFilters((SimpleSearchQuery)currentFilter)) {
            currentFilter = DynamicFilter.updateDynamicFilters((SimpleSearchQuery)currentFilter, (EObject)this._page.getMOFObject());
        }
        if (1 == this._viewMode) {
            ret = FilteringUtil.getFilteredPackages((SimpleSearchQuery)currentFilter, (List)FilteringUtil.getProcessList((EObject)this._page.getMOFObject())).toArray();
            if (ret != null && ret.length > 0) {
                LinkedList<Object> list = new LinkedList<Object>();
                int i = 0;
                while (i < ret.length) {
                    Object obj = ret[i];
                    if (obj instanceof TRCPackageImpl) {
                        TRCPackageImpl p = (TRCPackageImpl)obj;
                        if (p.getTotalInstances() > 0) {
                            list.add(p);
                        }
                    } else {
                        list.add(obj);
                    }
                    ++i;
                }
                ret = list.toArray();
            }
        } else if (this._viewMode == 0) {
            ret = FilteringUtil.getFilteredClasses((SimpleSearchQuery)currentFilter, (List)FilteringUtil.getProcessList((EObject)this._page.getMOFObject())).toArray();
            this.updateAgeInfo(ret);
            if (ret != null && ret.length > 0) {
                LinkedList<Object> list = new LinkedList<Object>();
                int i = 0;
                while (i < ret.length) {
                    Object obj = ret[i];
                    if (obj instanceof TRCClassImpl) {
                        TRCClassImpl c = (TRCClassImpl)obj;
                        if (c.getTotalInstances() > 0) {
                            list.add(c);
                        }
                    } else {
                        list.add(obj);
                    }
                    ++i;
                }
                ret = list.toArray();
            }
        }
        return ret;
    }

    public boolean hasChildren(Object element) {
        boolean ret = false;
        ICustomAnalysisView[] customViewProviders = CustomAnalysisView.getContributors();
        boolean customEngineHasChildren = false;
        boolean customEngineForHasChildren = false;
        if (customViewProviders != null) {
            int provider = 0;
            while (provider < customViewProviders.length) {
                if (!customEngineForHasChildren) {
                    customEngineForHasChildren = customViewProviders[provider].getEngineForHasChildren();
                }
                if (customEngineForHasChildren && (customEngineHasChildren = customViewProviders[provider].hasChildren(element))) break;
                ++provider;
            }
        }
        if (!customEngineForHasChildren) {
            ret = this.getChildren(element).length > 0;
        } else if (element instanceof TRCPackage) {
            ret = true;
        } else if (customEngineForHasChildren) {
            ret = customEngineHasChildren;
        }
        return ret;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] ret = _empty;
        ICustomAnalysisView[] customViewProviders = CustomAnalysisView.getContributors();
        if (parentElement instanceof TRCPackage) {
            ret = FilteringUtil.getFilteredClasses((SimpleSearchQuery)this.getCurrentFilter(), (EObject)((TRCPackage)parentElement)).toArray();
        } else if (customViewProviders != null) {
            ArrayList<Object> providerRet = new ArrayList<Object>();
            int provider = 0;
            while (provider < customViewProviders.length) {
                Object[] retArray = _empty;
                retArray = customViewProviders[provider].getChildren(parentElement);
                if (retArray != null) {
                    int i = 0;
                    while (i < retArray.length) {
                        providerRet.add(retArray[i]);
                        ++i;
                    }
                }
                ++provider;
            }
            ret = providerRet.toArray();
        }
        return ret;
    }

    void updateAgeInfo(Object[] arr) {
        this._ageMap.clear();
        this._totalAge = 1;
        EList listGC = null;
        int i = 0;
        while (i < arr.length) {
            TRCClass cls;
            if (arr[i] instanceof TRCClass && (cls = (TRCClass)arr[i]).getTotalInstances() != 0) {
                AgeInfo ageInfo = new AgeInfo();
                if (listGC == null) {
                    listGC = cls.getPackage().getProcess().getGcEvents();
                }
                if (listGC == null || listGC.size() == 0) {
                    return;
                }
                this._totalAge = listGC.size();
                EList list = cls.getObjects();
                int len = list.size();
                int j = 0;
                while (j < len) {
                    Object obj = list.get(j);
                    if (obj instanceof TRCFullTraceObject) {
                        int age = Utils.getObjAge((TRCFullTraceObject)obj, listGC);
                        ageInfo.sumAges += age;
                        ++ageInfo.objCount;
                    }
                    ++j;
                }
                this._ageMap.put(cls, ageInfo);
            }
            ++i;
        }
    }

    public void update() {
        ICustomAnalysisView[] customViewProviders = CustomAnalysisView.getContributors();
        boolean restoreExpandedItems = false;
        TreePath[] expandedItems = null;
        if (customViewProviders != null) {
            int provider = 0;
            while (provider < customViewProviders.length) {
                restoreExpandedItems = customViewProviders[provider].getRestoreExpandedItems();
                if (restoreExpandedItems) break;
                ++provider;
            }
        }
        if (restoreExpandedItems) {
            expandedItems = this.getTreeViewer().getExpandedTreePaths();
        }
        super.update();
        if (this._page instanceof MemoryAnalysisPage) {
            ((MemoryAnalysisPage)this._page).updateFilterAppliedDescription();
            this.setFilter.setText(NLS.bind((String)CommonUITraceMessages.CHOOSE_FILTER_MSG, (Object)this.getCurrentFilterName()));
        }
        if (restoreExpandedItems && expandedItems != null) {
            this.getTreeViewer().setExpandedTreePaths(expandedItems);
        }
    }

    protected void defaultActionForSelection(ISelection selection) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (this._page instanceof MemoryAnalysisPage) {
            ((MemoryAnalysisPage)this._page).showAllocDetails();
        }
    }

    protected SimpleSearchQuery getCurrentFilter() {
        if (this._page instanceof MemoryAnalysisPage) {
            return ((MemoryAnalysisPage)this._page).getCurrentFilter();
        }
        return null;
    }

    protected void createLabel(Composite viewContainer) {
        Label _label = this._toolkit.createLabel(viewContainer, null);
        _label.setBackground(viewContainer.getBackground());
        _label.setForeground(this._toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Font font = _label.getFont();
        FontData fd = font.getFontData()[0];
        font = new Font(null, new FontData(fd.getName(), fd.getHeight() * 3 / 2, fd.getStyle() | 1));
        _label.setFont(font);
        _label.setLayoutData((Object)GridUtil.createHorizontalFill());
        _label.setText(UIMessages.MEM_STATISTICS_TITLE);
        this.setFilter = new Link(viewContainer, 0x40 | this._toolkit.getOrientation());
        this.setFilter.setBackground(this._toolkit.getColors().getBackground());
        this.setFilter.setForeground(this._toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        font = this.setFilter.getFont();
        fd = font.getFontData()[0];
        font = new Font(null, new FontData(fd.getName(), fd.getHeight(), fd.getStyle() | 1));
        this.setFilter.setFont(font);
        this.setFilter.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TraceViewer viewer;
                if (BaseMemoryStatisticView.this._page != null && BaseMemoryStatisticView.this._page instanceof MemoryAnalysisPage && (viewer = ((MemoryAnalysisPage)BaseMemoryStatisticView.this._page).getTraceViewer()) != null && viewer instanceof FilterTraceViewer) {
                    FilterInformationManager fim = ((FilterTraceViewer)viewer).getFilterInformationManager();
                    FiltersEditorAction feAction = new FiltersEditorAction(fim, true);
                    feAction.run();
                }
            }
        });
        this.setFilter.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.setFilter.setText(NLS.bind((String)CommonUITraceMessages.CHOOSE_FILTER_MSG, (Object)this.getCurrentFilterName()));
    }

    public String getCurrentFilterName() {
        SimpleSearchQuery cf = this.getCurrentFilter();
        String filterAppliedName = cf != null ? cf.getName() : CommonUITraceMessages.ST_FLTAPN;
        return filterAppliedName;
    }

    public static class AgeInfo {
        public int sumAges;
        public int objCount;
    }
}

