/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.jvmti.internal.client.MethodDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ICallStackProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class CallStackViewer
extends ViewPart
implements IViewSelectionChangedListener {
    private TreeViewer _calStackCtrl;
    ICallStackProvider _provider;
    private Object _selection;
    private PartListener _partListener;
    private static final Object[] _empty = new Object[0];

    public void createPartControl(Composite parent) {
        this._calStackCtrl = new TreeViewer(parent, 66308);
        this._calStackCtrl.setContentProvider((IContentProvider)new CallStackContentProvider());
        this._calStackCtrl.setLabelProvider((IBaseLabelProvider)new CallStackLabelProvider());
        this._calStackCtrl.setInput((Object)this);
        this._calStackCtrl.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection trsel = (TreeSelection)CallStackViewer.this._calStackCtrl.getSelection();
                if (trsel == null) {
                    return;
                }
                Object element = trsel.getFirstElement();
                if (element == null) {
                    return;
                }
                if (element instanceof TRCMethodInvocation) {
                    Utils.openSource(element);
                } else if (element instanceof MethodDetails) {
                    MethodDetails md = (MethodDetails)element;
                    String pattern = String.valueOf(md.name) + Utils.fixMethodSignature(md.signature);
                    Utils.openSource(pattern);
                } else if (CallStackViewer.this._calStackCtrl.isExpandable(element)) {
                    CallStackViewer.this._calStackCtrl.expandToLevel(element, 1);
                }
            }
        });
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this.handleViewSelectionChangedEvent(UIPlugin.getDefault().getViewSelectionChangedEvent());
        this._partListener = new PartListener();
    }

    public void dispose() {
        this._partListener.dispose();
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        super.dispose();
    }

    public void setFocus() {
        if (this._calStackCtrl != null) {
            this._calStackCtrl.getControl().setFocus();
        }
    }

    void update() {
        if (this._provider != null) {
            this.update(this._provider.getCallStack());
        } else {
            this.update(null);
        }
    }

    void update(Object selection) {
        if (this._calStackCtrl == null) {
            return;
        }
        this._selection = selection;
        this._calStackCtrl.refresh();
        this._calStackCtrl.expandAll();
    }

    public String getItemText(Object obj) {
        if (obj instanceof TRCMethodInvocation) {
            return Utils.composeMethodName((TRCMethodInvocation)obj);
        }
        if (obj instanceof TRCThread) {
            return Utils.composeThreadName((TRCThread)obj, true);
        }
        if (obj instanceof TRCThreadEvent) {
            return Utils.composeEventName((TRCThreadEvent)obj);
        }
        if (obj instanceof MethodDetails) {
            return Utils.composeMethodName((MethodDetails)obj);
        }
        return obj.toString();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        this.update();
    }

    class CallStackContentProvider
    implements ITreeContentProvider {
        CallStackContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] ret = _empty;
            if (CallStackViewer.this._selection instanceof IStructuredSelection) {
                ret = ((IStructuredSelection)CallStackViewer.this._selection).toArray();
            } else if (CallStackViewer.this._selection != null) {
                ret = new Object[]{CallStackViewer.this._selection};
            }
            return ret;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] ret = _empty;
            if (parentElement instanceof TRCThread) {
                TRCThread thread = (TRCThread)parentElement;
                EList list = thread.getThreadEvents();
                if (list != null && list.size() > 0) {
                    TRCThreadEvent event = (TRCThreadEvent)list.get(list.size() - 1);
                    ret = Utils.getCallStack(event);
                } else {
                    ArrayList<TRCMethodInvocation> arrlist = new ArrayList<TRCMethodInvocation>();
                    list = thread.getInitialInvocations();
                    while (list != null && !list.isEmpty()) {
                        TRCMethodInvocation mi = (TRCMethodInvocation)list.get(list.size() - 1);
                        arrlist.add(mi);
                        list = mi.getInvokes();
                    }
                    ret = arrlist.toArray();
                }
            } else if (parentElement instanceof TRCThreadEvent) {
                ret = Utils.getCallStack((TRCThreadEvent)parentElement);
            }
            return ret;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            boolean ret = false;
            if (element instanceof TRCThread) {
                ret = true;
            } else if (element instanceof TRCThreadEvent) {
                TRCThreadEvent event = (TRCThreadEvent)element;
                EList list = event.getAnnotations();
                ret = list != null && list.size() > 0;
            }
            return ret;
        }
    }

    class CallStackLabelProvider
    extends LabelProvider {
        CallStackLabelProvider() {
        }

        public String getText(Object obj) {
            return CallStackViewer.this.getItemText(obj);
        }

        public Image getImage(Object obj) {
            return Utils.getItemImage(obj);
        }
    }

    class PartListener
    implements IPartListener2,
    IPageListener {
        IWorkbenchWindow _window;
        IWorkbenchPage _page;

        PartListener() {
            IWorkbench wb = UIPlugin.getDefault().getWorkbench();
            this._window = wb.getActiveWorkbenchWindow();
            this._page = this._window.getActivePage();
            this._window.addPageListener((IPageListener)this);
            this._page.addPartListener((IPartListener2)this);
            IViewReference[] refs = this._window.getActivePage().getViewReferences();
            int i = 0;
            while (i < refs.length) {
                IWorkbenchPart part = refs[i].getPart(false);
                if (part instanceof ICallStackProvider) {
                    CallStackViewer.this._provider = (ICallStackProvider)part;
                    CallStackViewer.this.update();
                    break;
                }
                ++i;
            }
        }

        void dispose() {
            if (this._window != null) {
                this._window.removePageListener((IPageListener)this);
                if (this._window.getActivePage() != null) {
                    this._window.getActivePage().removePartListener((IPartListener2)this);
                }
                this._window = null;
            }
            CallStackViewer.this._provider = null;
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof ICallStackProvider) {
                CallStackViewer.this._provider = (ICallStackProvider)part;
                CallStackViewer.this.update();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (CallStackViewer.this._provider == partRef.getPart(false)) {
                CallStackViewer.this._provider = null;
                CallStackViewer.this.update();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (CallStackViewer.this._provider == partRef.getPart(false)) {
                CallStackViewer.this._provider = null;
                CallStackViewer.this.update();
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            if (page == this._page) {
                this._page.removePartListener((IPartListener2)this);
                this._page = null;
            }
        }

        public void pageOpened(IWorkbenchPage page) {
        }
    }
}

