/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassBlockedStatistics;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassStatistics;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassWaitingStatistics;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorStatisticController;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorThreadStatistics;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorStatisticView
extends BaseProfilerView {
    private static final String TABLE_SECTION_THREAD_TITLE = UIMessages._MONITOR_THREADS_TAB;
    private static final String TABLE_SECTION_MON_CLASSES_TITLE = UIMessages._MONITOR_CLASSES_TAB;
    private static final String TABLE_SECTION_MON_BLOCKED_TITLE = UIMessages._MONITOR_BLOCKED_TAB;
    private static final String TABLE_SECTION_MON_WAITING_TITLE = UIMessages._MONITOR_WAITING_TAB;
    private HyadesFormToolkit _toolkit;
    private MonitorThreadStatistics _threadsStatistics;
    private MonitorClassStatistics _monitorsStatistics;
    private MonitorClassBlockedStatistics _classBlockTimeStatistics;
    private MonitorClassWaitingStatistics _classWaitTimeStatistics;
    private Form _form;
    private MonitorStatisticController monViewCtrl;

    public MonitorStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    protected Control createDataViewer(Composite parent) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this.monViewCtrl = new MonitorStatisticController();
        this.monViewCtrl.setMOFObject(this._page.getMOFObject());
        Composite monitorComposite = this._toolkit.createComposite(parent);
        monitorComposite.setLayout((Layout)new FillLayout(512));
        Composite sourceComposite = this._toolkit.createComposite(monitorComposite);
        sourceComposite.setLayout((Layout)new FillLayout(512));
        this.createThreadsSection(sourceComposite);
        this.createMonitorsSection(sourceComposite);
        this._form = this._toolkit.createForm(monitorComposite);
        this._form.setText(UIMessages._MONITOR_CLASS_NAME);
        this._form.getBody().setLayout((Layout)new FillLayout(512));
        this.monViewCtrl.setClassLabel(this._form);
        this.createClassBlockSection(this._form.getBody());
        this.createClassWaitSection(this._form.getBody());
        return monitorComposite;
    }

    protected String getViewTypeStr() {
        return "viewoption.monitors";
    }

    protected void update() {
        this.monViewCtrl.update();
    }

    private void createThreadsSection(Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TABLE_SECTION_THREAD_TITLE);
        section.marginWidth = 3;
        section.marginHeight = 3;
        section.setLayout((Layout)new GridLayout());
        this._threadsStatistics = new MonitorThreadStatistics(section, this.monViewCtrl);
        section.setClient((Control)this._threadsStatistics.getViewContainer());
    }

    private void createMonitorsSection(Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TABLE_SECTION_MON_CLASSES_TITLE);
        section.marginWidth = 3;
        section.marginHeight = 3;
        section.setLayout((Layout)new GridLayout());
        this._monitorsStatistics = new MonitorClassStatistics(section, this.monViewCtrl);
        section.setClient((Control)this._monitorsStatistics.getViewContainer());
    }

    private void createClassBlockSection(Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TABLE_SECTION_MON_BLOCKED_TITLE);
        section.marginWidth = 3;
        section.marginHeight = 3;
        section.setLayout((Layout)new GridLayout());
        this._classBlockTimeStatistics = new MonitorClassBlockedStatistics(section, this.monViewCtrl);
        section.setClient((Control)this._classBlockTimeStatistics.getViewContainer());
    }

    private void createClassWaitSection(Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TABLE_SECTION_MON_WAITING_TITLE);
        section.marginWidth = 3;
        section.marginHeight = 3;
        section.setLayout((Layout)new GridLayout());
        this._classWaitTimeStatistics = new MonitorClassWaitingStatistics(section, this.monViewCtrl);
        section.setClient((Control)this._classWaitTimeStatistics.getViewContainer());
    }
}

