/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassDetails;

public class MonitorThreadDetails {
    protected HashMap _classMap = new HashMap();
    protected TRCThread _thread;
    protected double _lastUpdateTime = 0.0;
    protected double _sleepTime;
    protected int _sleepCount;
    protected double _waitTime;
    protected int _waitCount;
    protected double _blockTime;
    protected int _blockCount;

    public MonitorThreadDetails(TRCThread thread) {
        this._thread = thread;
        this.recalculate();
    }

    public void recalculate() {
        EList events = this._thread.getThreadEvents();
        int count = events.size();
        if (count > 0) {
            TRCThreadEvent event = (TRCThreadEvent)events.get(0);
            int i = 1;
            while (i < count) {
                TRCThreadEvent next = (TRCThreadEvent)events.get(i);
                double timeSpan = Math.max(next.getTime() - event.getTime(), 0.0);
                this.updateMonitorsData(event, timeSpan);
                MonitorClassDetails monObjectClass = this.getObjectClass(event);
                if (monObjectClass != null) {
                    monObjectClass.updateMonitorsData(event, timeSpan);
                }
                event = next;
                ++i;
            }
            this._lastUpdateTime = ((TRCThreadEvent)events.get(count - 1)).getTime();
        }
    }

    private void updateMonitorsData(TRCThreadEvent event, double timeSpan) {
        if (event instanceof TRCThreadSleepingEvent) {
            this._sleepTime += timeSpan;
            ++this._sleepCount;
        } else if (event instanceof TRCThreadWaitingForObjectEvent) {
            this._waitTime += timeSpan;
            ++this._waitCount;
        } else if (event instanceof TRCThreadWaitingForLockEvent) {
            this._blockTime += timeSpan;
            ++this._blockCount;
        }
    }

    private MonitorClassDetails getObjectClass(TRCThreadEvent event) {
        TRCObject monObject = null;
        if (event instanceof TRCThreadWaitingForObjectEvent) {
            monObject = ((TRCThreadWaitingForObjectEvent)event).getObjectWaitingFor();
        } else if (event instanceof TRCThreadWaitingForLockEvent) {
            monObject = ((TRCThreadWaitingForLockEvent)event).getLockedObject();
        } else {
            return null;
        }
        if (monObject == null) {
            return null;
        }
        TRCClass monObjClass = PerftraceUtil.getClass((TRCObject)monObject);
        if (!this._classMap.containsKey(monObjClass)) {
            MonitorClassDetails classDetails = new MonitorClassDetails(monObjClass);
            this._classMap.put(monObjClass, classDetails);
            return classDetails;
        }
        return (MonitorClassDetails)this._classMap.get(monObjClass);
    }

    public TRCThread getThread() {
        return this._thread;
    }

    public int getBlockedCount() {
        return this._blockCount;
    }

    public int getWaitCount() {
        return this._waitCount;
    }

    public int getSleepCount() {
        return this._sleepCount;
    }

    public double getBlockTime() {
        return this._blockTime;
    }

    public double getSleepTime() {
        return this._sleepTime;
    }

    public double getWaitingTime() {
        return this._waitTime;
    }

    public Map getClassMap() {
        return this._classMap;
    }
}

