/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.StatisticViewColumnInfo;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class SortByColumnDlg
extends Dialog {
    private Table _list;
    private Button _ascButton;
    private Button _descButton;
    private List _columns;
    private int _sortSequence = -1;
    private StatisticViewColumnInfo _sortColumn = null;

    public SortByColumnDlg(Shell shell, Image windowImage, List columns, int sortSequence) {
        super(shell);
        SortByColumnDlg.setDefaultImage((Image)windowImage);
        this._columns = new ArrayList(columns.size());
        this._columns.addAll(columns);
        this._sortSequence = sortSequence;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UIMessages._SortByColumn);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)GridUtil.createFill());
        Label description = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        description.setLayoutData((Object)data);
        description.setText(UIMessages._SelectColumnDescr);
        Composite dataComp = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        dataComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.horizontalSpan = 3;
        dataComp.setLayoutData((Object)data);
        this._list = new Table(dataComp, 2320);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite buttonWidget = new Composite(dataComp, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 2;
        buttonWidget.setLayout((Layout)blayout);
        this._ascButton = new Button(buttonWidget, 16);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._ascButton.setLayoutData((Object)data);
        this._ascButton.setText(UIMessages._AscendingAmp);
        this._descButton = new Button(buttonWidget, 16);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._descButton.setLayoutData((Object)data);
        this._descButton.setText(UIMessages._DescendingAmp);
        this._ascButton.setEnabled(true);
        this._descButton.setEnabled(true);
        this.populateList();
        return result;
    }

    public StatisticViewColumnInfo sortColumn() {
        return this._sortColumn;
    }

    public int sortSequence() {
        return this._sortSequence;
    }

    protected void okPressed() {
        this._sortColumn = (StatisticViewColumnInfo)this._list.getSelection()[0].getData();
        this._sortSequence = this._ascButton.getSelection() ? 1 : -1;
        super.okPressed();
    }

    private void populateList() {
        this._list.removeAll();
        int idx = 0;
        while (idx < this._columns.size()) {
            StatisticViewColumnInfo ci = (StatisticViewColumnInfo)this._columns.get(idx);
            if (ci.getColumnData().visibleChooseColumns()) {
                TableItem item = new TableItem(this._list, 0);
                item.setData((Object)ci);
                if (ci.isDeltaColumn()) {
                    item.setText(String.valueOf(UIMessages._Delta) + " : " + ci.getColumnData().name());
                } else {
                    item.setText(ci.getColumnData().name());
                }
                if (ci.isSortColumn()) {
                    this._list.setSelection(new TableItem[]{item});
                }
            }
            ++idx;
        }
        if (this._list.getSelectionIndex() < 0) {
            this._list.select(0);
        }
        this._ascButton.setSelection(this.sortSequence() > 0);
        this._descButton.setSelection(this.sortSequence() < 0);
    }
}

