/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadAnalysisViewer;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadStatesView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadAnalysisPage
extends TraceViewerPage {
    public static final int TAB_THREAD_STATISTIC = 0;
    public static final int TAB_MONITOR_STATISTIC = 1;
    public static final int TAB_THREAD_STATES = 2;
    public static final int TAB_NUM = 3;
    CTabFolder _tabFolder;
    BaseProfilerView[] _views;

    public ThreadAnalysisPage(EObject mofObject, TraceViewer viewer) {
        super(mofObject, viewer);
    }

    public void refreshPage() {
        BaseProfilerView view = this._views[this._tabFolder.getSelectionIndex()];
        view.update();
        this.updateButtons();
    }

    public void selectionChanged() {
    }

    public void update(boolean newPage) {
        this.refreshPage();
    }

    public void createControl(Composite parent) {
        int selectedTab = Utils.loadIntOption("viewoption.threads.tab", 0, 0, 2);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this._tabFolder = new CTabFolder(parent, 0x800400);
        this._tabFolder.setLayoutData((Object)gd);
        this._tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BaseProfilerView view = ThreadAnalysisPage.this._views[ThreadAnalysisPage.this._tabFolder.getSelectionIndex()];
                view.update();
                view.updateModelSelection();
                ThreadAnalysisPage.this.updateButtons();
            }
        });
        this._views = new BaseProfilerView[3];
        CTabItem tabItem = new CTabItem(this._tabFolder, 0);
        tabItem.setText(UIMessages.THREAD_STATISTIC_TITLE);
        ThreadStatisticView view0 = new ThreadStatisticView((Composite)this._tabFolder, this);
        this._views[0] = view0;
        tabItem.setControl(this._views[0].getControl());
        tabItem = new CTabItem(this._tabFolder, 0);
        tabItem.setText(UIMessages.MONITOR_STATISTIC_TITLE);
        MonitorStatisticView view1 = new MonitorStatisticView((Composite)this._tabFolder, this);
        this._views[1] = view1;
        tabItem.setControl(this._views[1].getControl());
        tabItem = new CTabItem(this._tabFolder, 0);
        tabItem.setText(UIMessages.THREAD_STATES_TITLE);
        ThreadStatesView view2 = new ThreadStatesView((Composite)this._tabFolder, this);
        this._views[2] = view2;
        tabItem.setControl(this._views[2].getControl());
        this._tabFolder.setSelection(selectedTab);
        this.setContextMenu((Control)view0.getTree(), (ISelectionProvider)view0.getTreeViewer());
    }

    public void dispose() {
        int selectedTab = this._tabFolder.getSelectionIndex();
        Utils.saveIntOption("viewoption.threads.tab", selectedTab);
        int i = 0;
        while (i < this._views.length) {
            this._views[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public Control getControl() {
        return this._tabFolder;
    }

    public void setFocus() {
        this._views[this._tabFolder.getSelectionIndex()].getControl().setFocus();
    }

    public int getViewTab() {
        return this._tabFolder.getSelectionIndex();
    }

    public void showViewTab(int tab) {
        if (tab != 0 && tab != 0) {
            return;
        }
        this._tabFolder.setSelection(tab);
        this.updateButtons();
    }

    public void updateButtons() {
        if (this._viewer instanceof ThreadAnalysisViewer) {
            ((ThreadAnalysisViewer)this._viewer).updateButtons();
        }
    }

    public BaseProfilerView getCurrentView() {
        BaseProfilerView view = this._views[this._tabFolder.getSelectionIndex()];
        return view;
    }

    public boolean isEmpty() {
        return false;
    }

    public void fillContextMenu(IMenuManager menu) {
        BaseProfilerView view = this._views[this._tabFolder.getSelectionIndex()];
        view.menuAboutToShow(menu);
    }
}

