/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.Arrays;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class ThreadFilterDialog
extends TitleAreaDialog {
    private CheckboxTableViewer viewer;
    private Object[] threads;
    private boolean[] filter;

    public ThreadFilterDialog(Shell parentShell, Object[] threads, boolean[] filter) {
        super(parentShell);
        this.threads = threads;
        if (filter != null) {
            this.filter = (boolean[])filter.clone();
        }
    }

    public static boolean getThreadFilter(Shell parentShell, Object[] threads, boolean[] filter) {
        ThreadFilterDialog dlg = new ThreadFilterDialog(parentShell, threads, filter);
        if (dlg.open() != 0) {
            return false;
        }
        boolean[] f = dlg.getFilter();
        if (Arrays.equals(f, filter)) {
            return false;
        }
        int i = f.length - 1;
        while (i >= 0) {
            filter[i] = f[i];
            --i;
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setBackground(parent.getBackground());
        this.createColumns(table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setComparator((ViewerComparator)new ThreadComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput(new Object());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object o = event.getElement();
                int i = ThreadFilterDialog.this.threads.length - 1;
                while (i >= 0) {
                    if (ThreadFilterDialog.this.threads[i].equals(o)) {
                        ((ThreadFilterDialog)ThreadFilterDialog.this).filter[i] = event.getChecked();
                    }
                    --i;
                }
            }
        });
        if (this.filter != null) {
            int i = 0;
            while (i < this.filter.length) {
                this.viewer.setChecked(this.threads[i], this.filter[i]);
                ++i;
            }
        }
        this.setMessage(UIMessages._THREADS_FILTER_DESC);
        this.setTitle(UIMessages._THREADS_FILTER);
        ThreadFilterDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        this.setTitleImage(PDPluginImages.DESC_IMG_UI_WZ_EDITPROFSET.createImage());
        return composite;
    }

    private void createColumns(Table table) {
        table.setHeaderVisible(true);
        String[] headers = new String[]{"", UIMessages._THREAD_ID, UIMessages._THREAD_NAME};
        int[] width = new int[]{20, 80, 400};
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
            tc.setWidth(width[i]);
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UIMessages._EDIT_PROFILING_OPTIONS);
    }

    public boolean[] getFilter() {
        return this.filter;
    }

    class ThreadComparator
    extends ViewerComparator {
        ThreadComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int id2;
            int id1 = ((TRCThread)e1).getId();
            if (id1 == (id2 = ((TRCThread)e2).getId())) {
                return 0;
            }
            return id1 < id2 ? -1 : 1;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            return ThreadFilterDialog.this.threads;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TRCThread t = (TRCThread)element;
            if (columnIndex == 1) {
                return String.valueOf(t.getId());
            }
            if (columnIndex == 2) {
                return t.getName();
            }
            return "";
        }
    }
}

