/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;

public class ThreadLegend
extends TitleAreaDialog {
    public static final String[] stateNames = new String[]{UIMessages._Unknown, UIMessages._Running, UIMessages._Sleeping, UIMessages._Waiting, UIMessages._Blocked, UIMessages._Deadlocked, UIMessages._Stopped};
    public static final String[] interactionNames = new String[]{UIMessages._START_THREAD, UIMessages._JOIN_TERMINATE, UIMessages._WAIT_NOTIFY, UIMessages._INTERRUPT, UIMessages._RELEASE_ACQUIRE};
    public static final int[] interactionColors = new int[]{25, 26, 36, 35, 37};
    protected TraceColorScheme colors = new TraceColorScheme();

    public static void open(Shell parent) {
        new ThreadLegend(parent).open();
    }

    public ThreadLegend(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dlgArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.createThreadStatesGroup(composite);
        this.createThreadInteractionsGroup(composite);
        this.setMessage(UIMessages._LEGEND);
        this.setTitle(UIMessages.THREAD_STATES_TITLE);
        ThreadLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        this.setTitleImage(PDPluginImages.DESC_IMG_UI_WZ_EDITPROFSET.createImage());
        return composite;
    }

    private void createThreadStatesGroup(Composite composite) {
        Group gs = new Group(composite, 0);
        gs.setText(UIMessages._THREAD_STATES);
        GridData gd = new GridData(4, 4, true, true);
        gs.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        int i = 0;
        while (i < 7) {
            Bar bar = new Bar((Composite)gs, i);
            gd = new GridData();
            gd.widthHint = 40;
            gd.heightHint = 20;
            gd.verticalIndent = 8;
            bar.setLayoutData(gd);
            Label name = new Label((Composite)gs, 0);
            name.setText(stateNames[i]);
            gd = new GridData();
            gd.horizontalIndent = 10;
            gd.verticalIndent = 8;
            name.setLayoutData((Object)gd);
            ++i;
        }
    }

    private void createThreadInteractionsGroup(Composite composite) {
        Group g = new Group(composite, 0);
        g.setText(UIMessages._THREAD_INTERACTIONS);
        GridData gd = new GridData(4, 4, true, true);
        g.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        g.setLayout((Layout)layout);
        int i = 0;
        while (i < 5) {
            Arrow a = new Arrow((Composite)g, interactionColors[i]);
            gd = new GridData();
            gd.widthHint = 10;
            gd.heightHint = 20;
            gd.verticalIndent = 8;
            a.setLayoutData(gd);
            Label name = new Label((Composite)g, 0);
            name.setText(interactionNames[i]);
            gd = new GridData();
            gd.horizontalIndent = 4;
            gd.verticalIndent = 8;
            name.setLayoutData((Object)gd);
            ++i;
        }
        Mark m = new Mark((Composite)g, 37);
        gd = new GridData();
        gd.widthHint = 10;
        gd.heightHint = 20;
        gd.verticalIndent = 8;
        m.setLayoutData(gd);
        Label name = new Label((Composite)g, 0);
        name.setText(UIMessages._WAIT_TIMEOUT_EXCEED);
        gd = new GridData();
        gd.horizontalIndent = 4;
        gd.verticalIndent = 8;
        name.setLayoutData((Object)gd);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UIMessages._WINDOW_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    class Arrow
    extends Canvas {
        public static final int HEIGHT = 12;
        public static final int DX = 3;
        private Color color;

        public Arrow(Composite parent, int colorIdx) {
            super(parent, 0);
            this.color = ThreadLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Arrow.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            int y1;
            int y0;
            Rectangle r = this.getClientArea();
            gc.setForeground(this.color);
            if (r.height > 12) {
                y0 = (r.height - 12) / 2;
                y1 = y0 + 12;
            } else {
                y0 = 0;
                y1 = r.height;
            }
            gc.drawLine(3, y0, 3, y1);
            gc.drawLine(0, y0 + 3, 3, y0);
            gc.drawLine(6, y0 + 3, 3, y0);
        }
    }

    class Bar
    extends Canvas {
        private int colorIdx;
        private Color color;

        public Bar(Composite parent, int colorIdx) {
            super(parent, 0);
            this.colorIdx = colorIdx;
            this.color = ThreadLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Bar.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.color);
            gc.fillRectangle(r);
            int my = r.height / 2;
            if (4 == this.colorIdx || 3 == this.colorIdx) {
                int s = gc.getLineStyle();
                int w = gc.getLineWidth();
                gc.setLineStyle(3);
                gc.setLineWidth(2);
                gc.drawLine(0, my, r.width - 1, my);
                gc.setLineStyle(s);
                gc.setLineWidth(w);
            } else if (5 == this.colorIdx || 6 == this.colorIdx) {
                int w = gc.getLineWidth();
                gc.setLineWidth(2);
                gc.drawLine(0, my, r.width - 1, my);
                gc.setLineWidth(w);
            }
            gc.setForeground(ThreadLegend.this.colors.getColor(25));
            gc.drawRectangle(0, 0, r.width - 1, r.height - 1);
        }
    }

    class Mark
    extends Canvas {
        public static final int DX = 3;
        private Color color;

        public Mark(Composite parent, int colorIdx) {
            super(parent, 0);
            this.color = ThreadLegend.this.colors.getColor(colorIdx);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Mark.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.color);
            int y = (r.height - 3) / 2;
            int[] nArray = new int[6];
            nArray[1] = y;
            nArray[2] = 3;
            nArray[3] = y + 3;
            nArray[4] = 6;
            nArray[5] = y;
            int[] c = nArray;
            gc.fillPolygon(c);
        }
    }
}

