/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.OpenCallStackViewAction;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadFilterDialog;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadLegend;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ITimeDataProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadStatesCtrl;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadsTipHandler;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeScaleCtrl;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadStatesView
extends BaseProfilerView
implements ITimeDataProvider,
SelectionListener {
    private double _minTimeInterval;
    private double _selectedTime;
    private double _beginTime;
    private double _endTime;
    private double _time0;
    private double _time1;
    private double _timeMinTime;
    private double _timeMaxTime;
    private boolean _timeRangeFixed;
    private int _nameWidth;
    private Composite _dataViewer;
    private ThreadStatesCtrl _stateCtrl;
    private TimeScaleCtrl _timeScaleCtrl;
    private ThreadsTipHandler _threadTip;
    private TraceColorScheme _colors;

    protected ThreadStatesView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resizeControls();
    }

    public void update() {
        if (this._stateCtrl != null) {
            this.refreshData();
            this._stateCtrl.redraw();
            this._timeScaleCtrl.redraw();
        }
    }

    public void selectionChanged() {
    }

    protected String getViewTypeStr() {
        return "viewoption.threads";
    }

    int getMarginWidth(int idx) {
        return 0;
    }

    int getMarginHeight(int idx) {
        return 0;
    }

    void loadOptions() {
        this._minTimeInterval = 1.0E-6;
        this._selectedTime = -1.0;
        this._nameWidth = Utils.loadIntOption(this.getPreferenceString("namewidth"), 96, 6, 1000);
    }

    void saveOptions() {
        Utils.saveIntOption(this.getPreferenceString("namewidth"), this._nameWidth);
    }

    protected Control createDataViewer(Composite parent) {
        this.loadOptions();
        this._colors = new TraceColorScheme();
        this._dataViewer = new Composite(parent, 0);
        this._dataViewer.setLayoutData((Object)GridUtil.createFill());
        this._timeScaleCtrl = new TimeScaleCtrl(this._dataViewer, this._colors);
        this._timeScaleCtrl.setTimeProvider(this);
        this._timeScaleCtrl.setLayoutData(GridUtil.createFill());
        this._stateCtrl = new ThreadStatesCtrl(this._dataViewer, this._colors);
        this._stateCtrl.setTimeProvider(this);
        this._stateCtrl.addSelectionListener(this);
        this._stateCtrl.setLayoutData(GridUtil.createFill());
        this._dataViewer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ThreadStatesView.this.resizeControls();
            }
        });
        this.resizeControls();
        this._dataViewer.update();
        this._threadTip = new ThreadsTipHandler(parent.getShell());
        this._threadTip.activateHoverHelp((Control)this._stateCtrl);
        return this._dataViewer;
    }

    public void dispose() {
        this.saveOptions();
        this._stateCtrl.dispose();
        this._dataViewer.dispose();
        this._colors.dispose();
        super.dispose();
    }

    public void resizeControls() {
        Rectangle r = this._dataViewer.getClientArea();
        if (r.isEmpty()) {
            return;
        }
        int legendHeight = 4;
        int timeScaleHeight = 22;
        this._timeScaleCtrl.setBounds(r.x, r.y + legendHeight, r.width, timeScaleHeight);
        this._stateCtrl.setBounds(r.x, r.y + legendHeight + timeScaleHeight, r.width, r.height - legendHeight - timeScaleHeight);
        int width = r.width;
        if (this._nameWidth > width - 6) {
            this._nameWidth = width - 6;
        }
        if (this._nameWidth < 6) {
            this._nameWidth = 6;
        }
    }

    void setTimeRange(Object[] threads) {
        this._endTime = 0.0;
        this._beginTime = -1.0;
        int i = 0;
        while (i < threads.length) {
            EList list;
            int len;
            TRCThread thread = (TRCThread)threads[i];
            double lastEventTime = thread.getStopTime();
            if (lastEventTime > thread.getStartTime() && lastEventTime > this._endTime) {
                this._endTime = lastEventTime;
            }
            if ((len = (list = thread.getThreadEvents()).size()) > 0) {
                TRCThreadEvent event = (TRCThreadEvent)list.get(list.size() - 1);
                lastEventTime = event.getTime();
                if (lastEventTime > this._endTime) {
                    this._endTime = lastEventTime;
                }
                event = (TRCThreadEvent)list.get(0);
                if (this._beginTime < 0.0 || this._beginTime > event.getTime()) {
                    this._beginTime = event.getTime();
                }
            }
            ++i;
        }
        this._endTime += 0.1;
        if (this._beginTime < 0.0) {
            this._beginTime = 0.0;
        }
    }

    void setTimeBounds() {
        this._timeMinTime = this._beginTime - (this._endTime - this._beginTime) * 0.05;
        if (this._timeMinTime < 0.0) {
            this._timeMinTime = 0.0;
        }
        this._timeMaxTime = this._endTime;
        this._timeMinTime = Math.floor(this._timeMinTime);
        this._timeMaxTime = Math.ceil(this._timeMaxTime);
        if (!this._timeRangeFixed) {
            this._time0 = this._timeMinTime;
            this._time1 = this._timeMaxTime;
        }
    }

    void refreshData() {
        Object[] threads = PerftraceUtil.getAllThreads((EObject)this._page.getMOFObject(), (boolean)false);
        if (threads == null) {
            threads = new TRCThread[]{};
        }
        this.setTimeRange(threads);
        this.setTimeBounds();
        if (this._selectedTime < 0.0 || this._selectedTime > this._endTime) {
            this._selectedTime = this._endTime;
        }
        this._stateCtrl.refreshData(threads);
    }

    public void setFocus() {
        if (this._stateCtrl != null) {
            this._stateCtrl.setFocus();
        }
    }

    public TRCThread getSelectedThread() {
        return this._stateCtrl.getSelectedThread();
    }

    public ISelection getSelection() {
        return this._stateCtrl.getSelection();
    }

    public double getTime0() {
        return this._time0;
    }

    public double getTime1() {
        return this._time1;
    }

    public double getMinTimeInterval() {
        return this._minTimeInterval;
    }

    public int getNameSpace() {
        return this._nameWidth;
    }

    public void setNameSpace(int width) {
        this._nameWidth = width;
        width = this._stateCtrl.getClientArea().width;
        if (this._nameWidth > width - 6) {
            this._nameWidth = width - 6;
        }
        if (this._nameWidth < 6) {
            this._nameWidth = 6;
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    public int getTimeSpace() {
        int w = this._stateCtrl.getClientArea().width;
        return w - this._nameWidth;
    }

    public double getSelectedTime() {
        return this._selectedTime;
    }

    public double getBeginTime() {
        return this._beginTime;
    }

    public double getEndTime() {
        return this._endTime;
    }

    public double getMaxTime() {
        return this._timeMaxTime;
    }

    public double getMinTime() {
        return this._timeMinTime;
    }

    public void setStartFinishTime(double time0, double time1) {
        this._time0 = time0;
        if (this._time0 < this._timeMinTime) {
            this._time0 = this._timeMinTime;
        }
        this._time1 = time1;
        if (this._time1 - this._time0 < this._minTimeInterval) {
            this._time1 = this._time0 + this._minTimeInterval;
        }
        if (this._time1 > this._timeMaxTime) {
            this._time1 = this._timeMaxTime;
        }
        this._timeRangeFixed = true;
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    public void resetStartFinishTime() {
        this._timeRangeFixed = false;
        this._time0 = this._timeMinTime;
        this._time1 = this._timeMaxTime;
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    public void setSelectedTime(double time, boolean ensureVisible) {
        this._selectedTime = time;
        if (this._selectedTime > this._endTime) {
            this._selectedTime = this._endTime;
        }
        if (this._selectedTime < this._beginTime) {
            this._selectedTime = this._beginTime;
        }
        if (ensureVisible) {
            double timeSpace = (this._time1 - this._time0) * 0.02;
            double timeMid = (this._time1 - this._time0) * 0.1;
            if (this._selectedTime < this._time0 + timeSpace) {
                double dt = this._time0 - this._selectedTime + timeMid;
                this._time0 -= dt;
                this._time1 -= dt;
            } else if (this._selectedTime > this._time1 - timeSpace) {
                double dt = this._selectedTime - this._time1 + timeMid;
                this._time0 += dt;
                this._time1 += dt;
            }
            if (this._time0 < 0.0) {
                this._time1 -= this._time0;
                this._time0 = 0.0;
            } else if (this._time1 > this._timeMaxTime) {
                this._time0 -= this._time1 - this._timeMaxTime;
                this._time1 = this._timeMaxTime;
            }
        }
        this._stateCtrl.adjustScrolls();
        this._stateCtrl.redraw();
        this._timeScaleCtrl.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        new OpenCallStackViewAction().openView(false);
        this.updateModelSelection();
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateModelSelection();
    }

    public void selectNextEvent() {
        this._stateCtrl.selectNextEvent();
    }

    public void selectPrevEvent() {
        this._stateCtrl.selectPrevEvent();
    }

    public void selectNextThread() {
        this._stateCtrl.selectNextThread();
    }

    public void selectPrevThread() {
        this._stateCtrl.selectPrevThread();
    }

    public void groupThreads(boolean on) {
        this._stateCtrl.groupThreads(on);
    }

    public void filterThreads() {
        if (this._dataViewer == null || this._dataViewer.isDisposed()) {
            return;
        }
        if (ThreadFilterDialog.getThreadFilter(this._dataViewer.getShell(), this._stateCtrl.getThreads(), this._stateCtrl.getThreadFilter())) {
            this._stateCtrl.refreshData();
        }
    }

    public void showLegend() {
        if (this._dataViewer == null || this._dataViewer.isDisposed()) {
            return;
        }
        ThreadLegend.open(this._dataViewer.getShell());
    }

    public void toggleThreadsInteractionDrawing() {
        this._stateCtrl.toggleThreadsInteractionDrawing();
    }

    public void setThreadJoinDrawing(boolean on) {
        this._stateCtrl.setThreadJoinDrawing(on);
    }

    public void setThreadWaitDrawing(boolean on) {
        this._stateCtrl.setThreadWaitDrawing(on);
    }

    public void setThreadReleaseDrawing(boolean on) {
        this._stateCtrl.setThreadReleaseDrawing(on);
    }

    public boolean getThreadInteractionDrawing() {
        return this._stateCtrl.getThreadsInteractionDrawing();
    }

    public boolean getThreadJoinDrawing() {
        return this._stateCtrl.getThreadJoinDrawing();
    }

    public boolean getThreadWaitDrawing() {
        return this._stateCtrl.getThreadWaitDrawing();
    }

    public boolean getThreadReleaseDrawing() {
        return this._stateCtrl.getThreadReleaseDrawing();
    }

    protected void select(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof ThreadDetails) {
            obj = ((ThreadDetails)obj).getThread();
        }
        boolean cfr_ignored_0 = obj instanceof TRCThread;
    }

    public void zoomIn() {
        this._stateCtrl.zoomIn();
    }

    public void zoomOut() {
        this._stateCtrl.zoomOut();
    }
}

