/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.OpenCallStackViewAction;
import org.eclipse.tptp.trace.jvmti.internal.client.views.StatisticViewColumnInfo;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadBlockCountColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadBlockedTimeColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadClassNameColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadDeadlockCountColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadDeadlockedTimeColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadNameLabelAdapter;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadRunningTimeColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadStateColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.views.columnlabels.ThreadWaitingTimeColumnLabel;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.PlainSelection;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadStatisticView
extends BaseStatisticView {
    static final int COL_THREAD_NAME = 0;
    static final int COL_CLASS_NAME = 1;
    static final int COL_STATE = 2;
    static final int COL_RUN_TIME = 3;
    static final int COL_WAIT_TIME = 4;
    static final int COL_BLOCK_TIME = 5;
    static final int COL_BLOCK_COUNT = 6;
    static final int COL_DEADLOCK_TIME = 7;
    static final int COL_DEADLOCK_COUNT = 8;
    public static String PREFERENCE_KEY_PREFIX = "org.eclipse.hyades.trace.views.statistic.";
    protected ColumnLabelAdapter[] _columns;
    protected TraceColorScheme _colors = new TraceColorScheme();

    public ThreadStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this.createColumnsLabelProviders();
    }

    public void dispose() {
        this._colors.dispose();
        super.dispose();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".stvw0001";
    }

    public void createColumnsLabelProviders() {
        this._columns = new ColumnLabelAdapter[]{new ThreadNameLabelAdapter(), new ThreadClassNameColumnLabel(), new ThreadStateColumnLabel(), new ThreadRunningTimeColumnLabel(), new ThreadWaitingTimeColumnLabel(), new ThreadBlockedTimeColumnLabel(), new ThreadBlockCountColumnLabel(), new ThreadDeadlockedTimeColumnLabel(), new ThreadDeadlockCountColumnLabel()};
    }

    protected Object[] getChildren(Object parentElement) {
        return null;
    }

    protected boolean hasChildren(Object element) {
        return false;
    }

    protected Image getColumnImage(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        if (info.isDeltaColumn()) {
            return null;
        }
        if (pos >= 0 && pos < this._columns.length) {
            return this.getElementColumnImage(element, this._columns[pos], info.isDeltaColumn());
        }
        return null;
    }

    protected String getColumnText(Object element, int columnIndex) {
        StatisticViewColumnInfo info = StatisticViewColumnInfo.getStatisticTableColumnInfo(this.getTree().getColumn(columnIndex));
        int pos = info.getColumnData().getInitalPos();
        if (pos >= 0 && pos < this._columns.length) {
            return this.getElementColumnText(element, this._columns[pos], info.isDeltaColumn());
        }
        return "";
    }

    protected Object[] getElements(Object inputElement) {
        Object[] threads = PerftraceUtil.getAllThreads((EObject)this._page.getMOFObject(), (boolean)false);
        Object[] elements = new Object[threads.length];
        int i = 0;
        while (i < threads.length) {
            elements[i] = new ThreadDetails((TRCThread)threads[i]);
            ++i;
        }
        return elements;
    }

    public String getDefaultColumnsTemplate() {
        return "thread.name:0:" + String.valueOf(7) + ":left:120," + "thread.name.and.class" + ":" + 1 + ":" + String.valueOf(7) + ":left:150," + "thread.state" + ":" + 2 + ":" + String.valueOf(1) + ":right:80," + "thread.running.time" + ":" + 3 + ":" + String.valueOf(1) + ":right:120," + "thread.waiting.time" + ":" + 4 + ":" + String.valueOf(1) + ":right:120," + "thread.blocked.time" + ":" + 5 + ":" + String.valueOf(1) + ":right:120," + "thread.block.count" + ":" + 6 + ":" + String.valueOf(1) + ":right:80," + "thread.deadlocked.time" + ":" + 7 + ":" + String.valueOf(1) + ":right:80," + "thread.deadlock.count" + ":" + 8 + ":" + String.valueOf(1) + ":right:80";
    }

    protected BaseStatisticView.StatisticSorter getViewerSorterInstance() {
        return new ThreadStatisticSorter();
    }

    public String getColumnsPreferencesKey() {
        return String.valueOf(PREFERENCE_KEY_PREFIX) + "ThreadStats4";
    }

    public String getViewTypeStr() {
        return "viewoption.threads";
    }

    protected void showPercentUpdate() {
    }

    public void update() {
        int i = 0;
        while (i < this._columns.length) {
            this._columns[i].resetMap();
            ++i;
        }
        super.update();
    }

    protected Tree createTree(Composite parent, int options) {
        Tree tree = super.createTree(parent, options);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ThreadStatisticView.this.drawItem(event);
            }
        };
        tree.addListener(40, listener);
        return tree;
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new ThreadStatisticTreeViewer(tree);
    }

    public ISelection getSelection() {
        TRCThread thread = null;
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof TRCThread) {
                thread = (TRCThread)sel;
            }
            if (sel instanceof ThreadDetails) {
                thread = ((ThreadDetails)sel).getThread();
            }
        }
        return new PlainSelection(thread);
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.getSeparator());
        this.resetChooseColumnsAction();
        menu.add((IAction)this.getChooseColumnsAction());
        menu.add((IAction)this.getSortByColumnAction());
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget instanceof TableColumn) {
            this.expandFirstElement();
            this.handleSelectionEvent();
        }
    }

    protected void resetColumns(ArrayList list) {
        super.resetColumns(list);
        this.expandFirstElement();
    }

    protected void select(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof ThreadDetails) {
            obj = ((ThreadDetails)obj).getThread();
        } else if (obj instanceof TRCThreadEvent) {
            obj = ((TRCThreadEvent)obj).getThread();
        }
        Tree tree = this.getTree();
        TreeItem[] items = tree.getItems();
        TreeItem item = null;
        int j = 0;
        while (j < items.length) {
            item = items[j];
            if (item != null && !item.isDisposed()) {
                Object data = item.getData();
                if (data instanceof ThreadDetails) {
                    data = ((ThreadDetails)data).getThread();
                }
                if (data == obj) {
                    tree.setSelection(item);
                    return;
                }
            }
            ++j;
        }
    }

    protected int updateTableGetColumnNumber() {
        return 2;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        new OpenCallStackViewAction().openView(false);
    }

    public void drawItem(Event event) {
        boolean selected;
        Tree tree = this.getTree();
        Display display = event.display;
        boolean bl = selected = (event.detail & 2) != 0;
        if (selected) {
            GC gc = event.gc;
            gc.setAdvanced(true);
            if (gc.getAdvanced()) {
                int columnCount = tree.getColumnCount();
                if (event.index == columnCount - 1 || columnCount == 0) {
                    Rectangle area = tree.getClientArea();
                    int width = area.x + area.width - event.x;
                    if (width > 0) {
                        Region region = new Region();
                        gc.getClipping(region);
                        region.add(event.x, event.y, width, event.height);
                        gc.setClipping(region);
                        region.dispose();
                    }
                }
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setForeground(display.getSystemColor(26));
                gc.fillRectangle(0, event.y, 100000, event.height);
                gc.setForeground(foreground);
                gc.setBackground(background);
            }
        }
        ThreadDetails thread = (ThreadDetails)event.item.getData();
        int state = 0;
        if (event.index == 2) {
            state = thread.getState();
        } else if (event.index == 6 && thread.getBlockCount() > 0) {
            state = 4;
        } else if (event.index == 8 && thread.getDeadlockCount() > 0) {
            state = 5;
        }
        if (state != 0) {
            if (selected) {
                event.detail &= 0xFFFFFFFD;
            }
            GC gc = event.gc;
            Color foreground = gc.getForeground();
            Color background = gc.getBackground();
            int c2 = selected ? 15 : 1;
            Color sysBack = this._colors.getColor(state);
            Color sysFore = display.getSystemColor(c2);
            Color fore = Utils.mixColors((Device)display, sysBack, sysFore, 1, 4);
            Color back = Utils.mixColors((Device)display, sysBack, sysFore, 4, 1);
            gc.setAdvanced(true);
            if (gc.getAdvanced()) {
                gc.setAlpha(180);
            }
            gc.setBackground(back);
            gc.setForeground(fore);
            gc.fillGradientRectangle(event.x, event.y, event.width, event.height, false);
            gc.setForeground(foreground);
            gc.setBackground(background);
            back.dispose();
            fore.dispose();
        }
    }

    public class ThreadStatisticSorter
    extends BaseStatisticView.StatisticSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this._pos >= 0 && this._pos < ThreadStatisticView.this._columns.length) {
                return this._sortSequence * ThreadStatisticView.this.compareElements(e1, e2, ThreadStatisticView.this._columns[this._pos], this._info.isDeltaColumn());
            }
            return 0;
        }
    }

    class ThreadStatisticTreeViewer
    extends TreeViewer {
        public ThreadStatisticTreeViewer(Composite parent) {
            super(parent);
        }

        public ThreadStatisticTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }

        public ISelection getSelection() {
            Object obj;
            ISelection sel = super.getSelection();
            if (sel != null && !sel.isEmpty() && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof ThreadDetails) {
                return new StructuredSelection((Object)((ThreadDetails)obj).getThread());
            }
            return sel;
        }
    }
}

