/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.GroupItem;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Item;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadItem;

class ItemData {
    public Object[] _items = new Object[0];
    private Object[] _threads = new Object[0];
    private boolean[] threadFilter = new boolean[0];
    private Map _groupTable = new HashMap();
    private boolean _flatList = false;

    ItemData() {
    }

    protected void groupThreads(boolean on) {
        if (this._flatList == on) {
            this._flatList = !on;
            this.updateItems();
        }
    }

    void clearGroups() {
        for (GroupItem group : this._groupTable.values()) {
            group._threads.clear();
        }
    }

    void deleteEmptyGroups() {
        Iterator it = this._groupTable.values().iterator();
        while (it.hasNext()) {
            GroupItem group = (GroupItem)it.next();
            if (group._threads.size() != 0) continue;
            it.remove();
        }
    }

    ThreadItem findThreadItem(TRCThread thread) {
        if (thread == null) {
            return null;
        }
        int threadId = thread.getId();
        ThreadItem threadItem = null;
        int i = 0;
        while (i < this._items.length) {
            Object item = this._items[i];
            if (item instanceof ThreadItem) {
                ThreadItem ti = (ThreadItem)item;
                if (ti._thread.getId() == threadId) {
                    threadItem = ti;
                    break;
                }
            }
            ++i;
        }
        return threadItem;
    }

    public void updateItems() {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (GroupItem group : this._groupTable.values()) {
            if (!this._flatList) {
                itemList.add(group);
            }
            if (!this._flatList && !group._expanded) continue;
            for (TRCThread thread : group._threads) {
                ThreadItem threadItem = this.findThreadItem(thread);
                if (threadItem == null) {
                    threadItem = new ThreadItem(thread);
                }
                itemList.add(threadItem);
            }
        }
        this._items = itemList.toArray();
    }

    public int expandItem(int idx, boolean expand) {
        if (idx < 0 || idx >= this._items.length) {
            return 0;
        }
        int ret = 0;
        Item item = (Item)this._items[idx];
        if (item._hasChildren && !item._expanded) {
            item._expanded = expand;
            ret = this._items.length;
            this.updateItems();
            ret = this._items.length - ret;
        }
        return ret;
    }

    public void refreshData(Object[] threads) {
        if (threads == null || threads.length == 0) {
            this.threadFilter = null;
        } else if (this.threadFilter == null || threads.length != this.threadFilter.length) {
            this.threadFilter = new boolean[threads.length];
            Arrays.fill(this.threadFilter, true);
        }
        this._threads = threads;
        this.refreshData();
    }

    public void refreshData() {
        this.clearGroups();
        String undef = UIMessages._UNDEFINED_GROUP;
        ArrayList<GroupItem> groupList = new ArrayList<GroupItem>();
        int i = 0;
        while (i < this._threads.length) {
            TRCThread thread = (TRCThread)this._threads[i];
            if (this.threadFilter[i]) {
                GroupItem group;
                String groupName = thread.getGroupName();
                if (groupName == null) {
                    groupName = undef;
                }
                if ((group = (GroupItem)this._groupTable.get(groupName)) == null) {
                    group = new GroupItem(NLS.bind((String)UIMessages._THREAD_GROUP_LABEL, (Object)groupName));
                    group._expanded = !groupName.equalsIgnoreCase("system") && !groupName.equalsIgnoreCase(undef);
                    this._groupTable.put(groupName, group);
                    groupList.add(group);
                }
                group.add(thread);
            }
            ++i;
        }
        this.deleteEmptyGroups();
        this.updateItems();
    }

    public Object[] getThreads() {
        return this._threads;
    }

    public boolean[] getThreadFilter() {
        return this.threadFilter;
    }
}

