/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorCallDetails;

public class MonitorCallStackToolTipCreater {
    public static void createStackTraceToolTip(final Tree tree) {
        tree.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TABLEITEM");
                        tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        tree.notifyListeners(13, e);
                        shell.dispose();
                        tree.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener treeListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Point coords = new Point(event.x, event.y);
                        TreeItem item = tree.getItem(coords);
                        if (item == null) break;
                        tree.getColumnCount();
                        Rectangle rect = item.getBounds(0);
                        if (!rect.contains(coords)) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(tree.getShell(), 540676);
                        this.tip.setBackground(tree.getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(tree.getDisplay().getSystemColor(28));
                        this.label.setBackground(tree.getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(((MonitorCallDetails)item.getData()).getStackText());
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Point pt = tree.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tree.addListener(12, treeListener);
        tree.addListener(1, treeListener);
        tree.addListener(5, treeListener);
        tree.addListener(32, treeListener);
    }
}

