/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.GroupItem;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Item;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadItem;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadStatesCtrl;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadsTipHandler {
    private Shell tipShell;
    private Table tipTable;
    private Item tipItem;
    private Point tipPosition;

    public ThreadsTipHandler(Shell parent) {
        Display display = parent.getDisplay();
        this.tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        GridData data = new GridData(1, 1, true, true);
        this.tipShell.setLayoutData((Object)data);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipTable = new Table((Composite)this.tipShell, 0);
        this.tipTable.setForeground(display.getSystemColor(28));
        this.tipTable.setBackground(display.getSystemColor(29));
        this.tipTable.setHeaderVisible(false);
        this.tipTable.setLinesVisible(false);
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ThreadsTipHandler.this.tipShell.isVisible()) {
                    ThreadsTipHandler.this.tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (ThreadsTipHandler.this.tipShell.isVisible()) {
                    ThreadsTipHandler.this.tipShell.setVisible(false);
                }
                ThreadsTipHandler.this.tipItem = null;
            }

            private void addItem(String name, String value) {
                TableItem line = new TableItem(ThreadsTipHandler.this.tipTable, 0);
                line.setText(0, name);
                line.setText(1, value);
            }

            private void fillValues(Point pt, ThreadStatesCtrl threadStates, Item item) {
                if (item instanceof ThreadItem) {
                    TRCThreadWaitingForObjectEvent event;
                    TRCThread thrd = ((ThreadItem)item)._thread;
                    TRCThreadEvent threadEvent = Utils.findEvent(thrd, threadStates.hitTimeTest(pt.x, pt.y), 0);
                    TRCThreadEvent nextEvent = Utils.findEvent(thrd, threadStates.hitTimeTest(pt.x, pt.y), 1);
                    this.addItem(UIMessages._THREAD_NAME, thrd.getName());
                    this.addItem(UIMessages._THREAD_CLASS_NAME, Utils.getThreadClassName(thrd));
                    this.addItem(UIMessages._THREAD_STATE, Utils.getEventName(threadEvent));
                    if (threadEvent instanceof TRCThreadWaitingForObjectEvent) {
                        event = (TRCThreadWaitingForObjectEvent)threadEvent;
                        TRCObject obj = event.getObjectWaitingFor();
                        this.addItem(UIMessages._OBJECT_WAITING_FOR, obj != null ? obj.getIsA().getName() : "null");
                        this.addItem(UIMessages._TIMEOUT, "" + event.getTimeout());
                    } else if (threadEvent instanceof TRCThreadWaitingForLockEvent) {
                        TRCClass cls;
                        event = (TRCThreadWaitingForLockEvent)threadEvent;
                        TRCObject obj = event.getLockedObject();
                        String monitor = "null";
                        if (obj != null && (cls = obj.getIsA()) != null) {
                            monitor = "";
                            if (cls.getPackage() != null && cls.getPackage().getName().length() > 0) {
                                monitor = String.valueOf(monitor) + cls.getPackage().getName() + ".";
                            }
                            monitor = String.valueOf(monitor) + cls.getName();
                        }
                        this.addItem(UIMessages._THREAD_MONITOR, monitor);
                        TRCThread thread = event.getLockingThread();
                        if (thread != null) {
                            this.addItem(UIMessages._MONITOR_OWNER, String.valueOf(thread.getName()) + "[" + Utils.getThreadClassName(thread) + "]");
                        }
                    }
                    double startTime = threadEvent == null ? thrd.getStartTime() : threadEvent.getTime();
                    double stopTime = nextEvent == null ? thrd.getStopTime() : nextEvent.getTime();
                    double duration = stopTime - startTime;
                    this.addItem(UIMessages._THREAD_START_TIME, Utils.formatTime(startTime));
                    this.addItem(UIMessages._DURATION, duration > 0.0 ? Utils.formatTime(duration) : "?");
                } else if (item instanceof GroupItem) {
                    this.addItem(UIMessages._THREAD_GROUP_NAME, item.toString());
                    this.addItem(UIMessages._NUMBER_OF_THREADS, "" + ((GroupItem)item)._threads.size());
                }
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                Item item = null;
                if (widget instanceof ThreadStatesCtrl) {
                    ThreadStatesCtrl threadStates = (ThreadStatesCtrl)widget;
                    item = threadStates.getItem(pt);
                    ThreadsTipHandler.this.tipTable.remove(0, ThreadsTipHandler.this.tipTable.getItemCount() - 1);
                    new TableColumn(ThreadsTipHandler.this.tipTable, 0);
                    new TableColumn(ThreadsTipHandler.this.tipTable, 0);
                    this.fillValues(pt, threadStates, item);
                    ThreadsTipHandler.this.tipTable.getColumn(0).setWidth(200);
                    ThreadsTipHandler.this.tipTable.getColumn(1).pack();
                    ThreadsTipHandler.this.tipTable.setSize(ThreadsTipHandler.this.tipTable.computeSize(-1, 200));
                    ThreadsTipHandler.this.tipShell.pack();
                } else if (widget == null) {
                    ThreadsTipHandler.this.tipShell.setVisible(false);
                    ThreadsTipHandler.this.tipItem = null;
                    return;
                }
                if (item == ThreadsTipHandler.this.tipItem) {
                    return;
                }
                ThreadsTipHandler.this.tipItem = item;
                ThreadsTipHandler.this.tipPosition = control.toDisplay(pt);
                ThreadsTipHandler.this.tipShell.pack();
                ThreadsTipHandler.this.setHoverLocation(ThreadsTipHandler.this.tipShell, ThreadsTipHandler.this.tipPosition);
                ThreadsTipHandler.this.tipShell.setVisible(true);
            }
        });
    }

    private void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

