/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class TraceColorScheme {
    public static final int UNKNOWN = 0;
    public static final int RUNNING = 1;
    public static final int SLEEPING = 2;
    public static final int WAITING = 3;
    public static final int BLOCKED = 4;
    public static final int DEADLOCK = 5;
    public static final int STOPPED = 6;
    public static final int STATES0 = 0;
    public static final int STATES1 = 7;
    public static final int UNKNOWN_SEL = 7;
    public static final int RUNNING_SEL = 8;
    public static final int SLEEPING_SEL = 9;
    public static final int WAITING_SEL = 10;
    public static final int BLOCKED_SEL = 11;
    public static final int DEADLOCK_SEL = 12;
    public static final int STOPPED_SEL = 13;
    public static final int STATES_SEL0 = 7;
    public static final int STATES_SEL1 = 13;
    public static final int BACKGROUND = 14;
    public static final int FOREGROUND = 15;
    public static final int BACKGROUND_SEL = 16;
    public static final int FOREGROUND_SEL = 17;
    public static final int BACKGROUND_SEL_NOFOCUS = 18;
    public static final int FOREGROUND_SEL_NOFOCUS = 19;
    public static final int TOOL_BACKGROUND = 20;
    public static final int TOOL_FOREGROUND = 21;
    public static final int FIX_COLOR = 22;
    public static final int WHITE = 23;
    public static final int GRAY = 24;
    public static final int BLACK = 25;
    public static final int DARK_GRAY = 26;
    public static final int UNKNOWN_BORDER = 27;
    public static final int RUNNING_BORDER = 28;
    public static final int SLEEPING_BORDER = 29;
    public static final int WAITING_BORDER = 30;
    public static final int BLOCKED_BORDER = 31;
    public static final int DEADLOCK_BORDER = 32;
    public static final int STOPPED_BORDER = 33;
    public static final int STATES_BORDER0 = 27;
    public static final int STATES_BORDER1 = 33;
    public static final int MID_LINE = 34;
    public static final int RED = 35;
    public static final int GREEN = 36;
    public static final int BLUE = 37;
    public static final int YELLOW = 38;
    public static final int CYAN = 39;
    public static final int MAGENTA = 40;
    public static final int SELECTED_TIME = 41;
    public static final int LEGEND_BACKGROUND = 42;
    public static final int LEGEND_FOREGROUND = 43;
    public static final int GR_BACKGROUND = 44;
    public static final int GR_FOREGROUND = 45;
    public static final int GR_BACKGROUND_SEL = 46;
    public static final int GR_FOREGROUND_SEL = 47;
    public static final int GR_BACKGROUND_SEL_NOFOCUS = 48;
    public static final int GR_FOREGROUND_SEL_NOFOCUS = 49;
    public static final int LIGHT_LINE = 50;
    public static final int BACKGROUND_NAME = 51;
    public static final int TI_START_THREAD = 25;
    public static final int TI_HANDOFF_LOCK = 37;
    public static final int TI_NOTIFY_ALL = 36;
    public static final int TI_NOTIFY = 36;
    public static final int TI_NOTIFY_JOINED = 26;
    public static final int TI_INTERRUPT = 35;
    public static final int TI_WAIT_EXCEEDED = 37;
    private static final IColorProvider[] _providersMap = new IColorProvider[]{new RGB(100, 100, 100), new RGB(174, 200, 124), new Mix(new SysCol(9), new SysCol(15), 1, 3), new RGB(210, 150, 60), new RGB(242, 225, 168), new Mix(new SysCol(3), new SysCol(15), 1, 3), new RGB(200, 200, 200), new SysCol(1), new SysCol(5), new SysCol(9), new SysCol(13), new SysCol(7), new SysCol(3), new SysCol(16), new SysCol(25), new SysCol(24), new SysCol(26), new SysCol(27), new SysCol(22), new SysCol(21), new SysCol(22), new SysCol(17), new SysCol(15), new SysCol(1), new SysCol(15), new SysCol(2), new SysCol(16), new SysCol(16), new RGB(75, 115, 120), new SysCol(10), new RGB(242, 225, 168), new RGB(210, 150, 60), new SysCol(4), new SysCol(2), new SysCol(15), new SysCol(3), new SysCol(5), new SysCol(9), new SysCol(7), new SysCol(13), new SysCol(11), new SysCol(9), new SysCol(22), new SysCol(17), new Mix(new RGB(150, 200, 240), new SysCol(25)), new RGB(0, 0, 50), new Mix(new RGB(200, 200, 100), new SysCol(26)), new Mix(new RGB(150, 200, 240), new SysCol(27)), new Mix(new RGB(222, 222, 155), new SysCol(22)), new RGB(0, 0, 50), new Mix(new SysCol(15), new SysCol(25), 1, 3), new Mix(new SysCol(15), new SysCol(25), 1, 6)};
    private Color[] _colors = new Color[_providersMap.length];

    public void dispose() {
        int i = 0;
        while (i < this._colors.length) {
            Utils.dispose(this._colors[i]);
            this._colors[i] = null;
            ++i;
        }
    }

    public Color getColor(int idx) {
        if (this._colors[idx] == null) {
            if (idx >= 7 && idx <= 13) {
                Color col1 = this.getColor(idx - 7);
                Color col2 = this.getColor(16);
                this._colors[idx] = Utils.mixColors(col1, col2, 3, 1);
            } else {
                this._colors[idx] = _providersMap[idx].get();
            }
        }
        return this._colors[idx];
    }

    public Color getBkColor(boolean selected, boolean focused, boolean name) {
        if (selected && focused) {
            return this.getColor(16);
        }
        if (selected) {
            return this.getColor(18);
        }
        if (name) {
            return this.getColor(51);
        }
        return this.getColor(14);
    }

    public Color getFgColor(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(17);
        }
        if (selected) {
            return this.getColor(19);
        }
        return this.getColor(15);
    }

    public Color getBkColorGroup(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(46);
        }
        if (selected) {
            return this.getColor(48);
        }
        return this.getColor(44);
    }

    public Color getFgColorGroup(boolean selected, boolean focused) {
        if (selected && focused) {
            return this.getColor(47);
        }
        if (selected) {
            return this.getColor(49);
        }
        return this.getColor(45);
    }

    static interface IColorProvider {
        public Color get();
    }

    static class Mix
    implements IColorProvider {
        IColorProvider cp1;
        IColorProvider cp2;
        int w1;
        int w2;

        Mix(IColorProvider cp1, IColorProvider cp2, int w1, int w2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
            this.w1 = w1;
            this.w2 = w2;
        }

        Mix(IColorProvider cp1, IColorProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
            this.w1 = 1;
            this.w2 = 1;
        }

        public Color get() {
            Color col1 = this.cp1.get();
            Color col2 = this.cp2.get();
            Color col = Utils.mixColors(col1, col2, this.w1, this.w2);
            return col;
        }
    }

    static class RGB
    implements IColorProvider {
        int r;
        int g;
        int b;

        RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Color get() {
            return new Color(null, this.r, this.g, this.b);
        }
    }

    static class SysCol
    implements IColorProvider {
        int syscol;

        SysCol(int syscol) {
            this.syscol = syscol;
        }

        public Color get() {
            return Utils.getSysColor(this.syscol);
        }
    }
}

