/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCGCEvent;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObjectAllocationAnnotation;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.internal.util.OpenJavaSource;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.jvmti.internal.client.AllocationSite;
import org.eclipse.tptp.trace.jvmti.internal.client.MethodDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.TITracePlugin;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Utils {
    public static final int IMG_THREAD_RUNNING = 0;
    public static final int IMG_THREAD_SUSPENDED = 1;
    public static final int IMG_THREAD_STOPPED = 2;
    public static final int IMG_METHOD_RUNNING = 3;
    public static final int IMG_METHOD = 4;
    public static final int IMG_NUM = 5;
    public static final Object[] _empty = new Object[0];
    private static String[] _externalPlugin = new String[]{"org.eclipse.debug.ui", "org.eclipse.debug.ui", "org.eclipse.debug.ui", "org.eclipse.debug.ui", "org.eclipse.debug.ui"};
    private static String[] _externalPath = new String[]{"icons/full/obj16/thread_obj.gif", "icons/full/obj16/threads_obj.gif", "icons/full/obj16/threadt_obj.gif", "icons/full/obj16/stckframe_running_obj.gif", "icons/full/obj16/stckframe_obj.gif"};

    public static Image getImage(int idx) {
        if (idx < 0 || idx >= 5) {
            SWT.error((int)5);
        }
        String key = "trace.img." + idx;
        Image img = TITracePlugin.getDefault().getImageRegistry().get(key);
        if (img == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)_externalPlugin[idx], (String)_externalPath[idx]);
            TITracePlugin.getDefault().getImageRegistry().put(key, desc);
            img = TITracePlugin.getDefault().getImageRegistry().get(key);
        }
        return img;
    }

    public static void init(Rectangle rect) {
        rect.x = 0;
        rect.y = 0;
        rect.width = 0;
        rect.height = 0;
    }

    public static void init(Rectangle rect, int x, int y, int width, int height) {
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
    }

    public static void init(Rectangle rect, Rectangle source) {
        rect.x = source.x;
        rect.y = source.y;
        rect.width = source.width;
        rect.height = source.height;
    }

    public static void deflate(Rectangle rect, int x, int y) {
        rect.x += x;
        rect.y += y;
        rect.width -= x + x;
        rect.height -= y + y;
    }

    public static void inflate(Rectangle rect, int x, int y) {
        rect.x -= x;
        rect.y -= y;
        rect.width += x + x;
        rect.height += y + y;
    }

    static void dispose(Color col) {
        if (col != null) {
            col.dispose();
        }
    }

    public static Color mixColors(Device display, Color c1, Color c2, int w1, int w2) {
        return new Color(display, (w1 * c1.getRed() + w2 * c2.getRed()) / (w1 + w2), (w1 * c1.getGreen() + w2 * c2.getGreen()) / (w1 + w2), (w1 * c1.getBlue() + w2 * c2.getBlue()) / (w1 + w2));
    }

    public static Color getSysColor(int id) {
        Color col = Display.getCurrent().getSystemColor(id);
        return new Color(col.getDevice(), col.getRGB());
    }

    public static Color mixColors(Color col1, Color col2, int w1, int w2) {
        return Utils.mixColors((Device)Display.getCurrent(), col1, col2, w1, w2);
    }

    public static void drawState(TraceColorScheme colors, TRCThreadEvent event, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        int colorIdx = Utils.getEventColor(event);
        Utils.drawState(colors, colorIdx, rect, gc, selected, rectBound, timeSelected);
    }

    public static void drawState(TraceColorScheme colors, int colorIdx, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        if (rect.isEmpty()) {
            return;
        }
        int colorIdx1 = colorIdx;
        boolean bl = timeSelected = timeSelected && selected;
        if (timeSelected) {
            colorIdx1 = colorIdx + 7 - 0;
        }
        gc.setBackground(colors.getColor(colorIdx1));
        gc.fillRectangle(rect);
        colorIdx1 = colorIdx + 27 - 0;
        gc.setForeground(colors.getColor(colorIdx1));
        if (!timeSelected) {
            if (rectBound && rect.width >= 3) {
                gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            } else {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            }
        }
        int mindy = rect.y + rect.height / 2;
        if (4 == colorIdx || 3 == colorIdx) {
            int s = gc.getLineStyle();
            int w = gc.getLineWidth();
            gc.setLineStyle(3);
            gc.setLineWidth(2);
            gc.drawLine(rect.x, mindy, rect.x + rect.width, mindy);
            gc.setLineStyle(s);
            gc.setLineWidth(w);
        } else if (5 == colorIdx || 6 == colorIdx) {
            int w = gc.getLineWidth();
            gc.setLineWidth(2);
            gc.drawLine(rect.x, mindy, rect.x + rect.width, mindy);
            gc.setLineWidth(w);
        }
        if (timeSelected) {
            gc.setForeground(colors.getColor(41));
            if (rect.width >= 3) {
                gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            } else {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
            }
            gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width - 1, rect.y + 1);
            gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width - 1, rect.y + rect.height - 2);
        }
    }

    public static int getEventColor(TRCThreadEvent event) {
        if (event instanceof TRCThreadRunningEvent) {
            return 1;
        }
        if (event instanceof TRCThreadSleepingEvent) {
            return 2;
        }
        if (event instanceof TRCThreadDeadLockEvent) {
            return 5;
        }
        if (event instanceof TRCThreadWaitingForLockEvent) {
            return 4;
        }
        if (event instanceof TRCThreadWaitingForObjectEvent) {
            return 3;
        }
        if (event instanceof TRCThreadDeadEvent) {
            return 6;
        }
        return 0;
    }

    public static int drawText(GC gc, String text, Rectangle rect, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, rect.x, rect.y, transp);
        return size.x;
    }

    public static int drawText(GC gc, String text, int x, int y, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, x, y, transp);
        return size.x;
    }

    public static TRCClass getThreadClass(TRCThread thread) {
        TRCClass cls = null;
        if (thread.getThreadObject() != null) {
            cls = thread.getThreadObject().getIsA();
        } else if (thread.getInitialInvocations().size() > 0) {
            cls = ((TRCMethodInvocation)thread.getInitialInvocations().get(0)).getMethod().getDefiningClass();
        }
        return cls;
    }

    public static String getThreadClassName(TRCThread thread) {
        String name = "";
        TRCClass cls = Utils.getThreadClass(thread);
        if (cls != null) {
            name = Utils.getPackageClassName(cls);
        }
        return name;
    }

    public static String getPackageClassName(TRCClass cls) {
        String name = "";
        if (cls != null) {
            TRCPackage pkg = cls.getPackage();
            name = pkg != null && pkg.getName().length() > 0 ? String.valueOf(pkg.getName()) + "." + cls.getName() : cls.getName();
        }
        return name;
    }

    public static String getFullMethodName(TRCMethod m, boolean sig) {
        String name = "";
        name = String.valueOf(name) + Utils.getPackageClassName(m.getDefiningClass());
        name = String.valueOf(name) + ".";
        name = String.valueOf(name) + m.getName();
        if (sig) {
            name = String.valueOf(name) + m.getSignature();
        }
        return name;
    }

    public static String getEventName(TRCThreadEvent event) {
        return Utils.getEventName(event, true, false);
    }

    public static String getEventName(TRCThreadEvent event, boolean upper, boolean extInfo) {
        String name;
        String string = name = upper ? UIMessages._Unknown : UIMessages._unknown;
        if (event instanceof TRCThreadRunningEvent) {
            name = upper ? UIMessages._Running : UIMessages._running;
        } else if (event instanceof TRCThreadSleepingEvent) {
            name = upper ? UIMessages._Sleeping : UIMessages._sleeping;
        } else if (event instanceof TRCThreadDeadLockEvent) {
            name = upper ? UIMessages._Deadlocked : UIMessages._deadlocked;
        } else if (event instanceof TRCThreadWaitingForLockEvent) {
            TRCThread thread;
            String string2 = name = upper ? UIMessages._Blocked : UIMessages._blocked;
            if (extInfo && (thread = ((TRCThreadWaitingForLockEvent)event).getLockingThread()) != null) {
                name = String.valueOf(name) + " by thread=" + thread.getName();
            }
        } else if (event instanceof TRCThreadWaitingForObjectEvent) {
            String string3 = name = upper ? UIMessages._Waiting : UIMessages._waiting;
            if (extInfo) {
                name = String.valueOf(name) + " timeout=" + ((TRCThreadWaitingForObjectEvent)event).getTimeout();
            }
        } else if (event instanceof TRCThreadDeadEvent) {
            name = upper ? UIMessages._Stopped : UIMessages._stopped;
        }
        return name;
    }

    public static String composeThreadName(TRCThread thread, boolean inclState) {
        EList list;
        String name = thread.getName();
        String threadClass = Utils.getThreadClassName(thread);
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        if (inclState && (list = thread.getThreadEvents()) != null && list.size() > 0) {
            TRCThreadEvent event = (TRCThreadEvent)list.get(list.size() - 1);
            name = String.valueOf(name) + " (" + Utils.getEventName(event, false, true) + ")";
        }
        return name;
    }

    public static String composeMethodName(TRCMethodInvocation method) {
        return Utils.getFullMethodName(method.getMethod(), true);
    }

    public static String composeEventName(TRCThreadEvent event) {
        String name = event.getThread().getName();
        String threadClass = Utils.getThreadClassName(event.getThread());
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        name = String.valueOf(name) + " (" + Utils.getEventName(event, false, true) + ")";
        return name;
    }

    public static String composeMethodName(MethodDetails method) {
        String unwrapped;
        int pos;
        String name = "";
        if (method.name != null) {
            name = String.valueOf(name) + method.name;
        }
        if (method.signature != null && (pos = (unwrapped = method.signature.substring(1, method.signature.length() - 1)).indexOf(40)) >= 0) {
            name = String.valueOf(name) + unwrapped.substring(pos);
        }
        if (method.line >= 0) {
            name = String.valueOf(name) + " line: " + method.line;
        }
        return name;
    }

    public static String composeMethodName(AllocationSite allocSite) {
        String name = "";
        if (allocSite._method != null) {
            name = String.valueOf(name) + Utils.getFullMethodName(allocSite._method, true);
        }
        if (allocSite._lineNo >= 0) {
            name = String.valueOf(name) + " line:" + allocSite._lineNo;
        }
        return name;
    }

    public static Image getItemImage(Object obj) {
        if (obj instanceof MethodDetails) {
            if (((MethodDetails)obj).running) {
                return Utils.getImage(3);
            }
            return Utils.getImage(4);
        }
        if (obj instanceof TRCThread) {
            EList list = ((TRCThread)obj).getThreadEvents();
            if (list != null && list.size() > 0) {
                obj = list.get(list.size() - 1);
            } else {
                if (((TRCThread)obj).getStopTime() > 0.0) {
                    return Utils.getImage(2);
                }
                return Utils.getImage(0);
            }
        }
        if (obj instanceof TRCThreadEvent) {
            if (obj instanceof TRCThreadDeadEvent) {
                return Utils.getImage(2);
            }
            if (obj instanceof TRCThreadRunningEvent) {
                return Utils.getImage(0);
            }
            return Utils.getImage(1);
        }
        return null;
    }

    public static void setActionProperties(Action action, String context, String attributeId) {
        String strLevel = null;
        Image icon = null;
        IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider((String)context, (String)attributeId, (int)2);
        if (clfp != null) {
            strLevel = clfp.getDisplayStringFromElement((Object)attributeId, null, 2);
            icon = clfp.getDisplayImageByElement((Object)attributeId, null, 2);
        } else {
            strLevel = attributeId;
        }
        action.setText(strLevel);
        action.setImageDescriptor(ImageDescriptor.createFromImage(icon));
        action.setDescription(strLevel);
        action.setToolTipText(strLevel);
    }

    public static Object[] getCallStack(TRCThreadEvent event) {
        int i;
        Object[] ret = _empty;
        EList list = event.getAnnotations();
        TRCAnnotation callStackDumpMethods = null;
        TRCAnnotation callStackDumpLineNumbers = null;
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                TRCAnnotation annotation = (TRCAnnotation)list.get(i);
                if (annotation.getName().equals("callStackDumpMethods")) {
                    callStackDumpMethods = annotation;
                } else if (annotation.getName().equals("callStackDumpLineNumbers")) {
                    callStackDumpLineNumbers = annotation;
                }
                ++i;
            }
        }
        if (callStackDumpMethods != null) {
            list = callStackDumpMethods.getValues();
            ret = new Object[list.size()];
            i = 0;
            while (i < list.size()) {
                String name = list.get(i).toString();
                String sig = null;
                int pos = name.indexOf(32);
                if (pos >= 0) {
                    sig = name.substring(pos + 1);
                    name = name.substring(0, pos);
                }
                MethodDetails method = new MethodDetails(name, sig);
                method.running = event instanceof TRCThreadRunningEvent;
                ret[i] = method;
                ++i;
            }
            if (callStackDumpLineNumbers != null) {
                list = callStackDumpLineNumbers.getValues();
                i = 0;
                while (i < ret.length && i < list.size()) {
                    ((MethodDetails)ret[i]).line = Integer.parseInt(list.get(i).toString());
                    ++i;
                }
            }
        }
        return ret;
    }

    public static boolean canOpenSourceOnThisObject(EObject mofObj) {
        ITraceSelection _model = UIPlugin.getDefault().getSelectionModel(mofObj);
        if (_model.size() == 0 || _model.getFirstElement() == null) {
            return false;
        }
        Object firstElement = _model.getFirstElement();
        if (firstElement instanceof TRCClass && ((TRCClass)firstElement).getSourceInfo() != null && ((TRCClass)firstElement).getSourceInfo().getLocation().length() > 0) {
            return true;
        }
        return firstElement instanceof TRCMethod;
    }

    public static String formatTime(double v) {
        long sec;
        boolean neg;
        StringBuffer str = new StringBuffer();
        boolean bl = neg = v < 0.0;
        if (neg) {
            v = -v;
            str.append('-');
        }
        if ((sec = (long)v) / 60L < 10L) {
            str.append('0');
        }
        str.append(sec / 60L);
        str.append(':');
        if ((sec %= 60L) < 10L) {
            str.append('0');
        }
        str.append(sec);
        str.append(':');
        long ms = (long)(v * 1000.0);
        if ((ms %= 1000L) < 10L) {
            str.append("00");
        } else if (ms < 100L) {
            str.append('0');
        }
        str.append(ms);
        return str.toString();
    }

    public static int loadIntOption(String opt, int def, int min, int max) {
        int val = TraceUIPlugin.getDefault().getPreferenceStore().getInt(opt);
        if (val == 0) {
            val = def;
        }
        if (val < min) {
            val = min;
        }
        if (val > max) {
            val = max;
        }
        return val;
    }

    public static int loadIntOption(String opt) {
        int val = TraceUIPlugin.getDefault().getPreferenceStore().getInt(opt);
        return val;
    }

    public static void saveIntOption(String opt, int val) {
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(opt, val);
    }

    static TRCThreadEvent getFirstEvent(TRCThread thread) {
        if (thread == null) {
            return null;
        }
        EList list = thread.getThreadEvents();
        TRCThreadEvent event = null;
        if (!list.isEmpty()) {
            event = (TRCThreadEvent)list.get(0);
        }
        return event;
    }

    /*
     * Unable to fully structure code
     */
    static TRCThreadEvent findEvent(TRCThread thread, double time, int n) {
        block10: {
            if (thread == null) {
                return null;
            }
            list = thread.getThreadEvents();
            it = list.iterator();
            event = null;
            prevEvent = null;
            nextEvent = null;
            if (!it.hasNext()) break block10;
            event = (TRCThreadEvent)it.next();
            currTime = event.getTime();
            if (!(time < currTime)) ** GOTO lbl26
            if (1 != n) {
                event = null;
            }
            return event;
lbl-1000:
            // 1 sources

            {
                nextEvent = (TRCThreadEvent)it.next();
                nextTime = nextEvent.getTime();
                if (currTime <= time && time < nextTime) {
                    if (1 == n) {
                        event = nextEvent;
                    } else if (-1 == n) {
                        event = prevEvent;
                    }
                    return event;
                }
                prevEvent = event;
                event = nextEvent;
lbl26:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        if (1 == n) {
            event = null;
        } else if (-1 == n) {
            event = prevEvent;
        }
        return event;
    }

    public static TRCPackage getPackage(Object element) {
        if (element instanceof TRCPackage) {
            return (TRCPackage)element;
        }
        if (element instanceof TRCClass) {
            return ((TRCClass)element).getPackage();
        }
        return null;
    }

    public static TRCObjectAllocationAnnotation getAllocationAnnotation(TRCClass cls) {
        TRCObjectAllocationAnnotation aa = null;
        EList list = cls.getAnnotations();
        int len = list.size();
        int i = 0;
        while (i < len) {
            TRCAnnotation annotation = (TRCAnnotation)list.get(i);
            if (annotation instanceof TRCObjectAllocationAnnotation) {
                aa = (TRCObjectAllocationAnnotation)annotation;
            }
            ++i;
        }
        return aa;
    }

    public static String fixMethodSignature(String sig) {
        int pos = (sig = sig.substring(1, sig.length() - 1)).indexOf(40);
        if (pos >= 0) {
            String ret = sig.substring(0, pos);
            sig = sig.substring(pos);
            sig = String.valueOf(sig) + " " + ret;
        }
        return sig;
    }

    public static String restoreMethodSignature(String sig) {
        String ret = "";
        int pos = sig.indexOf(40);
        if (pos >= 0) {
            ret = sig.substring(0, pos);
            sig = sig.substring(pos + 1);
        }
        if ((pos = sig.indexOf(41)) >= 0) {
            sig = sig.substring(0, pos);
        }
        String[] args = sig.split(",");
        sig = "(";
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.length() == 0 && args.length == 1) break;
            sig = String.valueOf(sig) + Utils.getTypeSignature(arg);
            ++i;
        }
        sig = String.valueOf(sig) + ")" + Utils.getTypeSignature(ret);
        return sig;
    }

    public static String getTypeSignature(String type) {
        int dim = 0;
        int j = 0;
        while (j < type.length()) {
            if (type.charAt(j) == '[') {
                ++dim;
            }
            ++j;
        }
        int pos = type.indexOf(91);
        if (pos >= 0) {
            type = type.substring(0, pos);
        }
        String sig = "";
        int j2 = 0;
        while (j2 < dim) {
            sig = String.valueOf(sig) + "[";
            ++j2;
        }
        sig = type.equals("boolean") ? String.valueOf(sig) + "Z" : (type.equals("byte") ? String.valueOf(sig) + "B" : (type.equals("char") ? String.valueOf(sig) + "C" : (type.equals("short") ? String.valueOf(sig) + "S" : (type.equals("int") ? String.valueOf(sig) + "I" : (type.equals("long") ? String.valueOf(sig) + "J" : (type.equals("float") ? String.valueOf(sig) + "F" : (type.equals("double") ? String.valueOf(sig) + "D" : (type.equals("void") ? String.valueOf(sig) + "V" : String.valueOf(sig) + "L" + type.replace('.', '/') + ";"))))))));
        return sig;
    }

    public static boolean openSource(Object element) {
        if (element instanceof String) {
            System.out.println("openSource: " + element);
            final String pattern = (String)element;
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    if (!OpenJavaSource.openSource((String)pattern, (int)1, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (boolean)true)) {
                        MessageDialog.openInformation((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TraceMessages.TRC_MSGT, (String)NLS.bind((String)TraceUIMessages._68, (Object)pattern));
                    }
                }
            });
        }
        OpenSource.openSource((Object)element);
        return true;
    }

    public static int getObjAge(TRCFullTraceObject obj, EList listGC) {
        int age = 0;
        double t0 = obj.getCreateTime();
        double t1 = obj.getCollectTime();
        int len = listGC.size();
        int j = 0;
        while (j < len) {
            double time;
            TRCGCEvent gcEvent = (TRCGCEvent)listGC.get(j);
            if (gcEvent.getType().equals("finish") && !((time = gcEvent.getTime()) <= t0)) {
                if (t1 > 0.0 && time >= t1) break;
                ++age;
            }
            ++j;
        }
        return age;
    }

    public static int compare(double d1, double d2) {
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return 1;
        }
        return 0;
    }

    public static int compare(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.compareToIgnoreCase(s2);
        }
        if (s1 != null) {
            return 1;
        }
        if (s2 != null) {
            return -1;
        }
        return 0;
    }

    public static String getAgentName(EObject mofObject) {
        String name = "";
        EList list = null;
        if (mofObject instanceof TRCAgentProxy) {
            name = ((TRCAgentProxy)mofObject).getName();
        } else if (mofObject instanceof TRCProcessProxy) {
            list = ((TRCProcessProxy)mofObject).getAgentProxies();
        } else if (mofObject instanceof TRCNode) {
            list = ((TRCNode)mofObject).getProcessProxies();
        }
        if (list != null && list.size() > 0) {
            name = Utils.getAgentName((EObject)list.get(0));
        }
        return name;
    }

    public static String formatPercent(int val, int max) {
        String s = max > 0 && max >= val ? TString.formatAsPercentage((double)((double)val / (double)max)) : "";
        return s;
    }
}

