/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.provisional.client.extension;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.context.java.formatters.AttrLPAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.jvmti.provisional.client.extension.ICustomColumnParticipation;

public class CustomColumn {
    private int viewMode;
    private ColumnLabelAdapter labelAdapter;
    private AttrLPAdapter attrAdapter;
    private String id;
    private int style;
    private String align;
    private int width;
    private ICustomColumnParticipation columnParticipation;
    private static final String CUSTOM_COLUMN_EXT_ID = "org.eclipse.tptp.trace.jvmti.client.customColumn";
    private static CustomColumn[] providers = null;

    public CustomColumn(ICustomColumnParticipation columnParticipation, int viewMode, ColumnLabelAdapter labelAdapter, AttrLPAdapter attrAdapter, String id, int flags, String align, int width) {
        this.columnParticipation = columnParticipation;
        this.viewMode = viewMode;
        this.labelAdapter = labelAdapter;
        this.attrAdapter = attrAdapter;
        this.id = id;
        this.style = flags;
        this.align = align;
        this.width = width;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public ColumnLabelAdapter getLabelAdapter() {
        return this.labelAdapter;
    }

    public AttrLPAdapter getAttrAdapter() {
        return this.attrAdapter;
    }

    public String getId() {
        return this.id;
    }

    public int getStyle() {
        return this.style;
    }

    public String getAlign() {
        return this.align;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isEnabled(TraceViewerPage page) {
        if (this.columnParticipation != null) {
            return this.columnParticipation.isEnabled(page);
        }
        return true;
    }

    public static CustomColumn[] getContributors() {
        if (providers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_COLUMN_EXT_ID);
            ArrayList<CustomColumn> providerList = new ArrayList<CustomColumn>();
            try {
                if (elements != null) {
                    int configElement = 0;
                    while (configElement < elements.length) {
                        IConfigurationElement el = elements[configElement];
                        ICustomColumnParticipation columnParticipation = null;
                        if (el.getAttribute("columnParticipation") != null) {
                            columnParticipation = (ICustomColumnParticipation)el.createExecutableExtension("columnParticipation");
                        }
                        ColumnLabelAdapter labelAdapter = (ColumnLabelAdapter)el.createExecutableExtension("labelAdapter");
                        AttrLPAdapter attrAdapter = (AttrLPAdapter)el.createExecutableExtension("attrAdapter");
                        int viewMode = Integer.valueOf(el.getAttribute("viewMode"));
                        String attrib = el.getAttribute("id");
                        int style = Integer.valueOf(el.getAttribute("style"));
                        String align = el.getAttribute("align");
                        int width = Integer.valueOf(el.getAttribute("width"));
                        CustomColumn column = new CustomColumn(columnParticipation, viewMode, labelAdapter, attrAdapter, attrib, style, align, width);
                        providerList.add(column);
                        ++configElement;
                    }
                }
            }
            catch (CoreException e) {
                CommonPlugin.logError((Throwable)e);
            }
            providers = new CustomColumn[providerList.size()];
            int i = 0;
            while (i < providerList.size()) {
                CustomColumn.providers[i] = (CustomColumn)providerList.get(i);
                ++i;
            }
        }
        return providers;
    }
}

