/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.internal;

import java.util.Iterator;
import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.core.internal.IDWallpaper;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellBorder;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellData;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFocusMark;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFolder;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellImage;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellLinePrefix;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.brushes.internal.FullGradientBrush;
import org.eclipse.tptp.platform.report.igc.brushes.internal.GradientBrush;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.GradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.IGradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.IRenderMonitor;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;

public class SWTPainter
extends DExtensible {
    private Rect crect = new Rect(0, 0, 0, 0);
    private Rect rtmp = new Rect();

    public void doMethod(DDocument doc, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawWallpaper(e, e.paintArea.getX(), e.paintArea.getY(), e.paintArea.getW(), e.paintArea.getH());
        this.drawChildrenCell(e);
    }

    public void doMethod(DSection section, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawChildrenCell(e);
    }

    public void doMethod(DHeader h, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawChildrenCell(e);
    }

    public void doMethod(DFooter f, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawChildrenCell(e);
    }

    public void doMethod(DPageCounter section, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        if (!(e.cell instanceof TCellText)) {
            return;
        }
        this.drawTextCell((TCellText)e.cell, e, 1);
    }

    public void doMethod(IDLink link, DExtensible ext, Object event) {
    }

    public void doMethod(DTitle title, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        if (!(e.cell instanceof TCellText)) {
            return;
        }
        this.drawTextCell((TCellText)e.cell, e, 1);
    }

    public void doMethod(DList list, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        TCellLinePrefix cell = (TCellLinePrefix)e.cell;
        IGCDStyle s = new IGCDStyle(cell.getEntryItem(), e.zoom);
        IFont oldfont = e.gc.setFont(s.getFont());
        IBrush oldbrush = null;
        switch (list.getFormat()) {
            case 5: {
                ISymbol sy = cell.getSymbol();
                this.rtmp.setRect(e.paintArea.getX(), e.paintArea.getY() + e.cell.getHeight() / 3, e.cell.getWidth(), e.cell.getHeight() / 3);
                int c = s.getFore();
                IPen oldpen = e.gc.setPen((IPen)new LineStylePen(c));
                c = s.getBack();
                oldbrush = e.gc.setBrush((IBrush)new SolidBrush(c));
                sy.draw(e.gc, (IRect)this.rtmp);
                e.gc.setPen(oldpen);
                break;
            }
            default: {
                if (cell.getNumber() == null) break;
                int c = s.getFore();
                oldbrush = e.gc.setBrush((IBrush)new SolidBrush(c));
                cell.setItem(cell.getEntryItem());
                this.drawTextCell(cell, cell.getNumber(), 0, cell.getNumber().length(), e, 1);
                cell.setItem((IDItem)list);
            }
        }
        e.gc.setBrush(oldbrush);
        e.gc.setFont(oldfont);
    }

    public void doMethod(DParagraph p, DExtensible ext, Object event) {
        this.drawChildrenCell((PainterEvent)event);
    }

    public void doMethod(DTag t, DExtensible ext, Object event) {
    }

    public void doMethod(DText text, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        if (!(e.cell instanceof TCellText)) {
            return;
        }
        this.drawTextCell((TCellText)e.cell, (PainterEvent)event, 1);
        this.drawFocus((PainterEvent)event);
    }

    public void doMethod(DImage image, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        if (!(e.cell instanceof TCellImage)) {
            return;
        }
        IImage pix = ((TCellImage)e.cell).getImage();
        if (pix != null) {
            e.gc.drawImage(pix, 0, 0, pix.getWidth(), pix.getHeight(), e.paintArea.getX(), e.paintArea.getY(), e.cell.getWidth(), e.cell.getHeight());
        }
        this.drawFocus((PainterEvent)event);
    }

    public void doMethod(DCellText celltext, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        if (e.cell instanceof TCellText) {
            this.drawTextCell((TCellText)e.cell, e, 1);
        } else {
            this.drawCellBackground(e);
            this.drawCellBorder(e);
        }
        this.drawChildrenCell(e);
    }

    public void doMethod(DCell cell, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawCellBackground(e);
        this.drawCellBorder(e);
        this.drawChildrenCell(e);
    }

    public void doMethod(DTable table, DExtensible ext, Object event) {
        this.drawChildrenCell((PainterEvent)event);
    }

    public void doMethod(DPopup popup, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        this.drawChildrenCell(e);
    }

    public void doMethod(IDRenderable object, DExtensible ext, Object event) {
        if (object.getFirstChild() instanceof DGraphic) {
            object = (IDRenderable)object.getFirstChild();
        }
        PainterEvent e = (PainterEvent)event;
        TAbstractCell cell = e.cell;
        if (cell instanceof TCellFocusMark) {
            return;
        }
        TCellData celldata = cell instanceof TCellData ? (TCellData)cell : null;
        IRender render_ = DRenderRegistry.GetRender((IDRenderable)object);
        IBrush ob = e.gc.getBrush();
        IPen op = e.gc.getPen();
        IShape oc = e.gc.getClipping();
        render_.draw(e.gc, (IRect)e.paintArea, object, e.zoom, e.iimgProvider, (IRenderMonitor)new NullRenderMonitor(), (IVObject)celldata);
        this.drawFocus((PainterEvent)event);
        e.gc.setBrush(ob);
        e.gc.setPen(op);
        e.gc.setClipping(oc);
    }

    protected void drawGradientRect(IGC gc, int x, int y, int w, int h, int rgba1, int rgba2, boolean vertical) {
        GradientBrush nbrush = new GradientBrush(rgba1, rgba2, vertical);
        nbrush.setBounds(x, y, w, h);
        IBrush obrush = gc.setBrush((IBrush)nbrush);
        gc.fillRect(x, y, w, h);
        gc.setBrush(obrush);
    }

    public void doMethod(DLine line, DExtensible ext, Object event) {
        PainterEvent e = (PainterEvent)event;
        int lw = line.getSize();
        IBrush oldbrush = e.gc.getBrush();
        this.crect.setRect(e.cell.getX(), e.cell.getY(), e.cell.getWidth(), e.cell.getHeight());
        int ly = e.paintArea.getY() + (this.crect.getH() - lw) / 2;
        if (line.isType("HGRADRIENT.DLine.jscrib")) {
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), lw, e.style.getFore(), e.style.getBack(), false);
        } else if (line.isType("HGRADRIENTR.DLine.jscrib")) {
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), lw, e.style.getBack(), e.style.getFore(), false);
        } else if (line.isType("HGRADRIENT2.DLine.jscrib")) {
            int xl = e.paintArea.getX();
            int xm = e.paintArea.getX() + this.crect.getW() / 2;
            int xr = e.paintArea.getX() + this.crect.getW();
            this.drawGradientRect(e.gc, xl, ly, xm - xl, lw, e.style.getBack(), e.style.getFore(), false);
            this.drawGradientRect(e.gc, xm, ly, xr - xm, lw, e.style.getFore(), e.style.getBack(), false);
        } else if (line.isType("HGRADRIENT2R.DLine.jscrib")) {
            int xl = e.paintArea.getX();
            int xm = e.paintArea.getX() + this.crect.getW() / 2;
            int xr = e.paintArea.getX() + this.crect.getW();
            this.drawGradientRect(e.gc, xl, ly, xm - xl, lw, e.style.getFore(), e.style.getBack(), false);
            this.drawGradientRect(e.gc, xm, ly, xr - xm, lw, e.style.getBack(), e.style.getFore(), false);
        } else if (line.isType("VGRADRIENT.DLine.jscrib")) {
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), lw, e.style.getFore(), e.style.getBack(), true);
        } else if (line.isType("VGRADRIENTR.DLine.jscrib")) {
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), lw, e.style.getBack(), e.style.getFore(), true);
        } else if (line.isType("VGRADRIENT2.DLine.jscrib")) {
            int ym = ly + lw / 2;
            int yb = ly + lw;
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), ym - ly, e.style.getBack(), e.style.getFore(), true);
            this.drawGradientRect(e.gc, e.paintArea.getX(), ym, this.crect.getW(), yb - ym, e.style.getFore(), e.style.getBack(), true);
        } else if (line.isType("VGRADRIENT2R.DLine.jscrib")) {
            int ym = ly + lw / 2;
            int yb = ly + lw;
            this.drawGradientRect(e.gc, e.paintArea.getX(), ly, this.crect.getW(), ym - ly, e.style.getFore(), e.style.getBack(), true);
            this.drawGradientRect(e.gc, e.paintArea.getX(), ym, this.crect.getW(), yb - ym, e.style.getBack(), e.style.getFore(), true);
        } else {
            e.gc.setBrush((IBrush)new SolidBrush(e.style.getFore()));
            e.gc.fillRect(e.paintArea.getX(), ly, this.crect.getW(), lw);
        }
        e.gc.setBrush(oldbrush);
    }

    public void drawFocus(PainterEvent evt) {
        if (!evt.drawFocus) {
            return;
        }
        IBrush oldbrush = evt.gc.setBrush((IBrush)new SolidBrush(-1));
        IPen open = evt.gc.setPen((IPen)new LineStylePen(255));
        evt.gc.drawFocus(evt.paintArea.getX() - 1, evt.paintArea.getY() - 1, evt.paintArea.getW() + 1, evt.paintArea.getH() + 1);
        evt.gc.setPen(open);
        evt.gc.setBrush(oldbrush);
    }

    public void drawTextCell(TCellText cell, PainterEvent evt, int alignment) {
        this.drawTextCell(cell, cell.getText(), cell.getStart(), cell.getLen(), evt, alignment);
    }

    public void drawTextCell(TAbstractCell cell, String text, int startPos, int len, PainterEvent evt, int alignment) {
        IGC gc = evt.gc;
        Rect r_area = evt.paintArea;
        boolean hasSelection = evt.drawSelection;
        int start = evt.start;
        int end = evt.end;
        if (text != null) {
            text = text.substring(startPos, startPos + len);
        }
        this.rtmp.setRect(r_area.getX(), r_area.getY(), r_area.getW(), r_area.getH());
        Font font = IGCDStyle.GetFont((IDItem)cell.getItem(), (float)evt.zoom);
        IBrush oldbrush = gc.setBrush((IBrush)new SolidBrush(evt.style.getBack()));
        if (evt.style.getBack() != 0) {
            evt.gc.fillRect(evt.cellClip.getX() + 1, evt.cellClip.getY() + 1, evt.cellClip.getW() - 1, evt.cellClip.getH() - 1);
        }
        gc.setBrush((IBrush)new SolidBrush(evt.style.getFore()));
        IFont oldfont = gc.setFont((IFont)font);
        DrawUtilIGC.drawText((IGC)gc, (IRect)this.rtmp, (int)alignment, (String)text);
        if (hasSelection) {
            if (start > end) {
                int tmp = start;
                start = end;
                end = tmp;
            }
            int cpos = cell.getPosition();
            int clen = len;
            if (end >= cpos && start < cpos + clen) {
                ISize point;
                String beforeS = null;
                String selectedS = null;
                if (start > cpos) {
                    beforeS = text.substring(0, start - cpos);
                    selectedS = end < cpos + clen - 1 ? text.substring(start - cpos, end - cpos) : text.substring(start - cpos);
                } else {
                    selectedS = end < cpos + clen - 1 ? text.substring(0, end - cpos) : text;
                }
                if (beforeS != null) {
                    point = gc.textExtent(beforeS);
                    this.rtmp.setLeft(this.rtmp.left() + point.getW());
                }
                if (end < cpos + clen - 1) {
                    point = gc.textExtent(selectedS);
                    this.rtmp.setWidth(point.getW());
                }
                SolidBrush sb = new SolidBrush(gc.getSystemColor(16));
                gc.setBrush((IBrush)sb);
                gc.fillRect((IRect)this.rtmp);
                sb.setRGBA(gc.getSystemColor(17));
                gc.setBrush((IBrush)sb);
                DrawUtilIGC.drawText((IGC)gc, (IRect)this.rtmp, (int)alignment, (String)selectedS);
            }
        }
        gc.setFont(oldfont);
        gc.setBrush(oldbrush);
    }

    protected void drawCellBorder(PainterEvent evt) {
        DCell dcell = (DCell)evt.cell.getItem();
        DRow row = (DRow)dcell.getParent();
        DTable table = (DTable)row.getParent();
        int border = (int)((float)table.getBorder() * evt.zoom);
        if (border > 0) {
            LineStylePen pen = new LineStylePen(evt.style.getFore());
            pen.setLineWidth(border);
            IPen open = evt.gc.setPen((IPen)pen);
            int mid = -(border / 2 + border % 2);
            evt.gc.drawRect(evt.paintArea.getX() + mid, evt.paintArea.getY() + mid, evt.paintArea.getW() - (mid + mid) - 1, evt.paintArea.getH() - (mid + mid) - 1);
            evt.gc.setPen(open);
        }
    }

    protected void drawCellBackground(PainterEvent evt) {
        IBrush obrush = evt.gc.setBrush((IBrush)new SolidBrush(evt.style.getBack()));
        evt.gc.fillRect(evt.paintArea.getX(), evt.paintArea.getY(), evt.paintArea.getW(), evt.paintArea.getH());
        this.drawWallpaper(evt, evt.paintArea.getX(), evt.paintArea.getY(), evt.paintArea.getW(), evt.paintArea.getH());
        evt.gc.setBrush(obrush);
    }

    public void drawCell(PainterEvent pe) {
        IDItem item = pe.cell.getItem();
        if (item == null) {
            return;
        }
        Rect r = Rect.Intersection((int)pe.abs_cell_x, (int)pe.abs_cell_y, (int)pe.cell.getWidth(), (int)pe.cell.getHeight(), (int)pe.clipArea.getX(), (int)pe.clipArea.getY(), (int)pe.clipArea.getW(), (int)pe.clipArea.getH());
        if (r == null) {
            return;
        }
        IGCDStyle saved_style = pe.style;
        try {
            pe.style = new IGCDStyle(item, pe.zoom);
            pe.cellClip = new Rect(r.getX(), r.getY(), r.getW(), r.getH());
            pe.cellClip.setX(pe.cellClip.getX() - pe.viewArea.getX());
            pe.cellClip.setY(pe.cellClip.getY() - pe.viewArea.getY());
            pe.gc.setClipping((IShape)new Rect(pe.clipArea.getX() - pe.viewArea.getX(), pe.clipArea.getY() - pe.viewArea.getY(), pe.clipArea.getW(), pe.clipArea.getH()));
            pe.drawFocus = pe.focus != null ? pe.focus.hasFocus(pe.cell) : false;
            pe.paintArea.setX(pe.abs_cell_x - pe.viewArea.getX());
            pe.paintArea.setY(pe.abs_cell_y - pe.viewArea.getY());
            pe.paintArea.setWidth(pe.cell.getWidth());
            pe.paintArea.setHeight(pe.cell.getHeight());
            pe.gc.setFont(pe.style.getFont());
            this.invokeDoMethod(item, this, pe);
        }
        finally {
            pe.style = saved_style;
        }
    }

    public void drawChildrenCell(PainterEvent pe) {
        TAbstractCell save_cell = pe.cell;
        if (save_cell == null || save_cell.getChild() == null) {
            return;
        }
        int clip_left = pe.clipArea.getX();
        int clip_right = clip_left + pe.clipArea.getW();
        int clip_top = pe.clipArea.getY();
        int clip_bottom = clip_top + pe.clipArea.getH();
        int save_x = pe.abs_cell_x;
        int save_y = pe.abs_cell_y;
        TAbstractCell I = save_cell.getChild();
        while (I != null) {
            int abs_I_left = save_x + I.getX();
            int abs_I_top = save_y + I.getY();
            int abs_I_right = abs_I_left + I.getWidth();
            int abs_I_bottom = abs_I_top + I.getHeight();
            if (clip_top <= abs_I_bottom && clip_bottom >= abs_I_top && clip_left <= abs_I_right && clip_right >= abs_I_left) {
                pe.abs_cell_x = abs_I_left;
                pe.abs_cell_y = abs_I_top;
                pe.cell = I;
                this.drawCell(pe);
            }
            I = I.getNext();
        }
        pe.abs_cell_x = save_x;
        pe.abs_cell_y = save_y;
        pe.cell = save_cell;
    }

    public void drawWallpaper(PainterEvent evt, int x, int y, int w, int h) {
        IDWallpaper bi;
        if (evt == null || evt.cell == null) {
            return;
        }
        IDItem item = evt.cell.getItem();
        if (item == null) {
            return;
        }
        IDWallpaper iDWallpaper = bi = item.getStyle() != null ? item.getStyle().getWallpaper() : null;
        if (bi == null) {
            return;
        }
        IImage image = evt.iimgProvider.getImage(bi.getName());
        if (image != null) {
            DrawUtilIGC.drawImage((IGC)evt.gc, (IImage)image, (int)x, (int)y, (int)w, (int)h, (float)evt.zoom, (int)bi.getEffect());
        }
    }

    public void doMethod(DFolder _folder, DExtensible _ext, Object _arg) {
        TAbstractCell c;
        if (!(_arg instanceof PainterEvent)) {
            return;
        }
        PainterEvent e = (PainterEvent)_arg;
        TCellFolder cell = (TCellFolder)e.cell;
        boolean l2r = !cell.isReversed();
        ISymbol symbol = null;
        DFolderModel model = _folder.getFolderModel();
        if (model == null) {
            model = DFolderModel.GetDefault();
        }
        IDColor fore = null;
        IDColor back = null;
        if (_folder.isOpen()) {
            symbol = model.getOpenedSymbol(l2r);
            fore = model.getOpenedForeColor();
            back = model.getOpenedBackColor();
            if (symbol == null) {
                symbol = DSymbolRegistry.GetDown();
            }
        } else {
            symbol = model.getClosedSymbol(l2r);
            fore = model.getClosedForeColor();
            back = model.getClosedBackColor();
            if (symbol == null) {
                symbol = l2r ? DSymbolRegistry.GetRight() : DSymbolRegistry.GetLeft();
            }
        }
        IPen old_pen = fore != null ? e.gc.setPen((IPen)new LineStylePen(RGBA.Get((int)fore.getRed(), (int)fore.getGreen(), (int)fore.getBlue()))) : e.gc.setPen((IPen)new LineStylePen(255));
        IBrush old_brush = null;
        old_brush = back != null ? e.gc.setBrush((IBrush)new SolidBrush(RGBA.Get((int)back.getRed(), (int)back.getGreen(), (int)back.getBlue()))) : e.gc.setBrush((IBrush)new SolidBrush(IGCDStyle.GetBackColor((IDItem)_folder)));
        Rect r = new Rect((IRect)cell.getSymbolCell());
        r.moveBy(e.paintArea.x(), e.paintArea.y());
        symbol.draw(e.gc, (IRect)r);
        e.gc.setPen(old_pen);
        if (back != null) {
            e.gc.setBrush(old_brush);
        }
        SWTPainter painter = (SWTPainter)_ext;
        PainterEvent ne = new PainterEvent(e);
        Iterator I = cell.getHeaderCellIterator();
        if (I != null) {
            while (I.hasNext()) {
                c = (TAbstractCell)I.next();
                ne.abs_cell_x = e.abs_cell_x + c.getX();
                ne.abs_cell_y = e.abs_cell_y + c.getY();
                ne.cell = c;
                painter.drawCell(ne);
            }
        }
        if ((I = cell.getBodyCellIterator()) != null) {
            while (I.hasNext()) {
                c = (TAbstractCell)I.next();
                ne.abs_cell_x = e.abs_cell_x + c.getX();
                ne.abs_cell_y = e.abs_cell_y + c.getY();
                ne.cell = c;
                painter.drawCell(ne);
            }
        }
    }

    public void doMethod(DBorder _border, DExtensible _ext, Object _arg) {
        if (!(_arg instanceof PainterEvent)) {
            return;
        }
        PainterEvent e = (PainterEvent)_arg;
        int c = IGCDStyle.GetBackColor((IDItem)_border);
        SolidBrush brush = new SolidBrush();
        brush.setRGBA(c);
        IBrush oldb = e.gc.setBrush((IBrush)brush);
        c = IGCDStyle.GetForeColor((IDItem)_border);
        LineStylePen pen = new LineStylePen();
        pen.setRGBA(c);
        IPen oldp = e.gc.setPen((IPen)pen);
        TCellBorder cell = (TCellBorder)e.cell;
        boolean reversed = cell.isReversed();
        int ss = _border.getShadowDepth();
        if (_border.isShadowType(0)) {
            ss = 0;
        }
        int cx = e.paintArea.x() + (reversed ? ss - 1 : 0);
        int cy = e.paintArea.y();
        int gw = cell.getW() - ss;
        int gh = cell.getH() - ss;
        if (_border.isShadowType(3)) {
            cx += ss - (reversed ? ss - 1 : 0);
            cy += ss;
            gh -= ss;
            gw -= ss;
        }
        e.gc.fillRect(cx, cy, gw, gh);
        int line_type = _border.getLineType();
        int i = 0;
        int m = 1;
        while (i < 8) {
            if ((m & line_type) != 0) {
                e.gc.drawRect(cx + i, cy + i, gw - 2 * i, gh - 2 * i);
            }
            ++i;
            m <<= 1;
        }
        if (ss == 0 || _border.isShadowType(0)) {
            e.gc.setBrush(oldb);
            e.gc.setPen(oldp);
            ((SWTPainter)_ext).drawChildrenCell(e);
            return;
        }
        int sc = DColor.RGBA((IDColor)_border.getShadowColor(), (int)-2139062017);
        switch (_border.getShadowType()) {
            case 0: {
                break;
            }
            case 1: {
                brush.setRGBA(sc);
                e.gc.setBrush((IBrush)brush);
                int h = cell.getH() - ss - ss + 1;
                if (reversed) {
                    if (h > 0) {
                        e.gc.fillRect(cx - ss + 1, cy + ss, ss - 1, h);
                    }
                    if (gw <= 0) break;
                    e.gc.fillRect(cx - ss + 1, cy + cell.getH() - ss + 1, gw, ss - 1);
                    break;
                }
                if (h > 0) {
                    e.gc.fillRect(cx + gw + 1, cy + ss, ss - 1, h);
                }
                if (gw <= 0) break;
                e.gc.fillRect(cx + ss, cy + cell.getH() - ss + 1, gw, ss - 1);
                break;
            }
            case 2: {
                int bk = IGCDStyle.GetBackColor((IDItem)_border.getParent());
                if (bk == sc) break;
                GradientGenerator g = new GradientGenerator(sc, bk);
                int yb = cy + gh + 1;
                if (reversed) {
                    FullGradientBrush b = new FullGradientBrush(cx, cx - ss, (IGradientGenerator)g, false);
                    e.gc.setBrush((IBrush)b);
                    e.gc.fillRect(cx - ss, cy + ss, ss - 1, gh - ss + 1);
                    b.setPoints(0, yb, 0, cy + cell.getH());
                    e.gc.setBrush((IBrush)b);
                    e.gc.fillRect(cx, yb, gw - ss, ss - 1);
                    b.setPoints(cx, yb, cx, cy + cell.getH());
                    b.setType(1);
                    e.gc.fillRect(cx - ss, yb, ss - 1, ss - 1);
                    b.setPoints(cx, cy + ss, cx - ss, cy + ss);
                    e.gc.fillRect(cx - ss, cy, ss - 1, ss - 1);
                    int x = cx + gw - ss + 1;
                    b.setPoints(x, yb, x, cy + cell.getH());
                    e.gc.fillRect(x, yb, ss - 1, ss - 1);
                    break;
                }
                int xr = cx + gw + 1;
                FullGradientBrush b = new FullGradientBrush(cx + gw + 1, cx + gw + ss, (IGradientGenerator)g, false);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xr, cy + ss, ss - 1, gh - ss + 1);
                b.setPoints(0, yb, 0, cy + cell.getH());
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(cx + ss, yb, gw - ss, ss - 1);
                b.setPoints(xr, yb, cx + gw + 1, cy + cell.getH());
                b.setType(1);
                e.gc.fillRect(xr, yb, ss - 1, ss - 1);
                b.setPoints(xr, cy + ss, cx + gw + ss, cy + ss);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xr, cy, ss - 1, ss - 1);
                b.setPoints(cx + ss, yb, cx + ss, cy + cell.getH());
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(cx, yb, ss, ss - 1);
                break;
            }
            case 3: {
                int bk = IGCDStyle.GetBackColor((IDItem)_border.getParent());
                if (bk == sc) break;
                GradientGenerator g = new GradientGenerator(sc, bk);
                FullGradientBrush b = new FullGradientBrush((IGradientGenerator)g, 0);
                int yt = cy - ss;
                int yb = cy + gh + 1;
                int ybb = yb + ss - 1;
                int xl = cx - ss;
                int xr = cx + gw + 1;
                int xrr = xr + ss - 1;
                b.setPoints(cx, cy, cx, yt);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(cx, yt, gw, ss - 1);
                b.setPoints(xr, cy, xrr, cy);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xr, cy, ss - 1, gh);
                b.setPoints(cx, yb, cx, ybb);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(cx, yb, gw, ss - 1);
                b.setPoints(cx, cy, xl, cy);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xl, cy, ss - 1, gh);
                b.setType(1);
                b.setPoints(cx, cy, xl, cy);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xl, yt, ss - 1, ss - 1);
                b.setPoints(xr, cy, xrr, cy);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xr, yt, ss - 1, ss - 1);
                b.setPoints(xr, yb, xrr, yb);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xr, yb, ss - 1, ss - 1);
                b.setPoints(cx, yb, xl, yb);
                e.gc.setBrush((IBrush)b);
                e.gc.fillRect(xl, yb, ss - 1, ss - 1);
            }
        }
        e.gc.setBrush(oldb);
        e.gc.setPen(oldp);
        SWTPainter painter = (SWTPainter)_ext;
        painter.drawChildrenCell(e);
    }

    public static class PainterEvent {
        public IGC gc;
        public float zoom;
        public IDIImageProvider iimgProvider;
        public TAbstractCell cell;
        public int abs_cell_x;
        public int abs_cell_y;
        public Rect paintArea;
        public Rect cellClip;
        public Rect clipArea;
        public IGCDStyle style;
        public Rect viewArea;
        public boolean drawSelection;
        public TCellFocusMark focus;
        public boolean drawFocus;
        public int start;
        public int end;

        public PainterEvent(IGC _gc, TAbstractCell _cell, float _zoom, IDIImageProvider iimgp, TCellFocusMark _focus, boolean _drawFocus, boolean _drawSelection, int _start, int _end, int _abs_cell_x, int _abs_cell_y, int vax, int vay, int vaw, int vah, int clx, int cly, int clw, int clh) {
            this.gc = _gc;
            this.cell = _cell;
            this.zoom = _zoom;
            this.iimgProvider = iimgp;
            this.drawSelection = _drawSelection;
            this.focus = _focus;
            this.drawFocus = _drawFocus;
            this.start = _start;
            this.end = _end;
            this.abs_cell_x = _abs_cell_x;
            this.abs_cell_y = _abs_cell_y;
            this.viewArea = new Rect(vax, vay, vaw, vah);
            this.clipArea = new Rect(clx, cly, clw, clh);
            this.paintArea = new Rect(0, 0, 0, 0);
            this.cellClip = new Rect(0, 0, 0, 0);
        }

        public PainterEvent(PainterEvent e) {
            this.gc = e.gc;
            this.cell = e.cell;
            this.zoom = e.zoom;
            this.drawSelection = e.drawSelection;
            this.focus = e.focus;
            this.drawFocus = e.drawFocus;
            this.start = e.start;
            this.end = e.end;
            this.abs_cell_x = e.abs_cell_x;
            this.abs_cell_y = e.abs_cell_y;
            this.viewArea = new Rect(e.viewArea.getX(), e.viewArea.getY(), e.viewArea.getW(), e.viewArea.getH());
            this.clipArea = new Rect(e.clipArea.getX(), e.clipArea.getY(), e.clipArea.getW(), e.clipArea.getH());
            this.paintArea = new Rect(e.paintArea.getX(), e.paintArea.getY(), e.paintArea.getW(), e.paintArea.getH());
            this.cellClip = new Rect(e.cellClip.getX(), e.cellClip.getY(), e.cellClip.getW(), e.cellClip.getH());
            this.iimgProvider = e.iimgProvider;
        }
    }
}

