/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DAbstractParagraph;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDBasicItem;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.drawutil.internal.CursorUtil;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTPainter;
import org.eclipse.tptp.platform.report.drivers.ui.internal.ViewerRegistry;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILineLayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IMarginLayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellData;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFocusMark;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFolder;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellIterator;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellSymbol;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellUtil;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTGC;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.IRenderLocation;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.SimpleProgressMonitor;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.ScrollView;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.ToolTipRedrawer;

public class SWTViewer
extends ScrollView {
    private String name = "";
    private ViewerRegistry registry = new ViewerRegistry();
    private SWTPainter defaultPainterEventHandler = new SWTPainter();
    private MouseEventHandler defaultMouseEventHandler = new MouseEventHandler();
    private KeyEventHandler defaultKeyEventHandler = new KeyEventHandler();
    private Show mode = new Show();
    private boolean double_buffer = true;
    private IDItem contentItem;
    private TAbstractCellContainer contentCell;
    private int top;
    private int bottom;
    private int left;
    private int right;
    private float zoom = 1.0f;
    private boolean reversed = false;
    private boolean maintainRatio = false;
    private int lastPosition;
    private TCellFocusMark focus;
    private IDLink prevlink;
    private Selection defaultSelection;
    private Cursor handcursor_;
    private Cursor graphicmovingcursor_;
    private boolean showExternalLinkTooltip = false;
    private static String[] asc_graphic_moving_cursor_ = new String[]{"                 n              ", "                n.n             ", "               n...n            ", "              n.....n           ", "             n.......n          ", "            nnnn...nnnn         ", "               n...n            ", "              n...n             ", "     n        n...n      n      ", "    nn       n...n       nn     ", "   n.n       n...n       n.n    ", "  n..nn      n...n      nn..n   ", " n.....nn     n.n     nn.....n  ", "n........nnn   n   nnn........n ", " n..........n nnn n..........n  ", "  n..nn......nnnnn......nn..n   ", "   n.n nn...n nnn n...nn n.n    ", "    nn   nnn   n   nnn   nn     ", "     n        n.n        n      ", "             n...n              ", "             n...n              ", "             n...n              ", "              n...n             ", "              n...n             ", "               n...n            ", "            nnnn...nnnn         ", "             n.......n          ", "              n.....n           ", "               n...n            ", "                n.n             ", "                 n              ", "                                "};
    private DefaultProperties defaultProperties;
    public Signal selectionChanged = new Signal("selectionChanged(org.eclipse.tptp.platform.report.ui.internal.SWTViewer)");
    public Signal linkHighlighted = new Signal("linkHighlighted(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
    public Signal linkUnhighlighted = new Signal("linkUnhighlighted(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
    public Signal linkActivated = new Signal("linkActivated(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
    public Signal linkUnresolved = new Signal("linkError(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
    private IDIImageProvider iimage_provider;
    private IDProgressMonitor progressMonitor = new ViewerProgressMonitor(this);
    private Timer tooltiptimer = null;
    private TimerTask tasquette = null;
    boolean runned_ = false;
    private ChildViewer childViewer;
    private ToolTipRedrawer tooltip = null;
    private ViewerMouseEvent me = new ViewerMouseEvent();
    private TAbstractCell flyingCell;
    private ViewerKeyEvent ke = new ViewerKeyEvent();
    private TAbstractCell prevFlyingCell;
    private Rect priv_locatePointInGraphic_rect = new Rect();

    private Cursor handCursor() {
        if (this.handcursor_ == null) {
            this.handcursor_ = new Cursor((Device)this.getDisplay(), 21);
        }
        return this.handcursor_;
    }

    private Cursor graphicMovingCursor() {
        if (this.graphicmovingcursor_ == null) {
            this.graphicmovingcursor_ = CursorUtil.CursorFromString((String[])asc_graphic_moving_cursor_, (int)15, (int)15);
        }
        return this.graphicmovingcursor_;
    }

    public SWTViewer(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.defaultProperties = new DefaultProperties();
        this.iimage_provider = new SWTIImageProvider((Device)this.getDisplay());
        this.tooltip = new ToolTipRedrawer((Control)this);
        this.setOverviewEnabled(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTViewer v = (SWTViewer)e.widget;
                v.dispose();
            }
        });
        this.getViewControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: {
                        SWTViewer.this.nextFocusable();
                        SWTViewer.this.startAccessibility();
                        break;
                    }
                    case 8: {
                        SWTViewer.this.previousFocusable();
                        SWTViewer.this.startAccessibility();
                    }
                }
                if (SWTViewer.this.focus == null) {
                    e.doit = true;
                }
            }
        });
        this.getViewControl().getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    default: {
                        e.detail = 44;
                    }
                }
            }

            public void getValue(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.result = null;
                        break;
                    }
                    case 0: {
                        SWTViewer v2 = SWTViewer.this.getChildViewer();
                        if (v2 == null) break;
                        e.result = v2.getContentText();
                        break;
                    }
                    default: {
                        e.result = SWTViewer.this.focus != null ? SWTViewer.this.focus.getLinkText() : null;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                switch (e.childID) {
                    case -1: {
                        e.detail |= 4;
                        break;
                    }
                    case 0: {
                        e.detail |= 0x200004;
                        break;
                    }
                    default: {
                        e.detail |= 4;
                    }
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                e.childID = SWTViewer.this.getChildViewer() != null ? 1 : (SWTViewer.this.focus != null ? SWTViewer.this.focus.hashCode() : -2);
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SWTViewer.this.getViewControl().setFocus();
                SWTViewer.this.startAccessibility();
                if (SWTViewer.this.focus == null) {
                    SWTViewer.this.nextFocusable();
                    SWTViewer.this.startAccessibility();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public IDIImageProvider getImageProvider() {
        return this.iimage_provider;
    }

    public void setImageProvider(IDIImageProvider img_p) {
        this.iimage_provider = img_p;
    }

    private void initialise() {
        this.resetDefaultSelection();
        this.setContentsPos(0, 0);
    }

    public void dump() {
        if (this.contentCell != null) {
            this.contentCell.dump(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.defaultSelection = null;
        if (this.contentCell != null) {
            this.contentCell.dispose();
            this.contentCell = null;
        }
        if (this.handcursor_ != null) {
            this.handcursor_.dispose();
        }
        if (this.graphicmovingcursor_ != null) {
            this.graphicmovingcursor_.dispose();
        }
        this.closeChildViewer();
        SWTViewer sWTViewer = this;
        synchronized (sWTViewer) {
            if (this.tooltiptimer != null) {
                this.tooltiptimer.cancel();
                this.tooltiptimer = null;
            }
        }
        this.iimage_provider.dispose();
    }

    public long getToolipTimerDelay() {
        return this.defaultProperties.toolipTimerDelay_;
    }

    public void setToolipTimerDelay(long toolipTimerDelay) {
        this.defaultProperties.toolipTimerDelay_ = toolipTimerDelay;
    }

    public void highlightLink(IDLink link, org.eclipse.swt.graphics.Point p) {
        Object[] param1 = new Object[]{link.getTarget(), link};
        this.linkHighlighted.emit(param1);
        if (DLinkUtil.isPopupLink((IDLink)link) && "jscrib-tooltip".equals(DLinkUtil.getMethod((IDLink)link))) {
            IDItem i = this.resolveLink(link);
            if (i != null) {
                this.showTooltip(i, p);
            } else {
                this.linkUnresolved.emit(new Object[]{link.getTarget(), link});
            }
        }
    }

    public void unhighlightLink(IDLink link) {
        if (DLinkUtil.isPopupLink((IDLink)link) && "jscrib-tooltip".equals(DLinkUtil.getMethod((IDLink)link))) {
            this.hideTooltip();
        }
        Object[] param2 = new Object[]{link.getTarget(), link};
        this.linkUnhighlighted.emit(param2);
    }

    public void activateLink(IDLink link, org.eclipse.swt.graphics.Point p) {
        TAbstractCell c = this.flyingCell;
        while (c != null) {
            if (c instanceof TCellFocusMark && ((TCellFocusMark)c).hasFocus(this.flyingCell)) {
                this.setFocus((TCellFocusMark)c);
                break;
            }
            c = c.getPrevious();
        }
        if (DLinkUtil.isInternalLink((IDLink)link)) {
            String method = DLinkUtil.getMethod((IDLink)link);
            if (DLinkUtil.isPopupLink((IDLink)link)) {
                IDItem i = this.resolveLink(link);
                if (i != null) {
                    this.openNewViewer(i, p, method);
                } else {
                    this.linkUnresolved.emit(new Object[]{link.getTarget(), link});
                }
            } else {
                DLinkResolver r = new DLinkResolver(link);
                r.resolve(null);
                IDTaggedItem i = r.getTaggedItem();
                IDItem rib = r.getItemToRebuild();
                if (rib != null) {
                    if (rib.getRoot() != this.getContentItem()) {
                        this.setContent(rib.getRoot());
                    } else {
                        this.refresh();
                    }
                }
                if (i != null) {
                    if (i.getRoot() != this.getContentItem()) {
                        this.setContent(i.getRoot());
                    }
                    this.scrollTo(i.getTag());
                } else if (rib == null) {
                    Object[] param = new Object[]{link.getTarget(), link};
                    this.linkUnresolved.emit(param);
                    return;
                }
            }
        } else {
            Object[] param = new Object[]{link.getTarget(), link};
            this.linkActivated.emit(param);
        }
    }

    private TimerTask getTooltipTask(IDItem i, org.eclipse.swt.graphics.Point pos) {
        IDItem locitem = i;
        org.eclipse.swt.graphics.Point locpos = pos;
        return new TimerTask(locitem, locpos){
            boolean cancelled_ = false;
            IDItem item_;
            org.eclipse.swt.graphics.Point pos_;
            {
                this.item_ = iDItem;
                this.pos_ = point;
            }

            public boolean cancel() {
                this.cancelled_ = super.cancel();
                return this.cancelled_;
            }

            public void run() {
                if (this.cancelled_) {
                    return;
                }
                if (SWTViewer.this.isDisposed()) {
                    this.cancel();
                    return;
                }
                SWTViewer.this.runned_ = true;
                if (!Display.getDefault().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (pos_ == null) {
                                pos_ = SWTViewer.this.getDisplay().getCursorLocation();
                            }
                            SWTViewer.this.openNewViewer(item_, pos_, "jscrib-tooltip");
                        }
                    });
                }
            }
        };
    }

    public void showTooltip(IDItem content, org.eclipse.swt.graphics.Point pos) {
        this.tasquette = this.getTooltipTask(content, pos);
        if (this.tooltiptimer == null) {
            this.tooltiptimer = new Timer(true);
        }
        this.tooltiptimer.schedule(this.tasquette, 100L);
        this.runned_ = false;
    }

    public void hideTooltip() {
        if (this.tasquette != null) {
            this.tasquette.cancel();
            this.tasquette = null;
        }
        this.closeChildViewer();
        this.runned_ = false;
    }

    private IDItem resolveLink(IDLink link) {
        DLinkResolver r = new DLinkResolver(link);
        r.resolve(null);
        return r.getTaggedItem();
    }

    protected void closeChildViewer() {
        if (this.childViewer == null) {
            return;
        }
        if (!this.childViewer.shell.isDisposed()) {
            this.childViewer.shell.dispose();
        }
        this.childViewer = null;
    }

    protected SWTViewer getChildViewer() {
        return this.childViewer != null ? this.childViewer.viewer : null;
    }

    protected void openNewViewer(IDItem content, org.eclipse.swt.graphics.Point pos, String method) {
        Color back;
        Color fore;
        this.closeChildViewer();
        if (content == null) {
            return;
        }
        if (!("jscrib-tooltip".equals(method) || "jscrib-popup".equals(method) || "jscrib-detach".equals(method))) {
            return;
        }
        boolean is_win = "jscrib-detach".equals(method);
        Shell shell = null;
        Display disp = this.getDisplay();
        if (is_win) {
            shell = new Shell(disp, 80);
            shell.setText(this.getShell().getText());
            fore = this.getForeground();
            back = this.getBackground();
        } else {
            shell = new Shell(this.getShell(), 16384);
            fore = disp.getSystemColor(28);
            back = disp.getSystemColor(29);
        }
        shell.setLayout((Layout)new FillLayout());
        shell.setForeground(fore);
        shell.setBackground(back);
        SWTViewer popupView = new SWTViewer((Composite)shell, 0);
        if (!is_win) {
            this.childViewer = new ChildViewer(shell, popupView, method);
        }
        popupView.setForeground(fore);
        popupView.setBackground(back);
        popupView.setZoom(this.zoom, this.maintainRatio);
        popupView.selectionChanged = this.selectionChanged;
        popupView.linkHighlighted = this.linkHighlighted;
        popupView.linkUnhighlighted = this.linkUnhighlighted;
        popupView.linkActivated = this.linkActivated;
        popupView.setShowExternalLinkTooltip(this.isShowExternalLinkTooltip());
        GC ngc = new GC((Drawable)this);
        SWTGC swtgc = new SWTGC((Device)popupView.getDisplay(), ngc);
        int al = content instanceof DAbstractParagraph ? ((DAbstractParagraph)content).getAlignment() : 1;
        TCellParagraph popupCell = new TCellParagraph(content, null, al);
        popupCell.fillContent(content, (IGC)swtgc, this.getImageProvider(), this.getProgressMonitor(), new DTitleLevel(), new DListLevel(), false);
        popupCell.computeSize(-1, -1, this.getZoom(), (IGC)swtgc, this.getProgressMonitor());
        popupView.lastPosition = popupCell.layout(this.getZoom(), 0, this.getProgressMonitor());
        ngc.dispose();
        int wdoc = 100;
        int hdoc = 100;
        wdoc = popupCell.getWidth();
        hdoc = popupCell.getHeight();
        Rectangle rr = popupView.computeTrim(0, 0, wdoc, hdoc);
        Rectangle tri2 = shell.computeTrim(0, 0, rr.width, rr.height);
        int sw = tri2.width - tri2.x;
        int sh = tri2.height - tri2.y;
        if (pos == null) {
            pos = this.getDisplay().getCursorLocation();
        }
        int x = pos.x;
        int y = pos.y;
        if (!is_win) {
            y -= tri2.height;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        rr = disp.getBounds();
        if (x + sw > rr.width && (x = rr.width - sw) < 0) {
            sw = rr.width;
        }
        if (y + sh > rr.height && (y = rr.height - sh) < 0) {
            sh = rr.height;
        }
        shell.setBounds(x, y, sw, sh);
        popupView.setContent(popupCell);
        shell.setVisible(true);
        this.startAccessibility();
    }

    public int getViewMode() {
        return this.mode.mode();
    }

    public void setViewMode(int aMode) {
        this.mode.mode(aMode);
    }

    public IDItem getContentItem() {
        return this.contentItem;
    }

    public void setContent(IDItem rootItem) {
        this.contentItem = rootItem instanceof IDDocument ? ((IDDocument)rootItem).getDocument() : rootItem;
        this.initialise();
        this.refresh();
    }

    public void setDocument(IDDocument document) {
        this.setContent((IDItem)document);
    }

    protected void setContent(TAbstractCellContainer c) {
        if (this.contentCell != null) {
            this.contentCell.dispose();
        }
        this.contentCell = c;
        this.contentItem = c.getItem();
        this.resizeContents(c.getWidth(), c.getHeight());
    }

    protected void setContent(TCellContainer c) {
        this.setContent((TAbstractCellContainer)c);
    }

    public String getSelectedText() {
        if (this.contentCell == null || !this.getDefaultSelection().isValid()) {
            return null;
        }
        org.eclipse.swt.graphics.Point pt = this.getDefaultSelection().getRange();
        return TCellUtil.GetTextRange(this.contentCell, pt.x, pt.y - 1);
    }

    protected void rebuildDoc(boolean contentChanged) {
        this.flyingCell = null;
        this.prevFlyingCell = null;
        Rectangle area = this.getClientArea();
        this.closeChildViewer();
        GC gc = new GC((Drawable)this);
        SWTGC swtgc = new SWTGC((Device)this.getDisplay(), gc);
        IDProgressMonitor monitor = this.getProgressMonitor();
        monitor.beginTask("Please wait", 0);
        if (contentChanged) {
            if (this.contentCell != null) {
                this.contentCell.dispose();
            }
            int al = this.contentItem instanceof DAbstractParagraph ? ((DAbstractParagraph)this.contentItem).getAlignment() : 1;
            this.contentCell = new TCellParagraph(this.contentItem, null, al);
            if (this.contentCell.getLayout() instanceof IMarginLayout) {
                ((IMarginLayout)this.contentCell.getLayout()).setMargin(this.left, this.right, this.top, this.bottom);
            }
            this.contentCell.getLayout().setReversed(this.reversed);
            if (this.contentItem != null) {
                monitor.setTotalWorks(1);
                this.contentCell.fillContent(this.contentItem, (IGC)swtgc, this.getImageProvider(), monitor, new DTitleLevel(), new DListLevel(), false);
                monitor.worked(monitor.getWorkCount() + 1);
            }
        }
        int w = this.maintainRatio ? (int)((float)area.width * this.zoom) : area.width;
        if (this.contentCell.getLayout() instanceof IMarginLayout) {
            ((IMarginLayout)this.contentCell.getLayout()).setMargin(this.left, this.right, this.top, this.bottom);
        }
        monitor.setTotalWorks(monitor.getTotalWorks() + 2);
        this.contentCell.computeSize(w, -1, this.getZoom(), (IGC)swtgc, monitor);
        monitor.worked(monitor.getWorkCount() + 1);
        this.lastPosition = this.contentCell.layout(this.getZoom(), 0, monitor);
        monitor.worked(monitor.getWorkCount() + 1);
        monitor.done();
        gc.dispose();
        this.computeContentsSize();
        this.focus = null;
    }

    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        this.rebuildDoc(true);
        this.redraw();
    }

    protected void viewResized() {
        if (this.contentCell == null) {
            return;
        }
        int curr_width = this.getClientArea().width;
        int need_width = this.contentCell.getWidth();
        if (curr_width != need_width && !this.contentCell.isFixedSize()) {
            this.rebuildDoc(false);
            this.redraw();
        }
    }

    protected IDLink getLinkFromCell(ViewerMouseEvent evt) {
        int cx = 0;
        int cy = 0;
        TAbstractCell c = evt.cell;
        while (c != null) {
            cx += c.getX();
            cy += c.getY();
            c = c.getParent();
        }
        int px = evt.event.x - cx;
        int py = evt.event.y - cy;
        TAbstractCell cell = evt.cell;
        IDItem item = cell.getItem();
        IDLink link = null;
        if (item instanceof DGraphic) {
            link = this.extractRenderableLink(this.locatePointInRenderable(px, py, (IDRenderable)((DGraphic)item), cell));
        }
        if (link == null) {
            link = (IDLink)this.hasParent(item, IDLink.class);
        }
        return link;
    }

    private IDItem hasParent(IDItem item, Class Wanted) {
        if (item == null) {
            return null;
        }
        IDItem iparent = item.getParent();
        while (iparent != null) {
            if (Wanted.isInstance(iparent)) {
                return iparent;
            }
            iparent = iparent.getParent();
        }
        return null;
    }

    protected void keyPressedEvent(KeyEvent _e) {
        try {
            this.ke.handled = false;
            boolean ctrl = (_e.stateMask & 0x40000) != 0;
            switch (_e.keyCode) {
                case 99: {
                    if (!ctrl) break;
                    this.copy();
                    break;
                }
                case 97: {
                    if (!ctrl) break;
                    this.selectAll();
                    break;
                }
            }
            if (this.focus == null) {
                return;
            }
            this.ke.viewer = this;
            this.ke.cell = this.focus;
            this.ke.event = _e;
            this.ke.type = 1;
            this.ke.tooltip = null;
            this.defaultKeyEventHandler.invokeDoMethod(this.focus.getItem(), this.defaultKeyEventHandler, this.ke);
        }
        finally {
            if (!this.ke.handled) {
                super.keyPressedEvent(_e);
            }
            this.tooltip.showToolTip(this.me.tooltip);
            this.setFocus();
        }
    }

    protected void keyReleasedEvent(KeyEvent _e) {
        try {
            this.ke.handled = false;
            if (this.focus == null) {
                return;
            }
            this.ke.viewer = this;
            this.ke.cell = this.focus;
            this.ke.event = _e;
            this.ke.type = 2;
            this.ke.tooltip = null;
            this.defaultKeyEventHandler.invokeDoMethod(this.focus.getItem(), this.defaultKeyEventHandler, this.ke);
        }
        finally {
            if (!this.ke.handled) {
                super.keyReleasedEvent(_e);
            }
            this.tooltip.showToolTip(this.me.tooltip);
            this.setFocus();
        }
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent e) {
        try {
            if (this.flyingCell == null) {
                return;
            }
            this.me.event = e;
            this.me.type = 8;
            this.me.viewer = this;
            this.me.handled = false;
            this.me.cell = this.flyingCell;
            this.me.cursor = null;
            this.me.tooltip = null;
            this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
        }
        finally {
            if (!this.me.handled) {
                super.contentsMouseDownEvent(e);
            }
            this.setCursor(this.me.cursor);
            this.tooltip.showToolTip(this.me.tooltip);
            this.setFocus();
        }
    }

    protected void contentsMouseDownEvent(MouseEvent e) {
        try {
            if (this.flyingCell == null) {
                this.flyingCell = TCellUtil.MapPointToCell(this.contentCell, (IPoint)new Point(e.x, e.y));
                if (this.flyingCell == null) {
                    return;
                }
            }
            this.me.event = e;
            this.me.type = 3;
            this.me.viewer = this;
            this.me.handled = false;
            this.me.cell = this.flyingCell;
            this.me.cursor = null;
            this.me.tooltip = null;
            this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
            if (this.me.invalidate) {
                this.refresh();
            }
        }
        finally {
            if (!this.me.handled) {
                this.closeChildViewer();
                super.contentsMouseDownEvent(e);
            }
            this.setCursor(this.me.cursor);
            this.tooltip.showToolTip(this.me.tooltip);
            this.setFocus();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void contentsMouseMoveEvent(MouseEvent e) {
        this.flyingCell = null;
        try {
            if (this.contentCell == null) {
                return;
            }
            this.flyingCell = TCellUtil.MapPointToCell(this.contentCell, (IPoint)new Point(e.x, e.y));
            if (this.flyingCell == null) {
                this.tooltip.hideToolTip();
                return;
            }
            if (this.flyingCell != this.prevFlyingCell) {
                if (this.prevFlyingCell != null) {
                    this.me.event = e;
                    this.me.type = 7;
                    this.me.viewer = this;
                    this.me.handled = false;
                    this.me.cell = this.prevFlyingCell;
                    this.me.cursor = null;
                    this.me.tooltip = null;
                    this.defaultMouseEventHandler.invokeDoMethod(this.prevFlyingCell.getItem(), this.defaultMouseEventHandler, this.me);
                }
                if (this.flyingCell.getItem() == null) {
                    this.tooltip.hideToolTip();
                    return;
                }
                this.me.event = e;
                this.me.type = 6;
                this.me.viewer = this;
                this.me.handled = false;
                this.me.cell = this.flyingCell;
                this.me.cursor = null;
                this.me.tooltip = null;
                this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
                this.prevFlyingCell = this.flyingCell;
                return;
            }
            this.prevFlyingCell = this.flyingCell;
            this.me.event = e;
            this.me.type = 5;
            this.me.viewer = this;
            this.me.handled = false;
            this.me.cell = this.flyingCell;
            this.me.cursor = null;
            this.me.tooltip = null;
            this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
            if (!this.getDefaultSelection().isValid() || (e.stateMask & 0x80000) == 0 && e.button != 1) return;
            int dy = this.contentsToViewY(e.y);
            if (dy < 0) {
                this.scrollBy(0, dy);
            } else {
                dy = this.getVisibleHeight() - dy;
                if (dy < 0) {
                    this.scrollBy(0, -dy);
                }
            }
            this.me.handled = true;
            return;
        }
        finally {
            boolean cfr_ignored_0 = this.me.handled;
            this.setCursor(this.me.cursor);
            this.tooltip.showToolTip(this.me.tooltip);
        }
    }

    protected void contentsMouseUpEvent(MouseEvent e) {
        if (this.flyingCell == null) {
            return;
        }
        this.me.event = e;
        this.me.type = 4;
        this.me.viewer = this;
        this.me.handled = false;
        this.me.cell = this.flyingCell;
        this.me.cursor = null;
        this.me.tooltip = null;
        this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
        if (!this.me.handled) {
            super.contentsMouseUpEvent(e);
        }
    }

    protected void contentsMouseExit(MouseEvent e) {
        if (e.x < 0 || e.y < 0 || e.x >= this.getContentsWidth() || e.y >= this.getContentsHeight()) {
            if (this.flyingCell == null) {
                return;
            }
            this.me.event = e;
            this.me.type = 7;
            this.me.viewer = this;
            this.me.handled = false;
            this.me.cell = this.flyingCell;
            this.me.cursor = null;
            this.me.tooltip = null;
            this.defaultMouseEventHandler.invokeDoMethod(this.flyingCell.getItem(), this.defaultMouseEventHandler, this.me);
            this.flyingCell = null;
            this.prevFlyingCell = null;
        }
        this.tooltip.hideToolTip();
    }

    protected void move3DView(ViewerMouseEvent e, DGraphic gph) {
        if (gph == null) {
            return;
        }
        float phi = gph.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3f);
        float theta = gph.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2f);
        int dx = e.event.x - this.defaultProperties.moveGraphicx_;
        int dy = e.event.y - this.defaultProperties.moveGraphicy_;
        gph.getProperties().store("P_XYZ_PHI.DGraphic.core.jscrib", phi += 0.02f * (float)dy);
        gph.getProperties().store("P_XYZ_THETA.DGraphic.core.jscrib", theta -= 0.02f * (float)dx);
        this.defaultProperties.moveGraphicx_ = e.event.x;
        this.defaultProperties.moveGraphicy_ = e.event.y;
        this.redraw(e.cell);
    }

    public void redraw(TAbstractCell e) {
        boolean hs = this.getDefaultSelection().isValid();
        Rectangle area = this.getClientArea();
        Rect interarea = Rect.Intersection((int)area.x, (int)area.y, (int)area.width, (int)area.height, (int)0, (int)0, (int)e.getWidth(), (int)e.getHeight());
        if (interarea == null) {
            return;
        }
        Image dbuffer = new Image((Device)this.getDisplay(), e.getWidth(), e.getHeight());
        GC gcim = new GC((Drawable)dbuffer);
        gcim.setBackground(this.getBackground());
        gcim.fillRectangle(0, 0, interarea.getW(), interarea.getH());
        Point pigc = new Point();
        TCellUtil.GetGlobalCellXY(e, (IPoint)pigc);
        org.eclipse.swt.graphics.Point pe = new org.eclipse.swt.graphics.Point(pigc.getX(), pigc.getY());
        pe = this.contentsToView(pe.x, pe.y);
        SWTGC swtgc = new SWTGC((Device)this.getDisplay(), gcim);
        SWTPainter.PainterEvent p = new SWTPainter.PainterEvent((IGC)swtgc, e, this.getZoom(), this.getImageProvider(), this.focus, this.focus != null ? this.focus.hasFocus(e) : false, hs, this.getDefaultSelection().startPos, this.getDefaultSelection().endPos, 0, 0, interarea.getX(), interarea.getY(), interarea.getW(), interarea.getH(), interarea.getX(), interarea.getY(), interarea.getW() - interarea.getX() + pigc.getX(), interarea.getH() - interarea.getY() + pigc.getY());
        this.defaultPainterEventHandler.drawCell(p);
        GC ngc = new GC((Drawable)this.getViewControl());
        ngc.drawImage(dbuffer, 0, 0, e.getWidth(), e.getHeight(), pe.x, pe.y, e.getWidth(), e.getHeight());
        ngc.dispose();
        gcim.dispose();
        dbuffer.dispose();
        swtgc.dispose();
    }

    public void redraw(TCell e) {
        this.redraw((TAbstractCell)e);
    }

    public void scrollTo(String tag) {
        if (this.contentCell == null) {
            return;
        }
        TAbstractCell c = TCellUtil.SearchCellNamed(this.contentCell, tag);
        if (c == this.contentCell) {
            this.setContentsPos(0, 0);
            return;
        }
        if (c == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = tag;
            this.linkUnresolved.emit(objectArray);
            return;
        }
        this.scrollTo(c);
    }

    public ILineLayout.ILine getLineAtPosition(int lineNumber) {
        if (this.contentCell == null) {
            return null;
        }
        TCellParagraph lp = (TCellParagraph)this.contentCell.getLayout();
        int i = 0;
        ILineLayout.ILine lastLine = lp.getFirstLine();
        ILineLayout.ILine l = lp.getFirstLine();
        while (l != null) {
            if (i == lineNumber) break;
            ++i;
            lastLine = l;
            l = l.getNext();
        }
        return lastLine;
    }

    public void scrollTo(ILineLayout.ILine line) {
        if (line == null) {
            return;
        }
        TAbstractCell c = line.getFirst();
        if (c != null) {
            this.ensureVisible(c.getX(), c.getY(), c.getWidth(), c.getHeight(), 0x1000000);
        }
    }

    public void select(ILineLayout.ILine line) {
        if (line != null && line.getFirst() != null) {
            int len = 0;
            if (line.getLast() instanceof TCellText) {
                len += ((TCellText)line.getLast()).getLen();
            }
            this.setDefaultSelectionRange(line.getFirst().getPosition(), line.getLast().getPosition() + len - 1);
        } else {
            this.resetDefaultSelection();
        }
    }

    public void scrollTo(TAbstractCell cell) {
        if (cell == null) {
            return;
        }
        Point p = new Point();
        TCellUtil.GetGlobalCellXY(cell, (IPoint)p);
        if (!this.isVisible(p.getX(), p.getY(), cell.getWidth(), cell.getHeight())) {
            this.ensureVisible(p.getX(), p.getY(), cell.getWidth(), cell.getHeight(), 0x1000000);
        }
    }

    public void scrollTo(TCell cell) {
        this.scrollTo((TAbstractCell)cell);
    }

    public void search(String regexp) {
    }

    public void copy() {
        String s = this.getSelectedText();
        if (s == null) {
            return;
        }
        Clipboard clip = new Clipboard(this.getDisplay());
        TextTransfer tr = TextTransfer.getInstance();
        clip.setContents(new Object[]{s}, new Transfer[]{tr});
        clip.dispose();
    }

    private IRenderLocation locatePointInRenderable(int px, int py, IDRenderable gph, TAbstractCell cell) {
        IRender render_ = DRenderRegistry.GetRender((IDRenderable)gph);
        IRenderLocation loc = null;
        GC gcimg = new GC((Drawable)this);
        SWTGC igc = new SWTGC((Device)this.getDisplay(), gcimg);
        try {
            this.priv_locatePointInGraphic_rect.setSize(cell.getWidth(), cell.getHeight());
            TCellData celldata = cell instanceof TCellData ? (TCellData)cell : null;
            loc = render_.locate(px, py, (IGC)igc, (IRect)this.priv_locatePointInGraphic_rect, gph, this.getZoom(), this.getImageProvider(), (IVObject)celldata);
        }
        finally {
            gcimg.dispose();
            igc.dispose();
        }
        return loc;
    }

    public IDLink extractRenderableLink(IRenderLocation loc) {
        IDLink link = null;
        if (loc != null) {
            IDItem item = loc.getItem();
            link = item instanceof IDLink ? (IDLink)item : (IDLink)this.hasParent(item, IDLink.class);
        }
        return link;
    }

    public void selectAll() {
        if (this.contentCell == null) {
            return;
        }
        this.getDefaultSelection().setRange(0, this.lastPosition);
        this.redraw();
    }

    private void drawProgress(IDProgressMonitor monitor, IGC gc, int x, int y, int w, int h) {
        IBrush oldbrush = gc.setBrush((IBrush)new SolidBrush(255));
        Rect rect = new Rect(x, y, w - 1, h - 1);
        gc.setBrush((IBrush)new SolidBrush(RGBA.Get((int)220, (int)220, (int)220)));
        gc.fillRect((IRect)rect);
        gc.setBrush((IBrush)new SolidBrush(255));
        gc.drawRect((IRect)rect);
        IFont oldf = gc.setFont((IFont)new Font("", 14, 1));
        ISize s = gc.textExtent(monitor.getTaskName());
        int tx = (w - s.getW() - 18 - 5) / 2 + x;
        int ty = (h - s.getH()) / 2 + y;
        int sw = s.getW();
        int sh = s.getH();
        gc.drawText(monitor.getTaskName(), tx, ty);
        gc.setFont(oldf);
        gc.fillOval((tx += sw + 16) - 9, (ty += sh / 2) - 9, 18, 18);
        gc.setBrush((IBrush)new SolidBrush(RGBA.Get((int)255, (int)210, (int)0)));
        double prg = (double)monitor.getWorkCount() / (double)monitor.getTotalWorks() * (Math.PI * 2);
        gc.fillArc(tx, ty, 0.0, 9, 9, prg, 1.5707963267948966);
        gc.fillArc(tx, ty, 0.0, 9, 9, prg + Math.PI, 1.5707963267948966);
        gc.setBrush(oldbrush);
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        Rectangle area = this.getClientArea();
        TAbstractCellContainer cell = this.contentCell;
        if (cell == null) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, area.width, area.height);
            return;
        }
        SWTPainter.PainterEvent pe = new SWTPainter.PainterEvent(null, cell, this.getZoom(), this.getImageProvider(), this.focus, false, this.getDefaultSelection().isValid(), this.getDefaultSelection().startPos, this.getDefaultSelection().endPos, cell.getX(), cell.getY(), this.getContentsX(), this.getContentsY(), area.width, area.height, clipx, clipy, clipw, cliph);
        if (this.double_buffer) {
            Image dbuffer = null;
            GC gcim = null;
            SWTGC swtgc = null;
            try {
                if (this.getProgressMonitor().isInProgress()) {
                    int wi = 185 + this.getVerticalBarWidth() * 2;
                    int hi = 35 + this.getHorizontalBarHeight() * 2;
                    dbuffer = new Image((Device)this.getDisplay(), wi, hi);
                    gcim = new GC((Drawable)dbuffer);
                    gcim.setBackground(this.getBackground());
                    gcim.fillRectangle(0, 0, area.width, area.height);
                    swtgc = new SWTGC((Device)this.getDisplay(), gcim);
                    this.drawProgress(this.getProgressMonitor(), (IGC)swtgc, this.getVerticalBarWidth(), this.getHorizontalBarHeight(), 185, 35);
                    gc.drawImage(dbuffer, (area.width - wi) / 2, (area.height - hi) / 2);
                }
                dbuffer = new Image((Device)this.getDisplay(), area.width, area.height);
                gcim = new GC((Drawable)dbuffer);
                gcim.setBackground(this.getBackground());
                swtgc = new SWTGC((Device)this.getDisplay(), gcim);
                pe.gc = swtgc;
                gcim.fillRectangle(0, 0, area.width, area.height);
                this.defaultPainterEventHandler.drawCell(pe);
                gc.drawImage(dbuffer, 0, 0);
            }
            finally {
                if (gcim != null) {
                    gcim.dispose();
                }
                if (dbuffer != null) {
                    dbuffer.dispose();
                }
                if (swtgc != null) {
                    swtgc.dispose();
                }
            }
        } else {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, area.width, area.height);
            SWTGC swtgc = new SWTGC((Device)this.getDisplay(), gc);
            pe.gc = swtgc;
            this.defaultPainterEventHandler.drawCell(pe);
            swtgc.dispose();
        }
    }

    public void setMargins(int _top, int _bottom, int _left, int _right) {
        this.top = _top;
        this.bottom = _bottom;
        this.left = _left;
        this.right = _right;
    }

    public void setDefaultSelectionRange(int start, int end) {
        this.getDefaultSelection().setRange(start, end);
        this.redraw();
    }

    public void resetDefaultSelection() {
        this.getDefaultSelection().reset();
        this.redraw();
    }

    public Selection getDefaultSelection() {
        if (this.defaultSelection == null) {
            this.defaultSelection = new Selection();
        }
        return this.defaultSelection;
    }

    public boolean isShowExternalLinkTooltip() {
        return this.showExternalLinkTooltip;
    }

    public void setShowExternalLinkTooltip(boolean b) {
        this.showExternalLinkTooltip = b;
    }

    private void computeContentsSize() {
        if (this.contentCell != null) {
            this.resizeContents(this.contentCell.getWidth(), this.contentCell.getHeight());
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float f, boolean mr) {
        this.maintainRatio = mr;
        this.zoom = f;
        this.initialise();
        this.refresh();
    }

    public void nextFocusable() {
        if (this.contentCell == null) {
            return;
        }
        TAbstractCell start = this.focus == null ? this.contentCell : this.focus;
        try {
            TCellIterator i = new TCellIterator(start);
            TAbstractCell c = i.getNext();
            while (c != null) {
                if (c instanceof TCellFocusMark) {
                    this.setFocus((TCellFocusMark)c);
                    return;
                }
                c = i.getNext();
            }
            this.setFocus(null);
        }
        finally {
            this.scrollTo(this.focus);
        }
    }

    public void previousFocusable() {
        if (this.contentCell == null) {
            return;
        }
        if (this.focus == null) {
            return;
        }
        TCellFocusMark start = this.focus;
        TCellIterator i = new TCellIterator(start);
        TAbstractCell c = i.getPrevious();
        while (c != null) {
            if (c instanceof TCellFocusMark) {
                this.setFocus((TCellFocusMark)c);
                return;
            }
            c = i.getPrevious();
        }
        this.setFocus(null);
        if (this.getParent() != null) {
            this.getParent().setFocus();
        }
    }

    public SWTPainter getDefaultPainterEventHandler() {
        return this.defaultPainterEventHandler;
    }

    public void setDefaultPainterEventHandler(SWTPainter painterEventHandler) {
        this.defaultPainterEventHandler = painterEventHandler;
    }

    public MouseEventHandler getDefaultMouseEventHandler() {
        return this.defaultMouseEventHandler;
    }

    public void setDefaultMouseEventHandler(MouseEventHandler mouseEventHandler) {
        this.defaultMouseEventHandler = mouseEventHandler;
    }

    public KeyEventHandler getDefaultKeyEventHandler() {
        return this.defaultKeyEventHandler;
    }

    public void setDefaultKeyEventHandler(KeyEventHandler keyEventHandler) {
        this.defaultKeyEventHandler = keyEventHandler;
    }

    public boolean isMaintainRatio() {
        return this.maintainRatio;
    }

    public void setMaintainRatio(boolean maintainRatio) {
        this.maintainRatio = maintainRatio;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
        this.initialise();
        this.refresh();
    }

    public void startAccessibility() {
        this.getViewControl().getAccessible().setFocus(-1);
        if (this.getChildViewer() != null) {
            this.getViewControl().getAccessible().setFocus(0);
        } else if (this.focus != null) {
            this.getViewControl().getAccessible().setFocus(this.focus.hashCode());
        }
    }

    public boolean setFocus() {
        boolean v = this.getViewControl().setFocus();
        return v;
    }

    protected void setFocus(TCellFocusMark cell) {
        this.focus = cell;
        if (this.focus != null && this.focus.getItem() instanceof IDLink) {
            IDLink link = (IDLink)this.focus.getItem();
            if (this.prevlink != null) {
                this.unhighlightLink(this.prevlink);
            }
            Point p = new Point();
            TCellUtil.GetGlobalCellXY(this.focus, (IPoint)p);
            org.eclipse.swt.graphics.Point pswt = new org.eclipse.swt.graphics.Point(p.getX(), p.getY());
            pswt = this.contentsToView(pswt.x, pswt.y);
            pswt = this.toDisplay(pswt.x, pswt.y - 5);
            this.highlightLink(link, pswt);
            this.prevlink = link;
        }
        this.redraw();
    }

    public String getContentText() {
        if (this.contentCell != null) {
            return TCellUtil.GetTextRange(this.contentCell, 0, this.lastPosition);
        }
        return null;
    }

    public String getViewerName() {
        return this.name;
    }

    public void setViewerName(String n) {
        this.name = n;
        this.registry.putViewer(n, this);
    }

    public ViewerRegistry getViewerRegistry() {
        return this.registry;
    }

    public void setViewerRegistry(ViewerRegistry registry) {
        this.registry = registry;
    }

    public IDProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(IDProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public IDItem mapPointToIDItem(int x, int y) {
        if (this.contentCell == null) {
            return null;
        }
        TAbstractCell cell = TCellUtil.MapPointToCell(this.contentCell, (IPoint)new Point(x = this.viewToContentsX(x), y = this.viewToContentsY(y)));
        if (cell == null) {
            return null;
        }
        if (cell.getItem() instanceof IDRenderable) {
            int cx = 0;
            int cy = 0;
            TAbstractCell c = cell;
            while (c != null) {
                cx += c.getX();
                cy += c.getY();
                c = c.getParent();
            }
            int px = x - cx;
            int py = y - cy;
            IRenderLocation loc = this.locatePointInRenderable(px, py, (IDRenderable)cell.getItem(), cell);
            return loc.getItem();
        }
        return cell.getItem();
    }

    private static class ChildViewer {
        public SWTViewer viewer;
        public Shell shell;
        public String method;

        ChildViewer(Shell shell, SWTViewer viewer, String method) {
            this.shell = shell;
            this.viewer = viewer;
            this.method = method;
        }
    }

    private class DefaultProperties {
        public long toolipTimerDelay_ = 500L;
        public int topMargin = 0;
        public int bottomMargin = 0;
        public int leftMargin = 0;
        public int rightMargin = 0;
        public DGraphic activeMoveGrachic;
        public int moveGraphicx_ = 0;
        public int moveGraphicy_ = 0;

        private DefaultProperties() {
        }
    }

    public static class KeyEventHandler
    extends DExtensible {
        public void doMethod(IDLink link, DExtensible ext, Object event) {
            ViewerKeyEvent e = (ViewerKeyEvent)event;
            if (e.type == 1) {
                return;
            }
            Point p = new Point();
            TCellUtil.GetGlobalCellXY(e.cell, (IPoint)p);
            org.eclipse.swt.graphics.Point pswt = new org.eclipse.swt.graphics.Point(p.getX(), p.getY());
            pswt = e.viewer.contentsToView(pswt.x, pswt.y);
            pswt = e.viewer.toDisplay(pswt.x, pswt.y - 5);
            switch (e.event.keyCode) {
                case 13: {
                    e.viewer.activateLink(link, pswt);
                    e.handled = true;
                    e.handled = true;
                    break;
                }
                default: {
                    e.viewer.closeChildViewer();
                }
            }
        }

        public void doMethod(DGraphic graph, DExtensible ext, Object event) {
            if (graph.getFirstChild() instanceof DGraphic) {
                graph = (DGraphic)graph.getFirstChild();
            }
            ViewerKeyEvent e = (ViewerKeyEvent)event;
            e.handled = true;
            if (e.type == 2) {
                return;
            }
            e.viewer.closeChildViewer();
        }
    }

    public static class MouseEventHandler
    extends DExtensible {
        private IDLink prevGraphLink;

        public void doMethod(IDLink link, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            boolean bbutton1 = (e.event.stateMask & 0x80000) != 0 || e.event.button == 1;
            switch (e.type) {
                case 6: {
                    e.viewer.highlightLink(link, null);
                    break;
                }
                case 7: {
                    e.viewer.unhighlightLink(link);
                    break;
                }
                case 5: {
                    e.cursor = DLinkUtil.isPopupLink((IDLink)link) && "jscrib-tooltip".equals(DLinkUtil.getMethod((IDLink)link)) ? null : e.viewer.handCursor();
                    if (DLinkUtil.isInternalLink((IDLink)link) || !e.viewer.isShowExternalLinkTooltip()) break;
                    e.tooltip = link.getTarget();
                    break;
                }
                case 3: {
                    if (!bbutton1) break;
                    e.viewer.activateLink(link, null);
                    e.cursor = null;
                    e.handled = true;
                }
            }
        }

        public void doMethod(DDocument doc, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
            if (e.handled) {
                return;
            }
            e.cursor = null;
            e.handled = true;
        }

        public void doMethod(DSection section, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
            if (e.handled) {
                return;
            }
            e.cursor = null;
            e.handled = true;
        }

        public void doMethod(DTitle title, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
        }

        public void doMethod(DList list, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
        }

        public void doMethod(DFolder folder, DExtensible ext, Object arg) {
            if (!(arg instanceof ViewerMouseEvent)) {
                return;
            }
            ViewerMouseEvent e = (ViewerMouseEvent)arg;
            TCellFolder cell = (TCellFolder)e.cell;
            Point p = new Point();
            TCellUtil.GetGlobalCellXY(cell, (IPoint)p);
            int evt_x = e.event.x - p.getX();
            int evt_y = e.event.y - p.getY();
            TCellSymbol r = cell.getSymbolCell();
            if (Rect.Contains((IRect)r, (int)evt_x, (int)evt_y)) {
                e.cursor = new Cursor((Device)Display.getDefault(), 21);
                if (e.type == 3) {
                    folder.setOpen(!folder.isOpen());
                    e.viewer.resetDefaultSelection();
                    e.handled = true;
                    e.invalidate = true;
                }
                return;
            }
        }

        public void doMethod(DParagraph p, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
        }

        public void doMethod(DTag t, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
        }

        public void doMethod(DText text, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            IDLink link = null;
            switch (e.type) {
                case 6: 
                case 7: {
                    this._handleSelection(e, e.type);
                    if (e.handled) {
                        return;
                    }
                    link = e.viewer.getLinkFromCell(e);
                    if (link == null) break;
                    e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                    break;
                }
                case 3: {
                    link = e.viewer.getLinkFromCell(e);
                    if (link != null) {
                        e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                    }
                    if (e.handled) break;
                    this._handleSelection(e, e.type);
                    break;
                }
                case 5: {
                    this._handleSelection(e, e.type);
                    if (e.handled) {
                        return;
                    }
                    link = e.viewer.getLinkFromCell(e);
                    if (link == null) break;
                    e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                    break;
                }
                case 4: {
                    this._handleSelection(e, e.type);
                }
            }
        }

        public void doMethod(IDBasicItem basic_item, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            switch (e.type) {
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    IDLink link = e.viewer.getLinkFromCell(e);
                    if (link == null) break;
                    e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                }
            }
        }

        public void doMethod(DCellText celltext, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
            if (e.handled) {
                return;
            }
            e.cursor = null;
            e.handled = true;
        }

        public void doMethod(DCell cell, DExtensible ext, Object event) {
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            this._handleSelection(e, e.type);
            if (e.handled) {
                return;
            }
            e.cursor = null;
            e.handled = true;
        }

        public void doMethod(DPopup popup, DExtensible ext, Object event) {
        }

        public void doMethod(DGraphic graph, DExtensible ext, Object event) {
            if (graph.getFirstChild() instanceof DGraphic) {
                graph = (DGraphic)graph.getFirstChild();
            }
            ViewerMouseEvent e = (ViewerMouseEvent)event;
            e.handled = true;
            switch (e.type) {
                case 5: {
                    IDItem item;
                    boolean do_ttip;
                    if (DGraphic.CanMoves((DGraphic)graph)) {
                        e.cursor = e.viewer.graphicMovingCursor();
                    }
                    if ((e.event.stateMask & 0x80000) != 0 && ((SWTViewer)e.viewer).defaultProperties.activeMoveGrachic == graph && graph.canMoves()) {
                        e.viewer.move3DView(e, graph);
                        e.handled = true;
                        return;
                    }
                    int cx = 0;
                    int cy = 0;
                    TAbstractCell c = e.cell;
                    while (c != null) {
                        cx += c.getX();
                        cy += c.getY();
                        c = c.getParent();
                    }
                    int px = e.event.x - cx;
                    int py = e.event.y - cy;
                    IRenderLocation loc = e.viewer.locatePointInRenderable(px, py, (IDRenderable)graph, e.cell);
                    IDLink link = e.viewer.extractRenderableLink(loc);
                    boolean bl = do_ttip = loc != null;
                    if (link != null) {
                        String method = DLinkUtil.getMethod((String)link.getTarget());
                        boolean bl2 = do_ttip = !"jscrib-tooltip".equals(method);
                    }
                    if (do_ttip && (item = loc.getItem()) != null && !(item instanceof DCurve)) {
                        if (item instanceof DPoint) {
                            DPoint pt = (DPoint)item;
                            IDItem p = pt.getParent();
                            DCurve c2 = p instanceof DCurve ? (DCurve)p : null;
                            p = p.getParent();
                            String title = DefaultChartRenderData.getResourceString((String)c2.getName(), (DI18N)((DI18N)graph.getChildOfClass(DI18N.class)));
                            String t = c2 != null && title != null ? String.valueOf(title) + ": " : "";
                            IDItem ic = item.getFirstChild();
                            while (ic != null) {
                                IDCoord coord;
                                Object v;
                                if (ic instanceof IDCoord && (v = (coord = (IDCoord)ic).getValue(null)) != null) {
                                    DAxis a = coord.getAxis();
                                    UFormat f = null;
                                    if (t.length() > 0) {
                                        t = String.valueOf(t) + "  ";
                                    }
                                    if (a != null) {
                                        if (a.getTitle() != null) {
                                            t = String.valueOf(t) + a.getTitle() + "=";
                                        }
                                        try {
                                            f = (UFormat)a.getProperties().get("P_UNIT_FORMAT.DAxis.core.jscrib");
                                        }
                                        catch (ClassCastException classCastException) {}
                                    }
                                    ULocale locale = graph.getLocale();
                                    if (f == null) {
                                        if (v instanceof Number) {
                                            f = DecimalFormat.getInstance((ULocale)locale);
                                        } else if (v instanceof Date) {
                                            f = SimpleDateFormat.getDateInstance((int)3, (ULocale)locale);
                                        }
                                    }
                                    if (f != null) {
                                        try {
                                            t = String.valueOf(t) + f.format(v);
                                        }
                                        catch (Exception exception) {}
                                    } else {
                                        t = String.valueOf(t) + v.toString();
                                    }
                                    if (a != null && a.getUnit() != null) {
                                        t = String.valueOf(t) + " " + a.getUnit();
                                    }
                                }
                                ic = ic.getNext();
                            }
                            e.tooltip = t;
                        } else if (item instanceof DMarkerLine) {
                            DMarkerLine ml = (DMarkerLine)item;
                            e.tooltip = ml.getLabel() != null ? ml.getLabel() : "unamed marker line";
                            e.tooltip = String.valueOf(e.tooltip) + " : " + ml.getValue();
                        }
                    }
                    if (this.prevGraphLink != link) {
                        if (this.prevGraphLink != null) {
                            e.type = 7;
                            e.viewer.defaultMouseEventHandler.invokeDoMethod(this.prevGraphLink, this, e);
                        }
                        if (link != null) {
                            e.type = 6;
                            e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                        }
                        this.prevGraphLink = link;
                        return;
                    }
                    this.prevGraphLink = link;
                    if (link == null) break;
                    e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                    break;
                }
                case 3: {
                    IDLink link;
                    if (DGraphic.CanMoves((DGraphic)graph)) {
                        ((SWTViewer)e.viewer).defaultProperties.activeMoveGrachic = graph;
                        ((SWTViewer)e.viewer).defaultProperties.moveGraphicx_ = e.event.x;
                        ((SWTViewer)e.viewer).defaultProperties.moveGraphicy_ = e.event.y;
                    }
                    if ((link = e.viewer.getLinkFromCell(e)) != null) {
                        e.viewer.defaultMouseEventHandler.invokeDoMethod(link, this, e);
                    }
                    e.handled = true;
                    break;
                }
                case 4: {
                    ((SWTViewer)e.viewer).defaultProperties.activeMoveGrachic = null;
                }
            }
        }

        public void doMethod(DLine line, DExtensible ext, Object event) {
        }

        private void _handleSelection(ViewerMouseEvent e, int event_type) {
            Selection selection = e.viewer.getDefaultSelection();
            e.handled = false;
            if (selection == null) {
                return;
            }
            boolean bbutton1 = (e.event.stateMask & 0x80000) != 0 || e.event.button == 1;
            switch (event_type) {
                case 3: {
                    if (!bbutton1) break;
                    if (selection.isValid()) {
                        e.viewer.resetDefaultSelection();
                    }
                    e.viewer.closeChildViewer();
                    int p = this._detectSelectedChar(e);
                    if (p >= 0) {
                        selection.setRange(p, p);
                    }
                    selection.state = 2;
                    e.handled = true;
                    break;
                }
                case 4: {
                    if (!bbutton1 || selection.state != 2) break;
                    selection.state = 0;
                    Object[] params = new Object[]{e.viewer};
                    e.viewer.selectionChanged.emit(params);
                    e.handled = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (!bbutton1 || selection.getState() != 2) break;
                    int p = this._detectSelectedChar(e);
                    if (p >= 0) {
                        selection.setEndPosition(p);
                        Object[] params = new Object[]{e.viewer};
                        e.viewer.selectionChanged.emit(params);
                        e.viewer.redraw();
                    }
                    e.handled = true;
                    break;
                }
            }
        }

        private int _detectSelectedChar(ViewerMouseEvent e) {
            if (!(e.cell instanceof TCellText)) {
                return -1;
            }
            TCellText cell = (TCellText)e.cell;
            int posx = e.event.x;
            if (cell == null) {
                return -1;
            }
            IDItem item = cell.getItem();
            if (item == null) {
                return -1;
            }
            String ctext = cell.getText();
            if (ctext != null && ctext.length() > 0) {
                int cpos = cell.getPosition();
                ctext = ctext.substring(cell.getStart(), cell.getStart() + cell.getLen());
                int clen = ctext.length();
                GC gc = new GC((Drawable)e.viewer);
                SWTGC swtgc = new SWTGC((Device)e.viewer.getDisplay(), gc);
                Font newfont = IGCDStyle.GetFont((IDItem)item, (float)e.viewer.getZoom());
                swtgc.setFont((IFont)newfont);
                Point abs = new Point(0, 0);
                TCellUtil.GetGlobalCellXY(cell, (IPoint)abs);
                int clenx = posx - abs.getX();
                int i = 0;
                int result = 0;
                int diff = 0;
                while (i < clen) {
                    String tmptext = ctext.substring(0, i + 1);
                    ISize s = swtgc.textExtent(tmptext);
                    if (s.getW() >= clenx) {
                        diff = s.getW() - clenx;
                        if (diff >= (s = swtgc.textExtent(ctext.substring(i, i + 1))).getW() / 2) break;
                        ++i;
                        break;
                    }
                    ++i;
                }
                result = i;
                gc.dispose();
                swtgc.dispose();
                return cpos + result;
            }
            int dir = e.viewer.getDefaultSelection().endPos >= e.viewer.getDefaultSelection().startPos ? 1 : 2;
            TCellText i = TCellUtil.MapPointToClosestTextCell(e.cell, (IPoint)new Point(e.event.x, e.event.y), dir);
            if (i != null) {
                int p = dir == 1 ? i.getPosition() + i.getLen() - 1 : i.getPosition();
                return p;
            }
            return -1;
        }
    }

    public class Selection {
        public static final int SELECT_TERMINATED = 0;
        public static final int SELECT_STARTED = 2;
        private int state = 0;
        private int startPos = 0;
        private int endPos = 0;

        public void setRange(int start, int end) {
            if (start <= end) {
                this.startPos = start;
                this.endPos = end;
            } else {
                this.startPos = end;
                this.endPos = start;
            }
        }

        public void reset() {
            this.startPos = 0;
            this.endPos = 0;
        }

        public void setStartPosition(int p) {
            this.startPos = p;
        }

        public void setEndPosition(int p) {
            this.endPos = p;
        }

        public boolean isValid() {
            return this.getEndPosition() - this.getStartPosition() > 0;
        }

        public org.eclipse.swt.graphics.Point getRange() {
            return new org.eclipse.swt.graphics.Point(this.getStartPosition(), this.getEndPosition());
        }

        public int getStartPosition() {
            if (this.startPos < this.endPos) {
                return this.startPos;
            }
            return this.endPos;
        }

        public int getEndPosition() {
            if (this.startPos < this.endPos) {
                return this.endPos;
            }
            return this.startPos;
        }

        public int getState() {
            return this.state;
        }
    }

    private static final class Show {
        public static final int NORMAL = 0;
        public static final int PAGES = 1;
        public static final int ONE_PAGE = 2;
        public static final int TWO_PAGES = 3;
        public static final int FOUR_PAGES = 4;
        public static final int POPUP = 5;
        public static final int POPUP_DETACHED = 6;
        public static final int TOOLTIP = 7;
        private int mode = 0;

        private Show() {
        }

        public boolean mode(int nmode) {
            switch (nmode) {
                case 0: {
                    this.mode = nmode;
                    break;
                }
                case 1: {
                    this.mode = nmode;
                    break;
                }
                case 2: {
                    this.mode = nmode;
                    break;
                }
                case 3: {
                    this.mode = nmode;
                    break;
                }
                case 4: {
                    this.mode = nmode;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public int mode() {
            return this.mode;
        }
    }

    public static class ViewerEvent {
        public TAbstractCell cell;
        public SWTViewer viewer;
    }

    public static class ViewerKeyEvent
    extends ViewerEvent {
        public KeyEvent event;
        int type;
        public boolean handled;
        public String tooltip;
    }

    public static class ViewerMouseEvent
    extends ViewerEvent {
        public MouseEvent event;
        public int type;
        public boolean handled;
        public Cursor cursor;
        public String tooltip;
        public boolean invalidate;
    }

    public static class ViewerProgressMonitor
    extends SimpleProgressMonitor {
        private SWTViewer viewer;
        private int oldnb = 0;

        public ViewerProgressMonitor(SWTViewer v) {
            this.viewer = v;
        }

        public void beginTask(String name, int total_works) {
            super.beginTask(name, total_works);
        }

        public void done() {
            super.done();
            this.oldnb = 0;
        }

        public void setCanceled(boolean value) {
            super.setCanceled(value);
        }

        public void worked(int work) {
            super.worked(work);
            int prg = (int)((double)work / (double)this.getTotalWorks() * 100.0);
            if (prg > this.oldnb + 5) {
                this.viewer.redraw();
                this.viewer.update();
                this.oldnb = prg;
            }
        }
    }
}

