/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.internal;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.tptp.platform.report.core.internal.IDRegistry;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.signals.internal.Signal;

public class ViewerRegistry
implements IDRegistry,
DisposeListener {
    public static final Signal sgn_putViewer = new Signal("putViewer(org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer)");
    public static final Signal sgn_removeViewer = new Signal("removeViewer(String)");
    private Hashtable viewers = new Hashtable();

    public void clear() {
        this.viewers.clear();
    }

    public Iterator iterator() {
        return this.viewers.values().iterator();
    }

    public boolean contains(SWTViewer v) {
        return this.viewers.contains((Object)v);
    }

    public boolean contains(String name) {
        return this.viewers.contains(name);
    }

    public void removeViewer(String name) {
        this.viewers.remove(name);
        sgn_removeViewer.emit(new Object[]{name});
    }

    public void updateViewer(SWTViewer viewer) {
        if (this.viewers == null) {
            return;
        }
        String n = viewer.getViewerName();
        if (this.viewers.get(n) != null) {
            this.viewers.remove(n);
            sgn_removeViewer.emit(new Object[]{n});
            this.viewers.put(n, viewer);
            sgn_putViewer.emit(new Object[]{viewer});
        }
    }

    public boolean putViewer(String key, SWTViewer v) {
        if (v == null) {
            return false;
        }
        if (this.contains(key)) {
            return false;
        }
        this.viewers.put(key, v);
        v.addDisposeListener(this);
        sgn_putViewer.emit(new Object[]{v});
        return true;
    }

    public SWTViewer getViewer(String name) {
        return (SWTViewer)((Object)this.viewers.get(name));
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.getSource() instanceof SWTViewer) {
            this.removeViewer(((SWTViewer)((Object)e.getSource())).getViewerName());
        }
    }
}

