/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ICarriageReturn;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IContentProvider;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TExtensibleContentProvider;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellBorder
extends TAbstractCellContainer
implements ILayout,
IContentProvider,
ICarriageReturn {
    public static final int MARGIN = 3;
    private static final int SPACING = 2;
    protected boolean reversed_;

    public TCellBorder(DBorder item) {
        super((IDItem)item);
    }

    public ILayout getLayout() {
        return this;
    }

    public IContentProvider getContentProvider() {
        return this;
    }

    public IShape copyShape() {
        return this;
    }

    public void dump(int level) {
    }

    public int getBorderSize() {
        DBorder border = (DBorder)this.getItem();
        int line_size = 0;
        int line_type = border.getLineType();
        int i = 0;
        int m = 1;
        while (i < 8) {
            if ((m & line_type) != 0) {
                line_size = i + 1;
            }
            ++i;
            m <<= 1;
        }
        return line_size;
    }

    public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        int c_hintW = hintW;
        int c_hintH = hintH;
        DBorder border = (DBorder)cell.getItem();
        int border_size = this.getBorderSize();
        int shadow = border.getShadowDepth();
        int lm = 3 + border_size;
        int tm = 3 + border_size;
        int rm = 3 + border_size;
        int bm = 3 + border_size;
        switch (border.getShadowType()) {
            case 0: {
                shadow = 0;
                break;
            }
            case 1: 
            case 2: {
                rm += shadow;
                bm += shadow;
                break;
            }
            case 3: {
                lm += shadow;
                rm += shadow;
                tm += shadow;
                bm += shadow;
            }
        }
        if (c_hintW > 0) {
            c_hintW -= lm + rm;
        }
        if (c_hintH > 0) {
            c_hintH -= tm + bm;
        }
        int cw = 0;
        int ch = 0;
        TAbstractCell c = this.getChild();
        while (c != null) {
            c.computeSize(c_hintW, c_hintH, zoom, gc, monitor);
            cw = Math.max(cw, c.getW());
            ch += 2 + c.getH();
            c = c.getNext();
        }
        this.setSize(lm + cw + rm, tm + (ch -= 2) + bm);
    }

    public int layout(TAbstractCellContainer cell, float zoom, int char_position, IDProgressMonitor monitor) {
        cell.setPosition(char_position);
        DBorder border = (DBorder)cell.getItem();
        int border_size = this.getBorderSize();
        if (border.getShadowType() == 3) {
            border_size += border.getShadowDepth();
        }
        int x = this.reversed_ ? cell.getW() - 3 - border_size : border_size + 3;
        int y = 3 + border_size;
        TAbstractCell c = this.getChild();
        while (c != null) {
            c.setXY(this.reversed_ ? x - c.getW() : x, y);
            c.setPosition(char_position);
            y += c.getH() + 2;
            if (c instanceof TAbstractCellContainer) {
                TAbstractCellContainer cc = (TAbstractCellContainer)c;
                char_position = cc.getLayout().layout(cc, zoom, char_position, monitor);
            } else if (c instanceof TCellText) {
                char_position += ((TCellText)c).getLen();
            }
            c = c.getNext();
        }
        return char_position;
    }

    public boolean isReversed() {
        return this.reversed_;
    }

    public void setReversed(boolean _reversed) {
        this.reversed_ = _reversed;
    }

    public void fillContent(TAbstractCellContainer cell, IDItem fitem, IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup) {
        if (!(this.item instanceof DBorder)) {
            return;
        }
        DBorder border = (DBorder)fitem;
        Arg arg = new Arg(gc, pm, monitor, titleLevel, listLevel, flatPopup);
        TExtensibleContentProvider ext = TExtensibleContentProvider.getInstance();
        ext.doChildrenItem((IDItem)border, (DExtensible)ext, arg);
    }

    public boolean hasCRBefore() {
        return false;
    }

    public boolean hasCRAfter() {
        return false;
    }

    private class Arg
    implements TExtensibleContentProvider.IArg {
        protected DTitleLevel titleLevel_;
        protected DListLevel listLevel_;
        protected boolean flatPopup_;
        protected boolean draw_popup_;
        protected IGC gc_;
        protected IDIImageProvider pm_;
        protected IDProgressMonitor progressm;
        protected boolean first = true;

        public Arg(IGC gc, IDIImageProvider pm, IDProgressMonitor progress, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup) {
            this.gc_ = gc;
            this.pm_ = pm;
            this.titleLevel_ = titleLevel;
            this.listLevel_ = listLevel;
            this.flatPopup_ = flatPopup;
            this.progressm = progress;
        }

        public ILayout getLayout() {
            return TCellBorder.this;
        }

        public TAbstractCellContainer getContainer() {
            return TCellBorder.this;
        }

        public TAbstractCell getCell() {
            return TCellBorder.this;
        }

        public DTitleLevel getTitleLevel() {
            return this.titleLevel_;
        }

        public DListLevel getListLevel() {
            return this.listLevel_;
        }

        public boolean isFlatPopup() {
            return this.flatPopup_;
        }

        public boolean isDrawPopup() {
            return this.draw_popup_;
        }

        public void setDrawPopup(boolean v) {
        }

        public IGC getGc() {
            return this.gc_;
        }

        public IDIImageProvider getImageProvider() {
            return this.pm_;
        }

        public IDProgressMonitor getProgressMonitor() {
            return this.progressm;
        }

        public void addReturnValue(TAbstractCell arg) {
            TCellBorder.this.addCell(arg);
        }
    }
}

