/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ICarriageReturn;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IContentProvider;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellSymbol;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TExtensibleContentProvider;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellFolder
extends TAbstractCellContainer
implements ILayout,
IContentProvider,
ICarriageReturn {
    private static final int H_SPACING = 2;
    private static final int V_SPACING = 2;
    protected TCellSymbol symbol_cell_;
    protected ArrayList header_cells_ = new ArrayList();
    protected ArrayList body_cells_ = new ArrayList();
    protected boolean reversed_;

    public TCellFolder(DFolder item) {
        super((IDItem)item);
    }

    public TCellSymbol getSymbolCell() {
        return this.symbol_cell_;
    }

    public Iterator getHeaderCellIterator() {
        return this.header_cells_ != null ? this.header_cells_.iterator() : null;
    }

    public Iterator getBodyCellIterator() {
        return this.body_cells_ != null ? this.body_cells_.iterator() : null;
    }

    public ILayout getLayout() {
        return this;
    }

    public IContentProvider getContentProvider() {
        return this;
    }

    public IShape copyShape() {
        return this;
    }

    public void dump(int level) {
    }

    public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        int ch;
        if (this.symbol_cell_ == null) {
            return;
        }
        this.symbol_cell_.computeSize(-1, -1, zoom, gc);
        int hw = this.symbol_cell_.getW();
        int hh = this.symbol_cell_.getH();
        int h_hintW = hintW;
        if (h_hintW > 0) {
            h_hintW -= 4 + this.symbol_cell_.getW();
        }
        for (TAbstractCell c : this.header_cells_) {
            c.computeSize(h_hintW, hintH, zoom, gc, monitor);
            hw += 4 + c.getW();
            hh = Math.max(c.getH(), hh);
        }
        DFolderModel m = ((DFolder)this.getItem()).getFolderModel();
        if (m == null) {
            m = DFolderModel.GetDefault();
        }
        int indentation = 0;
        int b_hintW = hintW;
        if (m.isIndented()) {
            indentation += this.symbol_cell_.getW() + 4;
            if (hintW > 0) {
                b_hintW = Math.max(0, hintW - indentation);
            }
        }
        int bw = 0;
        int bh = 0;
        for (TAbstractCell c : this.body_cells_) {
            c.computeSize(b_hintW, hintH, zoom, gc, monitor);
            bw = Math.max(bw, c.getW());
            bh += 2 + c.getH();
        }
        int cw = Math.max(hw, bw += indentation);
        if (hintW > cw) {
            cw = hintW;
        }
        if (hintH > (ch = hh + 2 + bh)) {
            ch = hintH;
        }
        cell.setSize(cw, ch);
    }

    public int layout(TAbstractCellContainer cell, float zoom, int char_position, IDProgressMonitor monitor) {
        cell.setPosition(char_position);
        int x = this.reversed_ ? cell.getW() - 2 - this.symbol_cell_.getW() : 2;
        this.symbol_cell_.setXY(x, 2);
        x = this.reversed_ ? (x -= 2) : (x += this.symbol_cell_.getW() + 2);
        int hh = this.symbol_cell_.getH() + 2;
        for (TAbstractCell c : this.header_cells_) {
            if (this.reversed_) {
                x -= c.getW();
            }
            c.setXY(x, 0);
            c.setPosition(char_position);
            hh = Math.max(hh, c.getH());
            x = this.reversed_ ? (x -= 2) : (x += c.getW() + 2);
            if (c instanceof TAbstractCellContainer) {
                TAbstractCellContainer cc = (TAbstractCellContainer)c;
                char_position = cc.getLayout().layout(cc, zoom, char_position, monitor);
                continue;
            }
            if (!(c instanceof TCellText)) continue;
            char_position += ((TCellText)c).getLen();
        }
        int y = hh + 2;
        x = this.reversed_ ? cell.getW() : 0;
        DFolderModel m = ((DFolder)this.getItem()).getFolderModel();
        if (m == null) {
            m = DFolderModel.GetDefault();
        }
        if (m.isIndented()) {
            int sym_w = this.symbol_cell_.getW() + 4;
            x = this.reversed_ ? (x -= sym_w) : (x += sym_w);
        }
        for (TAbstractCell c : this.body_cells_) {
            c.setXY(this.reversed_ ? x - c.getW() : x, y);
            c.setPosition(char_position);
            y += c.getH() + 4;
            if (c instanceof TAbstractCellContainer) {
                TAbstractCellContainer cc = (TAbstractCellContainer)c;
                char_position = cc.getLayout().layout(cc, zoom, char_position, monitor);
                continue;
            }
            if (!(c instanceof TCellText)) continue;
            char_position += ((TCellText)c).getLen();
        }
        return char_position;
    }

    public boolean isReversed() {
        return this.reversed_;
    }

    public void setReversed(boolean _reversed) {
        this.reversed_ = _reversed;
    }

    public void fillContent(TAbstractCellContainer cell, IDItem fitem, IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup) {
        if (!(this.item instanceof DFolder)) {
            return;
        }
        DFolder folder = (DFolder)fitem;
        IDItem header = folder.getFirstChild();
        if (header == null) {
            return;
        }
        this.symbol_cell_ = new TCellSymbol((IDItem)folder);
        Arg arg = new Arg(gc, pm, monitor, titleLevel, listLevel, flatPopup);
        TExtensibleContentProvider ext = TExtensibleContentProvider.getInstance();
        boolean opened = folder.isOpen();
        IDItem item = folder.getFirstChild();
        while (item != null) {
            ext.invokeDoMethod(item, (DExtensible)ext, arg);
            if (!opened) break;
            item = item.getNext();
        }
    }

    public boolean hasCRBefore() {
        return true;
    }

    public boolean hasCRAfter() {
        return true;
    }

    private class Arg
    implements TExtensibleContentProvider.IArg {
        protected DTitleLevel titleLevel_;
        protected DListLevel listLevel_;
        protected boolean flatPopup_;
        protected boolean draw_popup_;
        protected IGC gc_;
        protected IDIImageProvider pm_;
        protected IDProgressMonitor progressm;
        protected boolean first = true;

        public Arg(IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup) {
            this.gc_ = gc;
            this.pm_ = pm;
            this.titleLevel_ = titleLevel;
            this.listLevel_ = listLevel;
            this.flatPopup_ = flatPopup;
            this.progressm = monitor;
        }

        public ILayout getLayout() {
            return TCellFolder.this;
        }

        public TAbstractCellContainer getContainer() {
            return TCellFolder.this;
        }

        public TAbstractCell getCell() {
            return TCellFolder.this;
        }

        public DTitleLevel getTitleLevel() {
            return this.titleLevel_;
        }

        public DListLevel getListLevel() {
            return this.listLevel_;
        }

        public boolean isFlatPopup() {
            return this.flatPopup_;
        }

        public boolean isDrawPopup() {
            return this.draw_popup_;
        }

        public void setDrawPopup(boolean v) {
        }

        public IGC getGc() {
            return this.gc_;
        }

        public IDIImageProvider getImageProvider() {
            return this.pm_;
        }

        public IDProgressMonitor getProgressMonitor() {
            return this.progressm;
        }

        public void addReturnValue(TAbstractCell arg) {
            IDItem ai = arg.getItem();
            IDItem hi = TCellFolder.this.getItem().getFirstChild();
            boolean is_header = false;
            while (ai != null) {
                if (ai == hi) {
                    is_header = true;
                    break;
                }
                ai = ai.getParent();
            }
            if (is_header) {
                TCellFolder.this.header_cells_.add(arg);
                this.first = false;
            } else {
                TCellFolder.this.body_cells_.add(arg);
            }
            TCellFolder.this.addCell(arg);
        }
    }
}

