/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellLinePrefix
extends TAbstractCell {
    private ISymbol symbol;
    private IDItem entryItem;
    private int level;
    private String number;

    public TCellLinePrefix(IDItem i) {
        super(i);
        this.symbol = DSymbolRegistry.GetOval();
    }

    public TCellLinePrefix(IDItem i, ISymbol _symbol, IDItem ei, int _level) {
        super(i);
        this.symbol = _symbol;
        this.entryItem = ei;
        this.level = _level;
    }

    public TCellLinePrefix(IDItem i, String _number, IDItem ei, int _level) {
        super(i);
        this.number = _number;
        this.entryItem = ei;
        this.level = _level;
    }

    public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        Font sfont = IGCDStyle.GetFont((IDItem)this.getEntryItem(), (float)zoom);
        IFont oldFont = gc.setFont((IFont)sfont);
        if (this.symbol == null && this.getNumber() != null) {
            ISize p = gc.textExtent(this.getNumber());
            this.setSize(p.getW(), p.getH());
        } else {
            int sizeH = gc.getFontMetrics().getHeight();
            this.setSize(sizeH / 3, sizeH);
        }
        gc.setFont(oldFont);
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(ISymbol symbol) {
        this.symbol = symbol;
    }

    public IDItem getEntryItem() {
        return this.entryItem;
    }

    public void setEntryItem(IDItem item) {
        this.entryItem = item;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int margin) {
        this.level = margin;
    }

    public void dump(int level) {
    }
}

