/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ICarriageReturn;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILineLayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellLinePrefix;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TExtensibleContentProvider;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TMLayoutContentCellContainer;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellParagraph
extends TMLayoutContentCellContainer
implements ILineLayout {
    Line firstLine;
    Line lastLine;
    float zoom = 1.0f;
    int alignment = 1;
    int maxLineWidth;
    int linesHeight;

    private void newLine() {
        Line l = new Line();
        if (this.firstLine == null) {
            this.firstLine = l;
        } else {
            this.lastLine.next = l;
        }
        this.lastLine = l;
    }

    private void newLineSpacing(int spacing) {
        Line l = new Line();
        l.height = spacing;
        if (this.firstLine == null) {
            this.firstLine = l;
        } else {
            this.lastLine.next = l;
        }
        this.linesHeight += l.height;
        this.lastLine = l;
        this.newLine();
    }

    private void addCellInLine(TAbstractCell c) {
        Line currentLine = this.lastLine;
        if (currentLine.first == null) {
            currentLine.first = c;
        }
        currentLine.last = c;
        currentLine.width += c.getWidth();
        this.maxLineWidth = Math.max(this.maxLineWidth, currentLine.width);
        this.linesHeight = Math.max(this.linesHeight, this.linesHeight + (c.getHeight() - currentLine.height));
        currentLine.height = Math.max(currentLine.height, c.getHeight());
    }

    private void addCarriageReturn(int h) {
        this.linesHeight = Math.max(this.linesHeight, this.linesHeight + (h - this.lastLine.height));
        this.lastLine.height = Math.max(this.lastLine.height, h);
    }

    private void wrapGetNextWord(String text, int w, Range r, int end, IGC gc) {
        String qs = text.substring(r.start, end);
        int wt = gc.textExtent(qs).getW();
        if (wt <= w) {
            r.end = wt;
            r.start = end;
        } else {
            int pos;
            int i = pos = w * qs.length() / wt;
            while (i > 0) {
                char c = qs.charAt(i);
                if (!(Character.getType(c) != 12 && Character.getType(c) != 22 && Character.getType(c) != 24 || (wt = gc.textExtent(qs.substring(0, i + 1)).getW()) > w && i != 1)) {
                    r.end = wt;
                    r.start = r.start + i + 1;
                    return;
                }
                --i;
            }
            int a = qs.length() / 2;
            int b = qs.length();
            while (b - a > 1) {
                String s = qs.substring(0, a + 1);
                wt = gc.textExtent(s).getW();
                if (wt <= w) {
                    a += (b - a) / 2;
                    continue;
                }
                b = a;
                a /= 2;
            }
            if (a == 0) {
                wt = gc.textExtent(qs.substring(0, 1)).getW();
                a = 1;
            }
            r.end = wt;
            r.start = a + r.start;
        }
    }

    private TCellText wrapPourTextBuffer(TCellText currentCell, IDItem item, String text, Range r, IGC gc, int hintW) {
        if (text.length() == 0) {
            return currentCell;
        }
        int count = r.end - r.start;
        IFontMetrics fm = gc.getFontMetrics();
        int lineSpacing = fm.getHeight();
        if (r.start >= r.end) {
            if (r.start == 0 && text.getBytes()[r.start] == 10) {
                currentCell.setSize(0, lineSpacing);
                currentCell.setLen(0);
                this.addCellInLine(currentCell);
            } else {
                this.addCarriageReturn(fm.getHeight());
            }
            return currentCell;
        }
        String qs = text.substring(r.start, r.end);
        ISize p = gc.textExtent(qs);
        if ((this.getAlignment() & 0x100) != 0 || this.lastLine.width + p.getW() <= hintW || hintW == -1) {
            if (r.start == 0) {
                currentCell.setText(text, r.start, count, fm.getDescent());
                currentCell.setSize(p.getW(), p.getH());
            } else {
                TCellText ct = new TCellText(item);
                currentCell.getParent().insertCell(ct, currentCell);
                ct.setText(text, r.start, count, fm.getDescent());
                ct.setSize(p.getW(), p.getH());
                currentCell = ct;
            }
            this.addCellInLine(currentCell);
            return currentCell;
        }
        Range r2 = new Range();
        r2.start = r.start;
        while (r2.start < r.end) {
            r2.end = 0;
            this.wrapGetNextWord(text, hintW - this.lastLine.width, r2, r.end, gc);
            count = r2.start - r.start;
            if (r.start == 0) {
                currentCell.setText(currentCell.getText(), r.start, count, gc.getFontMetrics().getDescent());
                currentCell.setSize(p.getW(), p.getH());
                currentCell.setSize(r2.end, lineSpacing);
            } else {
                TCellText ct = new TCellText(item);
                currentCell.getParent().insertCell(ct, currentCell);
                ct.setText(text, r.start, count, gc.getFontMetrics().getDescent());
                ct.setSize(r2.end, lineSpacing);
                currentCell = ct;
            }
            this.addCellInLine(currentCell);
            r.start = r2.start;
            if (r2.start >= r.end) continue;
            this.newLine();
        }
        return currentCell;
    }

    private TCellText wrapTextBuffer(TCellText currentCell, String text, IDItem t, int hintW, IGC gc, float zoom) {
        TAbstractCell c;
        TAbstractCell n = c = currentCell.getNext();
        while (c != null && c.getItem() == t) {
            n = c.getNext();
            c.getParent().removeCell(c);
            c = n;
        }
        if (text == null) {
            return currentCell;
        }
        IFont oldFont = gc.getFont();
        Font sfont = IGCDStyle.GetFont((IDItem)t, (float)zoom);
        gc.setFont((IFont)sfont);
        Range r = new Range();
        r.start = 0;
        r.end = text.indexOf("\n");
        while (r.end != -1) {
            currentCell = this.wrapPourTextBuffer(currentCell, t, text, r, gc, hintW);
            this.newLine();
            r.start = r.end + 1;
            r.end = text.indexOf("\n", r.start);
        }
        if (r.start < text.length()) {
            r.end = text.length();
            currentCell = this.wrapPourTextBuffer(currentCell, t, text, r, gc, hintW);
        }
        gc.setFont(oldFont);
        return currentCell;
    }

    public void fillContent(TAbstractCellContainer _cell, IDItem _item, IGC _gc, IDIImageProvider _pm, IDProgressMonitor monitor, DTitleLevel tl, DListLevel ll, boolean flatpopup) {
        if (_cell == null || _item == null) {
            throw new Error("TParagraphLayout: cell or item value null not expected");
        }
        _cell.dispose();
        _cell.setItem(_item);
        InfoP d = new InfoP();
        d.cell = _cell;
        d.gc = _gc;
        d.imageProvider = _pm;
        d.alignment = this.getAlignment();
        d.listLevel = ll;
        d.titleLevel = tl;
        d.flatpopup = flatpopup;
        d.pm = monitor;
        TExtensibleContentProvider.getInstance().doChildrenItem(_item, (DExtensible)TExtensibleContentProvider.getInstance(), d);
    }

    public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float _zoom, IGC _gc, IDProgressMonitor monitor) {
        if (hintW == cell.getWidth() && hintH >= cell.getHeight() && this.zoom == _zoom) {
            cell.setSize(hintW, hintH);
            return;
        }
        this.zoom = _zoom;
        int hintW_new = -1;
        if (hintW != -1) {
            hintW_new = hintW - (int)((float)(this.getLeftMargin() + this.getRightMargin()) * this.zoom);
        }
        int hintH_new = -1;
        if (hintH != -1) {
            hintH_new = hintH - (int)((float)(this.getTopMargin() + this.getBottomMargin()) * this.zoom);
        }
        this.firstLine = null;
        this.lastLine = null;
        this.linesHeight = 0;
        this.maxLineWidth = -1;
        this.newLine();
        boolean allfixed = true;
        monitor.setTotalWorks(monitor.getTotalWorks() + cell.getChildCount());
        TAbstractCell c = cell.getChild();
        while (c != null) {
            int w;
            int n = w = hintW_new == -1 ? hintW_new : Math.max(hintW_new, this.maxLineWidth);
            if (c instanceof TCellLinePrefix) {
                this.newLine();
                w = (int)((float)w - (float)(((TCellLinePrefix)c).getLevel() * 5 + 3) * this.zoom);
            } else if (c.getItem() instanceof DLine || c.getItem() instanceof DParagraph && !(c.getItem().getParent() instanceof DList) || c.getItem() instanceof DPopup || c.getItem() instanceof DTable) {
                this.newLine();
            } else if (c instanceof ICarriageReturn) {
                if (((ICarriageReturn)((Object)c)).hasCRBefore()) {
                    this.newLine();
                }
            } else if (c.getItem() instanceof DTitle) {
                this.newLineSpacing(5);
            }
            if (c instanceof TMLayoutContentCellContainer) {
                if (!((TMLayoutContentCellContainer)c).isFixedSize() && allfixed) {
                    allfixed = false;
                }
            } else {
                allfixed = DAlignment.HaveAlignment((int)this.getAlignment(), (int)256);
            }
            if (!(c instanceof TCellText)) {
                c.computeSize(w - this.lastLine.width, -1, this.zoom, _gc, monitor);
                if (c.getWidth() + this.lastLine.width <= w || DAlignment.HaveAlignment((int)this.getAlignment(), (int)256)) {
                    this.addCellInLine(c);
                } else {
                    this.newLine();
                    this.addCellInLine(c);
                }
                if (c.getItem() instanceof DLine || c.getItem() instanceof DParagraph || c.getItem() instanceof DTable) {
                    this.newLine();
                } else if (c instanceof ICarriageReturn && ((ICarriageReturn)((Object)c)).hasCRAfter()) {
                    this.newLine();
                }
            } else {
                c = this.wrapTextBuffer((TCellText)c, ((TCellText)c).getText(), c.getItem(), w, _gc, this.zoom);
            }
            monitor.worked(monitor.getWorkCount() + 1);
            c = c.getNext();
        }
        this.setFixedSize(allfixed);
        int retx = 0;
        int rety = 0;
        retx = this.getMaxLineWidth() < hintW_new ? hintW_new + (int)((float)(this.getLeftMargin() + this.getRightMargin()) * this.zoom) : this.getMaxLineWidth() + (int)((float)(this.getLeftMargin() + this.getRightMargin()) * this.zoom);
        rety = this.getLinesHeight() < hintH_new ? hintH_new + (int)((float)(this.getTopMargin() + this.getBottomMargin()) * this.zoom) : this.getLinesHeight() + (int)((float)(this.getTopMargin() + this.getBottomMargin()) * this.zoom);
        cell.setSize(retx, rety);
    }

    public int layout(TAbstractCellContainer cell, float zoom, int charpos, IDProgressMonitor monitor) {
        int align = this.getAlignment();
        int position = charpos;
        if (this.isReversed()) {
            if ((align & 1) != 0) {
                align = 2;
            } else if ((align & 2) != 0) {
                align = 1;
            }
        }
        int height = this.linesHeight;
        int currentY = this.getTopMargin();
        if ((align & 0x20) != 0) {
            currentY = (cell.getHeight() - height) / 2;
        } else if ((align & 8) != 0) {
            currentY = (int)((float)this.getTopMargin() * zoom);
        } else if ((align & 0x10) != 0) {
            currentY = cell.getHeight() - (int)((float)this.getBottomMargin() * zoom) - height;
        }
        monitor.setTotalWorks(monitor.getTotalWorks() + cell.getChildCount());
        Line l = this.firstLine;
        while (l != null) {
            int currentX = 0;
            if ((align & 1) != 0) {
                currentX = (int)((float)this.getLeftMargin() * zoom);
            } else if ((align & 2) != 0) {
                currentX = cell.getWidth() - l.width - (int)((float)this.getRightMargin() * zoom);
            } else if ((align & 4) != 0) {
                currentX = (cell.getWidth() - l.width) / 2;
            }
            TAbstractCell c = l.first;
            int maxDsc = 0;
            int maxTextH = 0;
            while (c != null) {
                if (c instanceof TCellText) {
                    if (((TCellText)c).getText() != null) {
                        maxTextH = Math.max(maxTextH, c.getHeight());
                    }
                    maxDsc = Math.max(maxDsc, ((TCellText)c).getDescent());
                }
                if (c == l.last) break;
                c = c.getNext();
            }
            c = this.isReversed() ? l.last : l.first;
            TAbstractCell last = this.isReversed() ? l.first : l.last;
            while (c != null) {
                int yoffset = 0;
                if (c instanceof TCellText) {
                    TCellText ct = (TCellText)c;
                    if (ct.getDescent() == 0) {
                        if (DAlignment.HaveAlignment((int)align, (int)32)) {
                            yoffset = (l.height - c.getHeight()) / 2;
                        } else if (DAlignment.HaveAlignment((int)align, (int)16)) {
                            yoffset = l.height - c.getHeight();
                        }
                    } else {
                        yoffset = DAlignment.HaveAlignment((int)this.getAlignment(), (int)32) ? l.height / 2 - maxTextH / 2 + maxTextH - maxDsc + ct.getDescent() - c.getHeight() : (DAlignment.HaveAlignment((int)this.getAlignment(), (int)16) ? l.height - maxDsc + ct.getDescent() - c.getHeight() : -maxDsc + ct.getDescent() + maxTextH - c.getHeight());
                    }
                }
                if (c instanceof TCellLinePrefix && DAlignment.HaveAlignment((int)align, (int)1)) {
                    TCellLinePrefix le = (TCellLinePrefix)c;
                    currentX += (int)((float)(le.getLevel() * 5) * zoom);
                }
                c.setPosition(position);
                c.setXY(currentX, currentY + yoffset);
                if (c instanceof TAbstractCellContainer) {
                    position = ((TAbstractCellContainer)c).layout(zoom, position, monitor);
                } else if (c instanceof TCellText) {
                    position += ((TCellText)c).getLen();
                }
                currentX += c.getWidth();
                if (c instanceof TCellLinePrefix && DAlignment.HaveAlignment((int)align, (int)1) || c.getItem() instanceof DTitle) {
                    currentX += (int)(3.0f * zoom);
                }
                if (c == last) break;
                c = this.isReversed() ? c.getPrevious() : c.getNext();
                monitor.worked(monitor.getWorkCount() + 1);
            }
            currentY += l.height;
            l = l.next;
        }
        return position;
    }

    public TCellParagraph(IDItem i, ILayout parent, int align) {
        super(i);
        this.setAlignment(align);
        if (parent == null) {
            return;
        }
        this.setReversed(parent.isReversed());
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public int getLinesHeight() {
        return this.linesHeight;
    }

    public int getLineCount() {
        int i = 0;
        ILineLayout.ILine l = this.getFirstLine();
        while (l != null) {
            ++i;
            l = l.getNext();
        }
        return i;
    }

    public ILineLayout.ILine getLineAt(int i) {
        int n = 0;
        ILineLayout.ILine l = this.getFirstLine();
        while (l != null) {
            if (i >= n) {
                return l;
            }
            l = l.getNext();
        }
        return null;
    }

    public ILineLayout.ILine getFirstLine() {
        return this.firstLine;
    }

    public ILineLayout.ILine getLastLine() {
        return this.lastLine;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    private class InfoP
    implements TExtensibleContentProvider.IArg {
        public TAbstractCellContainer cell;
        public TAbstractCell currentCell;
        public IGC gc;
        public IDIImageProvider imageProvider;
        public int hintW;
        public int hintH;
        public float zoom;
        public boolean flatpopup;
        public boolean drawPopup;
        public IDProgressMonitor pm;
        public int alignment;
        public int position;
        public int xoffset;
        DListLevel listLevel;
        DTitleLevel titleLevel;

        private InfoP() {
        }

        public IGC getGc() {
            return this.gc;
        }

        public IDIImageProvider getImageProvider() {
            return this.imageProvider;
        }

        public DListLevel getListLevel() {
            return this.listLevel;
        }

        public DTitleLevel getTitleLevel() {
            return this.titleLevel;
        }

        public boolean isDrawPopup() {
            return this.drawPopup;
        }

        public boolean isFlatPopup() {
            return this.flatpopup;
        }

        public void setDrawPopup(boolean v) {
            this.drawPopup = v;
        }

        public TAbstractCellContainer getContainer() {
            return this.cell;
        }

        public TAbstractCell getCell() {
            return this.currentCell;
        }

        public ILayout getLayout() {
            return TCellParagraph.this;
        }

        public IDProgressMonitor getProgressMonitor() {
            return this.pm;
        }

        public void addReturnValue(TAbstractCell c) {
            this.currentCell = this.cell.addCell(c);
        }
    }

    private class Line
    implements ILineLayout.ILine {
        public TAbstractCell first;
        public TAbstractCell last;
        public int width;
        public int height;
        public Line next;

        private Line() {
        }

        public TAbstractCell getFirst() {
            return this.first;
        }

        public TAbstractCell getLast() {
            return this.last;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ILineLayout.ILine getNext() {
            return this.next;
        }
    }

    private class Range {
        int start;
        int end;

        private Range() {
        }
    }
}

