/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellData;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TCellRenderable
extends TCellData {
    public TCellRenderable(IDRenderable i) {
        super((IDItem)i);
    }

    public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) {
        int w = hintW;
        int h = hintW;
        if (this.getItem() instanceof DGraphic) {
            float ratio;
            DGraphic g = (DGraphic)this.getItem();
            w = (int)((float)hintW * g.getWidthScale());
            h = (int)((float)hintW * g.getHeightScale());
            int max_w = g.getProperties().get("P_MAX_WIDTH.DGraphic.core.jscrib", w);
            int min_w = g.getProperties().get("P_MIN_WIDTH.DGraphic.core.jscrib", w);
            int max_h = g.getProperties().get("P_MAX_HEIGHT.DGraphic.core.jscrib", h);
            int min_h = g.getProperties().get("P_MIN_HEIGHT.DGraphic.core.jscrib", h);
            if (w < min_w) {
                w = min_w;
            } else if (w > max_w) {
                w = max_w;
            }
            if (h < min_h) {
                h = min_h;
            } else if (h > max_h) {
                h = max_h;
            }
            if (!(g.getProperties().hasKey("P_MIN_WIDTH.DGraphic.core.jscrib") || g.getProperties().hasKey("P_MAX_WIDTH.DGraphic.core.jscrib") || g.getProperties().hasKey("P_MIN_HEIGHT.DGraphic.core.jscrib") || g.getProperties().hasKey("P_MAX_HEIGHT.DGraphic.core.jscrib") || !((ratio = g.getWidthScale() / g.getHeightScale()) <= 1.0f))) {
                min_w = (int)(200.0f * zoom);
                if (w < min_w) {
                    w = min_w;
                    h = (int)((float)w / ratio);
                } else {
                    min_h = (int)(200.0f * zoom);
                    if (h < min_h) {
                        h = min_h;
                        w = (int)((float)h * ratio);
                    }
                }
            }
        } else {
            IDRenderable r = (IDRenderable)this.getItem();
            w = (int)((float)hintW * r.getWidthScale());
            h = (int)((float)hintW * r.getHeightScale());
        }
        this.setSize(w, h);
    }
}

