/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;

public class TCellUtil {
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = 2;

    public static TAbstractCell MapPointToCell(TAbstractCell cell, IPoint p) {
        if (cell == null) {
            return null;
        }
        if (!cell.contains(p.getX(), p.getY())) {
            return null;
        }
        p.setX(p.getX() - cell.getX());
        p.setY(p.getY() - cell.getY());
        TAbstractCell i = cell.getChild();
        while (i != null) {
            TAbstractCell cf = TCellUtil.MapPointToCell(i, p);
            if (cf != null) {
                return cf;
            }
            i = i.getNext();
        }
        return cell;
    }

    public static TAbstractCell MapPositionToCell(TAbstractCell cell, int pos) {
        if (cell == null) {
            return null;
        }
        TAbstractCell i = cell.getChild();
        while (i != null) {
            TAbstractCell cf = TCellUtil.MapPositionToCell(i, pos);
            if (cf != null) {
                return cf;
            }
            i = i.getNext();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TCellText MapPointToClosestTextCell(TAbstractCell cell, IPoint p, int dir) {
        if (cell == null) {
            return null;
        }
        int x = p.getX() - cell.getX();
        int y = p.getY() - cell.getY();
        TCellText prev = null;
        TAbstractCell i = cell.getChild();
        while (i != null) {
            TCellText cf = TCellUtil.MapPointToClosestTextCell(i, p, dir);
            if (cf != null) {
                return cf;
            }
            if (i instanceof TCellText) {
                if (i.getY() + i.getHeight() < y) {
                    prev = (TCellText)i;
                } else if (dir == 1) {
                    if (i.getX() + i.getWidth() >= x || i.getY() >= y) return prev;
                    prev = (TCellText)i;
                } else {
                    if (i.getX() > x) {
                        return (TCellText)i;
                    }
                    prev = (TCellText)i;
                }
            }
            i = i.getNext();
        }
        return null;
    }

    public static TAbstractCell SearchCellNamed(TAbstractCell cell, String tag) {
        String t;
        if (cell == null) {
            return null;
        }
        if (cell.getItem() != null && cell.getItem() instanceof IDTaggedItem && (t = ((IDTaggedItem)cell.getItem()).getTag()) != null && t.equals(tag)) {
            return cell;
        }
        TAbstractCell i = cell.getChild();
        while (i != null) {
            TAbstractCell j = TCellUtil.SearchCellNamed(i, tag);
            if (j != null) {
                return j;
            }
            i = i.getNext();
        }
        return null;
    }

    public static void GetGlobalCellXY(TAbstractCell cell, IPoint p) {
        if (cell == null) {
            return;
        }
        p.setX(cell.getX());
        p.setY(cell.getY());
        TAbstractCellContainer c = cell.getParent();
        while (c != null) {
            p.setX(p.getX() + c.getX());
            p.setY(p.getY() + c.getY());
            c = c.getParent();
        }
    }

    public static String GetTextRange(TAbstractCell cell, int begpos, int lastpos) {
        String result = new String();
        if (cell == null) {
            return null;
        }
        TAbstractCell i = cell.getChild();
        while (i != null) {
            TCellText ct;
            String text;
            String j;
            if (i.getChild() != null && (j = TCellUtil.GetTextRange(i, begpos, lastpos)) != null) {
                result = String.valueOf(result) + j;
            }
            if (i instanceof TCellText && (text = (ct = (TCellText)i).getText()) != null) {
                if (ct.getPosition() <= begpos && begpos < ct.getPosition() + ct.getLen()) {
                    int startpos = begpos - ct.getPosition() + ct.getStart();
                    if (lastpos < ct.getPosition() + ct.getLen()) {
                        return text.substring(startpos, lastpos - ct.getPosition() + ct.getStart() + 1);
                    }
                    result = text.substring(startpos, ct.getStart() + ct.getLen());
                } else {
                    if (ct.getPosition() <= lastpos && lastpos < ct.getPosition() + ct.getLen()) {
                        return String.valueOf(result) + text.substring(ct.getStart(), lastpos - ct.getPosition() + ct.getStart() + 1);
                    }
                    if (i.getPosition() > begpos && lastpos > i.getPosition() + ct.getLen()) {
                        result = String.valueOf(result) + text.substring(ct.getStart(), ct.getStart() + ct.getLen());
                    }
                }
            }
            i = i.getNext();
        }
        return result;
    }
}

